/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GitHubCodeDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GitHubCodeDestination> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GitHubCodeDestination.getter(GitHubCodeDestination::name)).setter(GitHubCodeDestination.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GitHubCodeDestination.getter(GitHubCodeDestination::description)).setter(GitHubCodeDestination.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GitHubCodeDestination.getter(GitHubCodeDestination::type)).setter(GitHubCodeDestination.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(GitHubCodeDestination.getter(GitHubCodeDestination::owner)).setter(GitHubCodeDestination.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<Boolean> PRIVATE_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("privateRepository").getter(GitHubCodeDestination.getter(GitHubCodeDestination::privateRepository)).setter(GitHubCodeDestination.setter(Builder::privateRepository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateRepository").build()}).build();
    private static final SdkField<Boolean> ISSUES_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("issuesEnabled").getter(GitHubCodeDestination.getter(GitHubCodeDestination::issuesEnabled)).setter(GitHubCodeDestination.setter(Builder::issuesEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuesEnabled").build()}).build();
    private static final SdkField<String> TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("token").getter(GitHubCodeDestination.getter(GitHubCodeDestination::token)).setter(GitHubCodeDestination.setter(Builder::token)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, OWNER_FIELD, PRIVATE_REPOSITORY_FIELD, ISSUES_ENABLED_FIELD, TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String type;
    private final String owner;
    private final Boolean privateRepository;
    private final Boolean issuesEnabled;
    private final String token;

    private GitHubCodeDestination(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.owner = builder.owner;
        this.privateRepository = builder.privateRepository;
        this.issuesEnabled = builder.issuesEnabled;
        this.token = builder.token;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String type() {
        return this.type;
    }

    public String owner() {
        return this.owner;
    }

    public Boolean privateRepository() {
        return this.privateRepository;
    }

    public Boolean issuesEnabled() {
        return this.issuesEnabled;
    }

    public String token() {
        return this.token;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuesEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitHubCodeDestination)) {
            return false;
        }
        GitHubCodeDestination other = (GitHubCodeDestination)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.privateRepository(), other.privateRepository()) && Objects.equals(this.issuesEnabled(), other.issuesEnabled()) && Objects.equals(this.token(), other.token());
    }

    public String toString() {
        return ToString.builder((String)"GitHubCodeDestination").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Type", (Object)this.type()).add("Owner", (Object)this.owner()).add("PrivateRepository", (Object)this.privateRepository()).add("IssuesEnabled", (Object)this.issuesEnabled()).add("Token", (Object)(this.token() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "privateRepository": {
                return Optional.ofNullable(clazz.cast(this.privateRepository()));
            }
            case "issuesEnabled": {
                return Optional.ofNullable(clazz.cast(this.issuesEnabled()));
            }
            case "token": {
                return Optional.ofNullable(clazz.cast(this.token()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GitHubCodeDestination, T> g) {
        return obj -> g.apply((GitHubCodeDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String type;
        private String owner;
        private Boolean privateRepository;
        private Boolean issuesEnabled;
        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(GitHubCodeDestination model) {
            this.name(model.name);
            this.description(model.description);
            this.type(model.type);
            this.owner(model.owner);
            this.privateRepository(model.privateRepository);
            this.issuesEnabled(model.issuesEnabled);
            this.token(model.token);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Boolean getPrivateRepository() {
            return this.privateRepository;
        }

        @Override
        public final Builder privateRepository(Boolean privateRepository) {
            this.privateRepository = privateRepository;
            return this;
        }

        public final void setPrivateRepository(Boolean privateRepository) {
            this.privateRepository = privateRepository;
        }

        public final Boolean getIssuesEnabled() {
            return this.issuesEnabled;
        }

        @Override
        public final Builder issuesEnabled(Boolean issuesEnabled) {
            this.issuesEnabled = issuesEnabled;
            return this;
        }

        public final void setIssuesEnabled(Boolean issuesEnabled) {
            this.issuesEnabled = issuesEnabled;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public GitHubCodeDestination build() {
            return new GitHubCodeDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GitHubCodeDestination> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder owner(String var1);

        public Builder privateRepository(Boolean var1);

        public Builder issuesEnabled(Boolean var1);

        public Builder token(String var1);
    }
}

