/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Location and destination information about the source code files provided with the project request. The source code
 * is uploaded to the new project source repository after project creation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Code implements SdkPojo, Serializable, ToCopyableBuilder<Code.Builder, Code> {
    private static final SdkField<CodeSource> SOURCE_FIELD = SdkField.<CodeSource> builder(MarshallingType.SDK_POJO)
            .memberName("source").getter(getter(Code::source)).setter(setter(Builder::source)).constructor(CodeSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<CodeDestination> DESTINATION_FIELD = SdkField
            .<CodeDestination> builder(MarshallingType.SDK_POJO).memberName("destination").getter(getter(Code::destination))
            .setter(setter(Builder::destination)).constructor(CodeDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final CodeSource source;

    private final CodeDestination destination;

    private Code(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
    }

    /**
     * <p>
     * The location where the source code files provided with the project request are stored. AWS CodeStar retrieves the
     * files during project creation.
     * </p>
     * 
     * @return The location where the source code files provided with the project request are stored. AWS CodeStar
     *         retrieves the files during project creation.
     */
    public CodeSource source() {
        return source;
    }

    /**
     * <p>
     * The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit or GitHub. After AWS CodeStar
     * provisions the new repository, the source code files provided with the project request are placed in the
     * repository.
     * </p>
     * 
     * @return The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit or GitHub. After AWS
     *         CodeStar provisions the new repository, the source code files provided with the project request are
     *         placed in the repository.
     */
    public CodeDestination destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Code)) {
            return false;
        }
        Code other = (Code) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(destination(), other.destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Code").add("Source", source()).add("Destination", destination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Code, T> g) {
        return obj -> g.apply((Code) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Code> {
        /**
         * <p>
         * The location where the source code files provided with the project request are stored. AWS CodeStar retrieves
         * the files during project creation.
         * </p>
         * 
         * @param source
         *        The location where the source code files provided with the project request are stored. AWS CodeStar
         *        retrieves the files during project creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(CodeSource source);

        /**
         * <p>
         * The location where the source code files provided with the project request are stored. AWS CodeStar retrieves
         * the files during project creation.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeSource.Builder} avoiding the need to create
         * one manually via {@link CodeSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeSource.Builder#build()} is called immediately and its result
         * is passed to {@link #source(CodeSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link CodeSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(CodeSource)
         */
        default Builder source(Consumer<CodeSource.Builder> source) {
            return source(CodeSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit or GitHub. After AWS CodeStar
         * provisions the new repository, the source code files provided with the project request are placed in the
         * repository.
         * </p>
         * 
         * @param destination
         *        The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit or GitHub. After AWS
         *        CodeStar provisions the new repository, the source code files provided with the project request are
         *        placed in the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(CodeDestination destination);

        /**
         * <p>
         * The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit or GitHub. After AWS CodeStar
         * provisions the new repository, the source code files provided with the project request are placed in the
         * repository.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeDestination.Builder} avoiding the need to
         * create one manually via {@link CodeDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(CodeDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link CodeDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(CodeDestination)
         */
        default Builder destination(Consumer<CodeDestination.Builder> destination) {
            return destination(CodeDestination.builder().applyMutation(destination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CodeSource source;

        private CodeDestination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(Code model) {
            source(model.source);
            destination(model.destination);
        }

        public final CodeSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        @Override
        public final Builder source(CodeSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(CodeSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final CodeDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(CodeDestination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(CodeDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public Code build() {
            return new Code(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
