/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserProfileResponse extends CodeStarResponse implements
        ToCopyableBuilder<CreateUserProfileResponse.Builder, CreateUserProfileResponse> {
    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userArn").getter(getter(CreateUserProfileResponse::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateUserProfileResponse::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("emailAddress").getter(getter(CreateUserProfileResponse::emailAddress))
            .setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sshPublicKey").getter(getter(CreateUserProfileResponse::sshPublicKey))
            .setter(setter(Builder::sshPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sshPublicKey").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTimestamp").getter(getter(CreateUserProfileResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTimestamp").getter(getter(CreateUserProfileResponse::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(USER_ARN_FIELD, DISPLAY_NAME_FIELD, EMAIL_ADDRESS_FIELD, SSH_PUBLIC_KEY_FIELD, CREATED_TIMESTAMP_FIELD,
                    LAST_MODIFIED_TIMESTAMP_FIELD));

    private final String userArn;

    private final String displayName;

    private final String emailAddress;

    private final String sshPublicKey;

    private final Instant createdTimestamp;

    private final Instant lastModifiedTimestamp;

    private CreateUserProfileResponse(BuilderImpl builder) {
        super(builder);
        this.userArn = builder.userArn;
        this.displayName = builder.displayName;
        this.emailAddress = builder.emailAddress;
        this.sshPublicKey = builder.sshPublicKey;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user in IAM.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user in IAM.
     */
    public String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The name that is displayed as the friendly name for the user in AWS CodeStar.
     * </p>
     * 
     * @return The name that is displayed as the friendly name for the user in AWS CodeStar.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The email address that is displayed as part of the user's profile in AWS CodeStar.
     * </p>
     * 
     * @return The email address that is displayed as part of the user's profile in AWS CodeStar.
     */
    public String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The SSH public key associated with the user in AWS CodeStar. This is the public portion of the public/private
     * keypair the user can use to access project resources if a project owner allows the user remote access to those
     * resources.
     * </p>
     * 
     * @return The SSH public key associated with the user in AWS CodeStar. This is the public portion of the
     *         public/private keypair the user can use to access project resources if a project owner allows the user
     *         remote access to those resources.
     */
    public String sshPublicKey() {
        return sshPublicKey;
    }

    /**
     * <p>
     * The date the user profile was created, in timestamp format.
     * </p>
     * 
     * @return The date the user profile was created, in timestamp format.
     */
    public Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The date the user profile was last modified, in timestamp format.
     * </p>
     * 
     * @return The date the user profile was last modified, in timestamp format.
     */
    public Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserProfileResponse)) {
            return false;
        }
        CreateUserProfileResponse other = (CreateUserProfileResponse) obj;
        return Objects.equals(userArn(), other.userArn()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(sshPublicKey(), other.sshPublicKey())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateUserProfileResponse").add("UserArn", userArn())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SshPublicKey", sshPublicKey()).add("CreatedTimestamp", createdTimestamp())
                .add("LastModifiedTimestamp", lastModifiedTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "emailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "sshPublicKey":
            return Optional.ofNullable(clazz.cast(sshPublicKey()));
        case "createdTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "lastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserProfileResponse, T> g) {
        return obj -> g.apply((CreateUserProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserProfileResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user in IAM.
         * </p>
         * 
         * @param userArn
         *        The Amazon Resource Name (ARN) of the user in IAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The name that is displayed as the friendly name for the user in AWS CodeStar.
         * </p>
         * 
         * @param displayName
         *        The name that is displayed as the friendly name for the user in AWS CodeStar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The email address that is displayed as part of the user's profile in AWS CodeStar.
         * </p>
         * 
         * @param emailAddress
         *        The email address that is displayed as part of the user's profile in AWS CodeStar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The SSH public key associated with the user in AWS CodeStar. This is the public portion of the public/private
         * keypair the user can use to access project resources if a project owner allows the user remote access to
         * those resources.
         * </p>
         * 
         * @param sshPublicKey
         *        The SSH public key associated with the user in AWS CodeStar. This is the public portion of the
         *        public/private keypair the user can use to access project resources if a project owner allows the user
         *        remote access to those resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKey(String sshPublicKey);

        /**
         * <p>
         * The date the user profile was created, in timestamp format.
         * </p>
         * 
         * @param createdTimestamp
         *        The date the user profile was created, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The date the user profile was last modified, in timestamp format.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The date the user profile was last modified, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);
    }

    static final class BuilderImpl extends CodeStarResponse.BuilderImpl implements Builder {
        private String userArn;

        private String displayName;

        private String emailAddress;

        private String sshPublicKey;

        private Instant createdTimestamp;

        private Instant lastModifiedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserProfileResponse model) {
            super(model);
            userArn(model.userArn);
            displayName(model.displayName);
            emailAddress(model.emailAddress);
            sshPublicKey(model.sshPublicKey);
            createdTimestamp(model.createdTimestamp);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
        }

        public final String getUserArn() {
            return userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getSshPublicKey() {
            return sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public CreateUserProfileResponse build() {
            return new CreateUserProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
