/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the GitHub repository to be created in AWS CodeStar. This is where the source code files provided
 * with the project request will be uploaded after project creation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GitHubCodeDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<GitHubCodeDestination.Builder, GitHubCodeDestination> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GitHubCodeDestination::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GitHubCodeDestination::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GitHubCodeDestination::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(GitHubCodeDestination::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<Boolean> PRIVATE_REPOSITORY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("privateRepository").getter(getter(GitHubCodeDestination::privateRepository))
            .setter(setter(Builder::privateRepository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateRepository").build()).build();

    private static final SdkField<Boolean> ISSUES_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("issuesEnabled").getter(getter(GitHubCodeDestination::issuesEnabled))
            .setter(setter(Builder::issuesEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuesEnabled").build()).build();

    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("token")
            .getter(getter(GitHubCodeDestination::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            TYPE_FIELD, OWNER_FIELD, PRIVATE_REPOSITORY_FIELD, ISSUES_ENABLED_FIELD, TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String type;

    private final String owner;

    private final Boolean privateRepository;

    private final Boolean issuesEnabled;

    private final String token;

    private GitHubCodeDestination(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.owner = builder.owner;
        this.privateRepository = builder.privateRepository;
        this.issuesEnabled = builder.issuesEnabled;
        this.token = builder.token;
    }

    /**
     * <p>
     * Name of the GitHub repository to be created in AWS CodeStar.
     * </p>
     * 
     * @return Name of the GitHub repository to be created in AWS CodeStar.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Description for the GitHub repository to be created in AWS CodeStar. This description displays in GitHub after
     * the repository is created.
     * </p>
     * 
     * @return Description for the GitHub repository to be created in AWS CodeStar. This description displays in GitHub
     *         after the repository is created.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The type of GitHub repository to be created in AWS CodeStar. Valid values are User or Organization.
     * </p>
     * 
     * @return The type of GitHub repository to be created in AWS CodeStar. Valid values are User or Organization.
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The GitHub username for the owner of the GitHub repository to be created in AWS CodeStar. If this repository
     * should be owned by a GitHub organization, provide its name.
     * </p>
     * 
     * @return The GitHub username for the owner of the GitHub repository to be created in AWS CodeStar. If this
     *         repository should be owned by a GitHub organization, provide its name.
     */
    public String owner() {
        return owner;
    }

    /**
     * <p>
     * Whether the GitHub repository is to be a private repository.
     * </p>
     * 
     * @return Whether the GitHub repository is to be a private repository.
     */
    public Boolean privateRepository() {
        return privateRepository;
    }

    /**
     * <p>
     * Whether to enable issues for the GitHub repository.
     * </p>
     * 
     * @return Whether to enable issues for the GitHub repository.
     */
    public Boolean issuesEnabled() {
        return issuesEnabled;
    }

    /**
     * <p>
     * The GitHub user's personal access token for the GitHub repository.
     * </p>
     * 
     * @return The GitHub user's personal access token for the GitHub repository.
     */
    public String token() {
        return token;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(privateRepository());
        hashCode = 31 * hashCode + Objects.hashCode(issuesEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(token());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitHubCodeDestination)) {
            return false;
        }
        GitHubCodeDestination other = (GitHubCodeDestination) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(type(), other.type()) && Objects.equals(owner(), other.owner())
                && Objects.equals(privateRepository(), other.privateRepository())
                && Objects.equals(issuesEnabled(), other.issuesEnabled()) && Objects.equals(token(), other.token());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GitHubCodeDestination").add("Name", name()).add("Description", description())
                .add("Type", type()).add("Owner", owner()).add("PrivateRepository", privateRepository())
                .add("IssuesEnabled", issuesEnabled()).add("Token", token() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "privateRepository":
            return Optional.ofNullable(clazz.cast(privateRepository()));
        case "issuesEnabled":
            return Optional.ofNullable(clazz.cast(issuesEnabled()));
        case "token":
            return Optional.ofNullable(clazz.cast(token()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GitHubCodeDestination, T> g) {
        return obj -> g.apply((GitHubCodeDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GitHubCodeDestination> {
        /**
         * <p>
         * Name of the GitHub repository to be created in AWS CodeStar.
         * </p>
         * 
         * @param name
         *        Name of the GitHub repository to be created in AWS CodeStar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Description for the GitHub repository to be created in AWS CodeStar. This description displays in GitHub
         * after the repository is created.
         * </p>
         * 
         * @param description
         *        Description for the GitHub repository to be created in AWS CodeStar. This description displays in
         *        GitHub after the repository is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of GitHub repository to be created in AWS CodeStar. Valid values are User or Organization.
         * </p>
         * 
         * @param type
         *        The type of GitHub repository to be created in AWS CodeStar. Valid values are User or Organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The GitHub username for the owner of the GitHub repository to be created in AWS CodeStar. If this repository
         * should be owned by a GitHub organization, provide its name.
         * </p>
         * 
         * @param owner
         *        The GitHub username for the owner of the GitHub repository to be created in AWS CodeStar. If this
         *        repository should be owned by a GitHub organization, provide its name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * Whether the GitHub repository is to be a private repository.
         * </p>
         * 
         * @param privateRepository
         *        Whether the GitHub repository is to be a private repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateRepository(Boolean privateRepository);

        /**
         * <p>
         * Whether to enable issues for the GitHub repository.
         * </p>
         * 
         * @param issuesEnabled
         *        Whether to enable issues for the GitHub repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuesEnabled(Boolean issuesEnabled);

        /**
         * <p>
         * The GitHub user's personal access token for the GitHub repository.
         * </p>
         * 
         * @param token
         *        The GitHub user's personal access token for the GitHub repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String type;

        private String owner;

        private Boolean privateRepository;

        private Boolean issuesEnabled;

        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(GitHubCodeDestination model) {
            name(model.name);
            description(model.description);
            type(model.type);
            owner(model.owner);
            privateRepository(model.privateRepository);
            issuesEnabled(model.issuesEnabled);
            token(model.token);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Boolean getPrivateRepository() {
            return privateRepository;
        }

        @Override
        public final Builder privateRepository(Boolean privateRepository) {
            this.privateRepository = privateRepository;
            return this;
        }

        public final void setPrivateRepository(Boolean privateRepository) {
            this.privateRepository = privateRepository;
        }

        public final Boolean getIssuesEnabled() {
            return issuesEnabled;
        }

        @Override
        public final Builder issuesEnabled(Boolean issuesEnabled) {
            this.issuesEnabled = issuesEnabled;
            return this;
        }

        public final void setIssuesEnabled(Boolean issuesEnabled) {
            this.issuesEnabled = issuesEnabled;
        }

        public final String getToken() {
            return token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public GitHubCodeDestination build() {
            return new GitHubCodeDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
