/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codestar.model.CodeStarResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUserProfileResponse
extends CodeStarResponse
implements ToCopyableBuilder<Builder, DescribeUserProfileResponse> {
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userArn").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::userArn)).setter(DescribeUserProfileResponse.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::displayName)).setter(DescribeUserProfileResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("emailAddress").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::emailAddress)).setter(DescribeUserProfileResponse.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()}).build();
    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sshPublicKey").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::sshPublicKey)).setter(DescribeUserProfileResponse.setter(Builder::sshPublicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sshPublicKey").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTimestamp").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::createdTimestamp)).setter(DescribeUserProfileResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTimestamp").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::lastModifiedTimestamp)).setter(DescribeUserProfileResponse.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ARN_FIELD, DISPLAY_NAME_FIELD, EMAIL_ADDRESS_FIELD, SSH_PUBLIC_KEY_FIELD, CREATED_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD));
    private final String userArn;
    private final String displayName;
    private final String emailAddress;
    private final String sshPublicKey;
    private final Instant createdTimestamp;
    private final Instant lastModifiedTimestamp;

    private DescribeUserProfileResponse(BuilderImpl builder) {
        super(builder);
        this.userArn = builder.userArn;
        this.displayName = builder.displayName;
        this.emailAddress = builder.emailAddress;
        this.sshPublicKey = builder.sshPublicKey;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
    }

    public String userArn() {
        return this.userArn;
    }

    public String displayName() {
        return this.displayName;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public String sshPublicKey() {
        return this.sshPublicKey;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfileResponse)) {
            return false;
        }
        DescribeUserProfileResponse other = (DescribeUserProfileResponse)((Object)obj);
        return Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.sshPublicKey(), other.sshPublicKey()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"DescribeUserProfileResponse").add("UserArn", (Object)this.userArn()).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("EmailAddress", (Object)(this.emailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("SshPublicKey", (Object)this.sshPublicKey()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "emailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "sshPublicKey": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKey()));
            }
            case "createdTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "lastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserProfileResponse, T> g) {
        return obj -> g.apply((DescribeUserProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeStarResponse.BuilderImpl
    implements Builder {
        private String userArn;
        private String displayName;
        private String emailAddress;
        private String sshPublicKey;
        private Instant createdTimestamp;
        private Instant lastModifiedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfileResponse model) {
            super(model);
            this.userArn(model.userArn);
            this.displayName(model.displayName);
            this.emailAddress(model.emailAddress);
            this.sshPublicKey(model.sshPublicKey);
            this.createdTimestamp(model.createdTimestamp);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getSshPublicKey() {
            return this.sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public DescribeUserProfileResponse build() {
            return new DescribeUserProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeStarResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUserProfileResponse> {
        public Builder userArn(String var1);

        public Builder displayName(String var1);

        public Builder emailAddress(String var1);

        public Builder sshPublicKey(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder lastModifiedTimestamp(Instant var1);
    }
}

