/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codestar.model.TemplateParameterMapCopier;
import software.amazon.awssdk.services.codestar.model.ToolchainSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Toolchain
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Toolchain> {
    private static final SdkField<ToolchainSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(Toolchain.getter(Toolchain::source)).setter(Toolchain.setter(Builder::source)).constructor(ToolchainSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(Toolchain.getter(Toolchain::roleArn)).setter(Toolchain.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Map<String, String>> STACK_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("stackParameters").getter(Toolchain.getter(Toolchain::stackParameters)).setter(Toolchain.setter(Builder::stackParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, ROLE_ARN_FIELD, STACK_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ToolchainSource source;
    private final String roleArn;
    private final Map<String, String> stackParameters;

    private Toolchain(BuilderImpl builder) {
        this.source = builder.source;
        this.roleArn = builder.roleArn;
        this.stackParameters = builder.stackParameters;
    }

    public ToolchainSource source() {
        return this.source;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public boolean hasStackParameters() {
        return this.stackParameters != null && !(this.stackParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> stackParameters() {
        return this.stackParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackParameters() ? this.stackParameters() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Toolchain)) {
            return false;
        }
        Toolchain other = (Toolchain)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasStackParameters() == other.hasStackParameters() && Objects.equals(this.stackParameters(), other.stackParameters());
    }

    public String toString() {
        return ToString.builder((String)"Toolchain").add("Source", (Object)this.source()).add("RoleArn", (Object)this.roleArn()).add("StackParameters", (Object)(this.stackParameters() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "stackParameters": {
                return Optional.ofNullable(clazz.cast(this.stackParameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Toolchain, T> g) {
        return obj -> g.apply((Toolchain)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ToolchainSource source;
        private String roleArn;
        private Map<String, String> stackParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Toolchain model) {
            this.source(model.source);
            this.roleArn(model.roleArn);
            this.stackParameters(model.stackParameters);
        }

        public final ToolchainSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(ToolchainSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(ToolchainSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, String> getStackParameters() {
            if (this.stackParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.stackParameters;
        }

        @Override
        public final Builder stackParameters(Map<String, String> stackParameters) {
            this.stackParameters = TemplateParameterMapCopier.copy(stackParameters);
            return this;
        }

        public final void setStackParameters(Map<String, String> stackParameters) {
            this.stackParameters = TemplateParameterMapCopier.copy(stackParameters);
        }

        public Toolchain build() {
            return new Toolchain(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Toolchain> {
        public Builder source(ToolchainSource var1);

        default public Builder source(Consumer<ToolchainSource.Builder> source) {
            return this.source((ToolchainSource)((ToolchainSource.Builder)ToolchainSource.builder().applyMutation(source)).build());
        }

        public Builder roleArn(String var1);

        public Builder stackParameters(Map<String, String> var1);
    }
}

