/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProjectResponse extends CodeStarResponse implements
        ToCopyableBuilder<DescribeProjectResponse.Builder, DescribeProjectResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DescribeProjectResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DescribeProjectResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DescribeProjectResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeProjectResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(DescribeProjectResponse::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<Instant> CREATED_TIME_STAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTimeStamp").getter(getter(DescribeProjectResponse::createdTimeStamp))
            .setter(setter(Builder::createdTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimeStamp").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stackId").getter(getter(DescribeProjectResponse::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackId").build()).build();

    private static final SdkField<String> PROJECT_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectTemplateId").getter(getter(DescribeProjectResponse::projectTemplateId))
            .setter(setter(Builder::projectTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectTemplateId").build()).build();

    private static final SdkField<ProjectStatus> STATUS_FIELD = SdkField.<ProjectStatus> builder(MarshallingType.SDK_POJO)
            .memberName("status").getter(getter(DescribeProjectResponse::status)).setter(setter(Builder::status))
            .constructor(ProjectStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            ARN_FIELD, DESCRIPTION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, CREATED_TIME_STAMP_FIELD, STACK_ID_FIELD,
            PROJECT_TEMPLATE_ID_FIELD, STATUS_FIELD));

    private final String name;

    private final String id;

    private final String arn;

    private final String description;

    private final String clientRequestToken;

    private final Instant createdTimeStamp;

    private final String stackId;

    private final String projectTemplateId;

    private final ProjectStatus status;

    private DescribeProjectResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.description = builder.description;
        this.clientRequestToken = builder.clientRequestToken;
        this.createdTimeStamp = builder.createdTimeStamp;
        this.stackId = builder.stackId;
        this.projectTemplateId = builder.projectTemplateId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The display name for the project.
     * </p>
     * 
     * @return The display name for the project.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the project.
     * </p>
     * 
     * @return The ID of the project.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the project.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The description of the project, if any.
     * </p>
     * 
     * @return The description of the project, if any.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A user- or system-generated token that identifies the entity that requested project creation.
     * </p>
     * 
     * @return A user- or system-generated token that identifies the entity that requested project creation.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The date and time the project was created, in timestamp format.
     * </p>
     * 
     * @return The date and time the project was created, in timestamp format.
     */
    public final Instant createdTimeStamp() {
        return createdTimeStamp;
    }

    /**
     * <p>
     * The ID of the primary stack in AWS CloudFormation used to generate resources for the project.
     * </p>
     * 
     * @return The ID of the primary stack in AWS CloudFormation used to generate resources for the project.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The ID for the AWS CodeStar project template used to create the project.
     * </p>
     * 
     * @return The ID for the AWS CodeStar project template used to create the project.
     */
    public final String projectTemplateId() {
        return projectTemplateId;
    }

    /**
     * <p>
     * The project creation or deletion status.
     * </p>
     * 
     * @return The project creation or deletion status.
     */
    public final ProjectStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(projectTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectResponse)) {
            return false;
        }
        DescribeProjectResponse other = (DescribeProjectResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(createdTimeStamp(), other.createdTimeStamp()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(projectTemplateId(), other.projectTemplateId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProjectResponse").add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Id", id()).add("Arn", arn())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientRequestToken", clientRequestToken()).add("CreatedTimeStamp", createdTimeStamp())
                .add("StackId", stackId()).add("ProjectTemplateId", projectTemplateId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "createdTimeStamp":
            return Optional.ofNullable(clazz.cast(createdTimeStamp()));
        case "stackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "projectTemplateId":
            return Optional.ofNullable(clazz.cast(projectTemplateId()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectResponse, T> g) {
        return obj -> g.apply((DescribeProjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProjectResponse> {
        /**
         * <p>
         * The display name for the project.
         * </p>
         * 
         * @param name
         *        The display name for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the project.
         * </p>
         * 
         * @param id
         *        The ID of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the project.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The description of the project, if any.
         * </p>
         * 
         * @param description
         *        The description of the project, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A user- or system-generated token that identifies the entity that requested project creation.
         * </p>
         * 
         * @param clientRequestToken
         *        A user- or system-generated token that identifies the entity that requested project creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The date and time the project was created, in timestamp format.
         * </p>
         * 
         * @param createdTimeStamp
         *        The date and time the project was created, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimeStamp(Instant createdTimeStamp);

        /**
         * <p>
         * The ID of the primary stack in AWS CloudFormation used to generate resources for the project.
         * </p>
         * 
         * @param stackId
         *        The ID of the primary stack in AWS CloudFormation used to generate resources for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The ID for the AWS CodeStar project template used to create the project.
         * </p>
         * 
         * @param projectTemplateId
         *        The ID for the AWS CodeStar project template used to create the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectTemplateId(String projectTemplateId);

        /**
         * <p>
         * The project creation or deletion status.
         * </p>
         * 
         * @param status
         *        The project creation or deletion status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ProjectStatus status);

        /**
         * <p>
         * The project creation or deletion status.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectStatus.Builder} avoiding the need to
         * create one manually via {@link ProjectStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(ProjectStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ProjectStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ProjectStatus)
         */
        default Builder status(Consumer<ProjectStatus.Builder> status) {
            return status(ProjectStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl extends CodeStarResponse.BuilderImpl implements Builder {
        private String name;

        private String id;

        private String arn;

        private String description;

        private String clientRequestToken;

        private Instant createdTimeStamp;

        private String stackId;

        private String projectTemplateId;

        private ProjectStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectResponse model) {
            super(model);
            name(model.name);
            id(model.id);
            arn(model.arn);
            description(model.description);
            clientRequestToken(model.clientRequestToken);
            createdTimeStamp(model.createdTimeStamp);
            stackId(model.stackId);
            projectTemplateId(model.projectTemplateId);
            status(model.status);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Instant getCreatedTimeStamp() {
            return createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Instant createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        public final void setCreatedTimeStamp(Instant createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getProjectTemplateId() {
            return projectTemplateId;
        }

        @Override
        public final Builder projectTemplateId(String projectTemplateId) {
            this.projectTemplateId = projectTemplateId;
            return this;
        }

        public final void setProjectTemplateId(String projectTemplateId) {
            this.projectTemplateId = projectTemplateId;
        }

        public final ProjectStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(ProjectStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ProjectStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public DescribeProjectResponse build() {
            return new DescribeProjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
