/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a user's profile in AWS CodeStar.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserProfileSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<UserProfileSummary.Builder, UserProfileSummary> {
    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userArn").getter(getter(UserProfileSummary::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UserProfileSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("emailAddress").getter(getter(UserProfileSummary::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sshPublicKey").getter(getter(UserProfileSummary::sshPublicKey)).setter(setter(Builder::sshPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sshPublicKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ARN_FIELD,
            DISPLAY_NAME_FIELD, EMAIL_ADDRESS_FIELD, SSH_PUBLIC_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userArn;

    private final String displayName;

    private final String emailAddress;

    private final String sshPublicKey;

    private UserProfileSummary(BuilderImpl builder) {
        this.userArn = builder.userArn;
        this.displayName = builder.displayName;
        this.emailAddress = builder.emailAddress;
        this.sshPublicKey = builder.sshPublicKey;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user in IAM.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user in IAM.
     */
    public final String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The display name of a user in AWS CodeStar. For example, this could be set to both first and last name
     * ("Mary Major") or a single name ("Mary"). The display name is also used to generate the initial icon associated
     * with the user in AWS CodeStar projects. If spaces are included in the display name, the first character that
     * appears after the space will be used as the second character in the user initial icon. The initial icon displays
     * a maximum of two characters, so a display name with more than one space (for example "Mary Jane Major") would
     * generate an initial icon using the first character and the first character after the space ("MJ", not "MM").
     * </p>
     * 
     * @return The display name of a user in AWS CodeStar. For example, this could be set to both first and last name
     *         ("Mary Major") or a single name ("Mary"). The display name is also used to generate the initial icon
     *         associated with the user in AWS CodeStar projects. If spaces are included in the display name, the first
     *         character that appears after the space will be used as the second character in the user initial icon. The
     *         initial icon displays a maximum of two characters, so a display name with more than one space (for
     *         example "Mary Jane Major") would generate an initial icon using the first character and the first
     *         character after the space ("MJ", not "MM").
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The email address associated with the user.
     * </p>
     * 
     * @return The email address associated with the user.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote access to
     * project resources, this public key will be used along with the user's private key for SSH access.
     * </p>
     * 
     * @return The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote
     *         access to project resources, this public key will be used along with the user's private key for SSH
     *         access.
     */
    public final String sshPublicKey() {
        return sshPublicKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserProfileSummary)) {
            return false;
        }
        UserProfileSummary other = (UserProfileSummary) obj;
        return Objects.equals(userArn(), other.userArn()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(sshPublicKey(), other.sshPublicKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserProfileSummary").add("UserArn", userArn())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SshPublicKey", sshPublicKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "emailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "sshPublicKey":
            return Optional.ofNullable(clazz.cast(sshPublicKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserProfileSummary, T> g) {
        return obj -> g.apply((UserProfileSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserProfileSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user in IAM.
         * </p>
         * 
         * @param userArn
         *        The Amazon Resource Name (ARN) of the user in IAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The display name of a user in AWS CodeStar. For example, this could be set to both first and last name
         * ("Mary Major") or a single name ("Mary"). The display name is also used to generate the initial icon
         * associated with the user in AWS CodeStar projects. If spaces are included in the display name, the first
         * character that appears after the space will be used as the second character in the user initial icon. The
         * initial icon displays a maximum of two characters, so a display name with more than one space (for example
         * "Mary Jane Major") would generate an initial icon using the first character and the first character after the
         * space ("MJ", not "MM").
         * </p>
         * 
         * @param displayName
         *        The display name of a user in AWS CodeStar. For example, this could be set to both first and last name
         *        ("Mary Major") or a single name ("Mary"). The display name is also used to generate the initial icon
         *        associated with the user in AWS CodeStar projects. If spaces are included in the display name, the
         *        first character that appears after the space will be used as the second character in the user initial
         *        icon. The initial icon displays a maximum of two characters, so a display name with more than one
         *        space (for example "Mary Jane Major") would generate an initial icon using the first character and the
         *        first character after the space ("MJ", not "MM").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The email address associated with the user.
         * </p>
         * 
         * @param emailAddress
         *        The email address associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote access
         * to project resources, this public key will be used along with the user's private key for SSH access.
         * </p>
         * 
         * @param sshPublicKey
         *        The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote
         *        access to project resources, this public key will be used along with the user's private key for SSH
         *        access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKey(String sshPublicKey);
    }

    static final class BuilderImpl implements Builder {
        private String userArn;

        private String displayName;

        private String emailAddress;

        private String sshPublicKey;

        private BuilderImpl() {
        }

        private BuilderImpl(UserProfileSummary model) {
            userArn(model.userArn);
            displayName(model.displayName);
            emailAddress(model.emailAddress);
            sshPublicKey(model.sshPublicKey);
        }

        public final String getUserArn() {
            return userArn;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        @Transient
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        @Transient
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getSshPublicKey() {
            return sshPublicKey;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        @Override
        @Transient
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        @Override
        public UserProfileSummary build() {
            return new UserProfileSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
