/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codestar.model.Code;
import software.amazon.awssdk.services.codestar.model.CodeStarRequest;
import software.amazon.awssdk.services.codestar.model.SourceCodeCopier;
import software.amazon.awssdk.services.codestar.model.TagsCopier;
import software.amazon.awssdk.services.codestar.model.Toolchain;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProjectRequest
extends CodeStarRequest
implements ToCopyableBuilder<Builder, CreateProjectRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateProjectRequest.getter(CreateProjectRequest::name)).setter(CreateProjectRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateProjectRequest.getter(CreateProjectRequest::id)).setter(CreateProjectRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateProjectRequest.getter(CreateProjectRequest::description)).setter(CreateProjectRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateProjectRequest.getter(CreateProjectRequest::clientRequestToken)).setter(CreateProjectRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<List<Code>> SOURCE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceCode").getter(CreateProjectRequest.getter(CreateProjectRequest::sourceCode)).setter(CreateProjectRequest.setter(Builder::sourceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCode").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Code::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Toolchain> TOOLCHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolchain").getter(CreateProjectRequest.getter(CreateProjectRequest::toolchain)).setter(CreateProjectRequest.setter(Builder::toolchain)).constructor(Toolchain::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolchain").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateProjectRequest.getter(CreateProjectRequest::tags)).setter(CreateProjectRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD, DESCRIPTION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, SOURCE_CODE_FIELD, TOOLCHAIN_FIELD, TAGS_FIELD));
    private final String name;
    private final String id;
    private final String description;
    private final String clientRequestToken;
    private final List<Code> sourceCode;
    private final Toolchain toolchain;
    private final Map<String, String> tags;

    private CreateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.id = builder.id;
        this.description = builder.description;
        this.clientRequestToken = builder.clientRequestToken;
        this.sourceCode = builder.sourceCode;
        this.toolchain = builder.toolchain;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final String description() {
        return this.description;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasSourceCode() {
        return this.sourceCode != null && !(this.sourceCode instanceof SdkAutoConstructList);
    }

    public final List<Code> sourceCode() {
        return this.sourceCode;
    }

    public final Toolchain toolchain() {
        return this.toolchain;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceCode() ? this.sourceCode() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.toolchain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectRequest)) {
            return false;
        }
        CreateProjectRequest other = (CreateProjectRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasSourceCode() == other.hasSourceCode() && Objects.equals(this.sourceCode(), other.sourceCode()) && Objects.equals(this.toolchain(), other.toolchain()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProjectRequest").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Id", (Object)this.id()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientRequestToken", (Object)this.clientRequestToken()).add("SourceCode", this.hasSourceCode() ? this.sourceCode() : null).add("Toolchain", (Object)this.toolchain()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "sourceCode": {
                return Optional.ofNullable(clazz.cast(this.sourceCode()));
            }
            case "toolchain": {
                return Optional.ofNullable(clazz.cast(this.toolchain()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectRequest, T> g) {
        return obj -> g.apply((CreateProjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeStarRequest.BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private String description;
        private String clientRequestToken;
        private List<Code> sourceCode = DefaultSdkAutoConstructList.getInstance();
        private Toolchain toolchain;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectRequest model) {
            super(model);
            this.name(model.name);
            this.id(model.id);
            this.description(model.description);
            this.clientRequestToken(model.clientRequestToken);
            this.sourceCode(model.sourceCode);
            this.toolchain(model.toolchain);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Code.Builder> getSourceCode() {
            List<Code.Builder> result = SourceCodeCopier.copyToBuilder(this.sourceCode);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceCode(Collection<Code.BuilderImpl> sourceCode) {
            this.sourceCode = SourceCodeCopier.copyFromBuilder(sourceCode);
        }

        @Override
        @Transient
        public final Builder sourceCode(Collection<Code> sourceCode) {
            this.sourceCode = SourceCodeCopier.copy(sourceCode);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sourceCode(Code ... sourceCode) {
            this.sourceCode(Arrays.asList(sourceCode));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sourceCode(Consumer<Code.Builder> ... sourceCode) {
            this.sourceCode(Stream.of(sourceCode).map(c -> (Code)((Code.Builder)Code.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Toolchain.Builder getToolchain() {
            return this.toolchain != null ? this.toolchain.toBuilder() : null;
        }

        public final void setToolchain(Toolchain.BuilderImpl toolchain) {
            this.toolchain = toolchain != null ? toolchain.build() : null;
        }

        @Override
        @Transient
        public final Builder toolchain(Toolchain toolchain) {
            this.toolchain = toolchain;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProjectRequest build() {
            return new CreateProjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeStarRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProjectRequest> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder description(String var1);

        public Builder clientRequestToken(String var1);

        public Builder sourceCode(Collection<Code> var1);

        public Builder sourceCode(Code ... var1);

        public Builder sourceCode(Consumer<Code.Builder> ... var1);

        public Builder toolchain(Toolchain var1);

        default public Builder toolchain(Consumer<Toolchain.Builder> toolchain) {
            return this.toolchain((Toolchain)((Toolchain.Builder)Toolchain.builder().applyMutation(toolchain)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

