/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteProjectResponse extends CodeStarResponse implements
        ToCopyableBuilder<DeleteProjectResponse.Builder, DeleteProjectResponse> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stackId").getter(getter(DeleteProjectResponse::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackId").build()).build();

    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectArn").getter(getter(DeleteProjectResponse::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD,
            PROJECT_ARN_FIELD));

    private final String stackId;

    private final String projectArn;

    private DeleteProjectResponse(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.projectArn = builder.projectArn;
    }

    /**
     * <p>
     * The ID of the primary stack in AWS CloudFormation that will be deleted as part of deleting the project and its
     * resources.
     * </p>
     * 
     * @return The ID of the primary stack in AWS CloudFormation that will be deleted as part of deleting the project
     *         and its resources.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the deleted project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the deleted project.
     */
    public final String projectArn() {
        return projectArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProjectResponse)) {
            return false;
        }
        DeleteProjectResponse other = (DeleteProjectResponse) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(projectArn(), other.projectArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteProjectResponse").add("StackId", stackId()).add("ProjectArn", projectArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "projectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteProjectResponse, T> g) {
        return obj -> g.apply((DeleteProjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteProjectResponse> {
        /**
         * <p>
         * The ID of the primary stack in AWS CloudFormation that will be deleted as part of deleting the project and
         * its resources.
         * </p>
         * 
         * @param stackId
         *        The ID of the primary stack in AWS CloudFormation that will be deleted as part of deleting the project
         *        and its resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the deleted project.
         * </p>
         * 
         * @param projectArn
         *        The Amazon Resource Name (ARN) of the deleted project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);
    }

    static final class BuilderImpl extends CodeStarResponse.BuilderImpl implements Builder {
        private String stackId;

        private String projectArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProjectResponse model) {
            super(model);
            stackId(model.stackId);
            projectArn(model.projectArn);
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        @Transient
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        @Transient
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        @Override
        public DeleteProjectResponse build() {
            return new DeleteProjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
