/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTeamMembersResponse extends CodeStarResponse implements
        ToCopyableBuilder<ListTeamMembersResponse.Builder, ListTeamMembersResponse> {
    private static final SdkField<List<TeamMember>> TEAM_MEMBERS_FIELD = SdkField
            .<List<TeamMember>> builder(MarshallingType.LIST)
            .memberName("teamMembers")
            .getter(getter(ListTeamMembersResponse::teamMembers))
            .setter(setter(Builder::teamMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teamMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TeamMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(TeamMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTeamMembersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEAM_MEMBERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TeamMember> teamMembers;

    private final String nextToken;

    private ListTeamMembersResponse(BuilderImpl builder) {
        super(builder);
        this.teamMembers = builder.teamMembers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TeamMembers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTeamMembers() {
        return teamMembers != null && !(teamMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of team member objects for the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTeamMembers} method.
     * </p>
     * 
     * @return A list of team member objects for the project.
     */
    public final List<TeamMember> teamMembers() {
        return teamMembers;
    }

    /**
     * <p>
     * The continuation token to use when requesting the next set of results, if there are more results to be returned.
     * </p>
     * 
     * @return The continuation token to use when requesting the next set of results, if there are more results to be
     *         returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTeamMembers() ? teamMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTeamMembersResponse)) {
            return false;
        }
        ListTeamMembersResponse other = (ListTeamMembersResponse) obj;
        return hasTeamMembers() == other.hasTeamMembers() && Objects.equals(teamMembers(), other.teamMembers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTeamMembersResponse").add("TeamMembers", hasTeamMembers() ? teamMembers() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "teamMembers":
            return Optional.ofNullable(clazz.cast(teamMembers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTeamMembersResponse, T> g) {
        return obj -> g.apply((ListTeamMembersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTeamMembersResponse> {
        /**
         * <p>
         * A list of team member objects for the project.
         * </p>
         * 
         * @param teamMembers
         *        A list of team member objects for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamMembers(Collection<TeamMember> teamMembers);

        /**
         * <p>
         * A list of team member objects for the project.
         * </p>
         * 
         * @param teamMembers
         *        A list of team member objects for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamMembers(TeamMember... teamMembers);

        /**
         * <p>
         * A list of team member objects for the project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codestar.model.TeamMember.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codestar.model.TeamMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codestar.model.TeamMember.Builder#build()} is called immediately and
         * its result is passed to {@link #teamMembers(List<TeamMember>)}.
         * 
         * @param teamMembers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codestar.model.TeamMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #teamMembers(java.util.Collection<TeamMember>)
         */
        Builder teamMembers(Consumer<TeamMember.Builder>... teamMembers);

        /**
         * <p>
         * The continuation token to use when requesting the next set of results, if there are more results to be
         * returned.
         * </p>
         * 
         * @param nextToken
         *        The continuation token to use when requesting the next set of results, if there are more results to be
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeStarResponse.BuilderImpl implements Builder {
        private List<TeamMember> teamMembers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTeamMembersResponse model) {
            super(model);
            teamMembers(model.teamMembers);
            nextToken(model.nextToken);
        }

        public final List<TeamMember.Builder> getTeamMembers() {
            List<TeamMember.Builder> result = TeamMemberResultCopier.copyToBuilder(this.teamMembers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTeamMembers(Collection<TeamMember.BuilderImpl> teamMembers) {
            this.teamMembers = TeamMemberResultCopier.copyFromBuilder(teamMembers);
        }

        @Override
        public final Builder teamMembers(Collection<TeamMember> teamMembers) {
            this.teamMembers = TeamMemberResultCopier.copy(teamMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder teamMembers(TeamMember... teamMembers) {
            teamMembers(Arrays.asList(teamMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder teamMembers(Consumer<TeamMember.Builder>... teamMembers) {
            teamMembers(Stream.of(teamMembers).map(c -> TeamMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTeamMembersResponse build() {
            return new ListTeamMembersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
