/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProjectsResponse extends CodeStarResponse implements
        ToCopyableBuilder<ListProjectsResponse.Builder, ListProjectsResponse> {
    private static final SdkField<List<ProjectSummary>> PROJECTS_FIELD = SdkField
            .<List<ProjectSummary>> builder(MarshallingType.LIST)
            .memberName("projects")
            .getter(getter(ListProjectsResponse::projects))
            .setter(setter(Builder::projects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListProjectsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ProjectSummary> projects;

    private final String nextToken;

    private ListProjectsResponse(BuilderImpl builder) {
        super(builder);
        this.projects = builder.projects;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Projects property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProjects() {
        return projects != null && !(projects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of projects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProjects} method.
     * </p>
     * 
     * @return A list of projects.
     */
    public final List<ProjectSummary> projects() {
        return projects;
    }

    /**
     * <p>
     * The continuation token to use when requesting the next set of results, if there are more results to be returned.
     * </p>
     * 
     * @return The continuation token to use when requesting the next set of results, if there are more results to be
     *         returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProjects() ? projects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProjectsResponse)) {
            return false;
        }
        ListProjectsResponse other = (ListProjectsResponse) obj;
        return hasProjects() == other.hasProjects() && Objects.equals(projects(), other.projects())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProjectsResponse").add("Projects", hasProjects() ? projects() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projects":
            return Optional.ofNullable(clazz.cast(projects()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProjectsResponse, T> g) {
        return obj -> g.apply((ListProjectsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListProjectsResponse> {
        /**
         * <p>
         * A list of projects.
         * </p>
         * 
         * @param projects
         *        A list of projects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projects(Collection<ProjectSummary> projects);

        /**
         * <p>
         * A list of projects.
         * </p>
         * 
         * @param projects
         *        A list of projects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projects(ProjectSummary... projects);

        /**
         * <p>
         * A list of projects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codestar.model.ProjectSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codestar.model.ProjectSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codestar.model.ProjectSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #projects(List<ProjectSummary>)}.
         * 
         * @param projects
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codestar.model.ProjectSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projects(java.util.Collection<ProjectSummary>)
         */
        Builder projects(Consumer<ProjectSummary.Builder>... projects);

        /**
         * <p>
         * The continuation token to use when requesting the next set of results, if there are more results to be
         * returned.
         * </p>
         * 
         * @param nextToken
         *        The continuation token to use when requesting the next set of results, if there are more results to be
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeStarResponse.BuilderImpl implements Builder {
        private List<ProjectSummary> projects = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProjectsResponse model) {
            super(model);
            projects(model.projects);
            nextToken(model.nextToken);
        }

        public final List<ProjectSummary.Builder> getProjects() {
            List<ProjectSummary.Builder> result = ProjectsListCopier.copyToBuilder(this.projects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjects(Collection<ProjectSummary.BuilderImpl> projects) {
            this.projects = ProjectsListCopier.copyFromBuilder(projects);
        }

        @Override
        public final Builder projects(Collection<ProjectSummary> projects) {
            this.projects = ProjectsListCopier.copy(projects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(ProjectSummary... projects) {
            projects(Arrays.asList(projects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(Consumer<ProjectSummary.Builder>... projects) {
            projects(Stream.of(projects).map(c -> ProjectSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProjectsResponse build() {
            return new ListProjectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
