/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit or GitHub. After AWS CodeStar
 * provisions the new repository, the source code files provided with the project request are placed in the repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeDestination implements SdkPojo, Serializable, ToCopyableBuilder<CodeDestination.Builder, CodeDestination> {
    private static final SdkField<CodeCommitCodeDestination> CODE_COMMIT_FIELD = SdkField
            .<CodeCommitCodeDestination> builder(MarshallingType.SDK_POJO).getter(getter(CodeDestination::codeCommit))
            .setter(setter(Builder::codeCommit)).constructor(CodeCommitCodeDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeCommit").build()).build();

    private static final SdkField<GitHubCodeDestination> GIT_HUB_FIELD = SdkField
            .<GitHubCodeDestination> builder(MarshallingType.SDK_POJO).getter(getter(CodeDestination::gitHub))
            .setter(setter(Builder::gitHub)).constructor(GitHubCodeDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitHub").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_COMMIT_FIELD,
            GIT_HUB_FIELD));

    private static final long serialVersionUID = 1L;

    private final CodeCommitCodeDestination codeCommit;

    private final GitHubCodeDestination gitHub;

    private CodeDestination(BuilderImpl builder) {
        this.codeCommit = builder.codeCommit;
        this.gitHub = builder.gitHub;
    }

    /**
     * <p>
     * Information about the AWS CodeCommit repository to be created in AWS CodeStar. This is where the source code
     * files provided with the project request will be uploaded after project creation.
     * </p>
     * 
     * @return Information about the AWS CodeCommit repository to be created in AWS CodeStar. This is where the source
     *         code files provided with the project request will be uploaded after project creation.
     */
    public CodeCommitCodeDestination codeCommit() {
        return codeCommit;
    }

    /**
     * <p>
     * Information about the GitHub repository to be created in AWS CodeStar. This is where the source code files
     * provided with the project request will be uploaded after project creation.
     * </p>
     * 
     * @return Information about the GitHub repository to be created in AWS CodeStar. This is where the source code
     *         files provided with the project request will be uploaded after project creation.
     */
    public GitHubCodeDestination gitHub() {
        return gitHub;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeCommit());
        hashCode = 31 * hashCode + Objects.hashCode(gitHub());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeDestination)) {
            return false;
        }
        CodeDestination other = (CodeDestination) obj;
        return Objects.equals(codeCommit(), other.codeCommit()) && Objects.equals(gitHub(), other.gitHub());
    }

    @Override
    public String toString() {
        return ToString.builder("CodeDestination").add("CodeCommit", codeCommit()).add("GitHub", gitHub()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "codeCommit":
            return Optional.ofNullable(clazz.cast(codeCommit()));
        case "gitHub":
            return Optional.ofNullable(clazz.cast(gitHub()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeDestination, T> g) {
        return obj -> g.apply((CodeDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeDestination> {
        /**
         * <p>
         * Information about the AWS CodeCommit repository to be created in AWS CodeStar. This is where the source code
         * files provided with the project request will be uploaded after project creation.
         * </p>
         * 
         * @param codeCommit
         *        Information about the AWS CodeCommit repository to be created in AWS CodeStar. This is where the
         *        source code files provided with the project request will be uploaded after project creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeCommit(CodeCommitCodeDestination codeCommit);

        /**
         * <p>
         * Information about the AWS CodeCommit repository to be created in AWS CodeStar. This is where the source code
         * files provided with the project request will be uploaded after project creation.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeCommitCodeDestination.Builder} avoiding the
         * need to create one manually via {@link CodeCommitCodeDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeCommitCodeDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #codeCommit(CodeCommitCodeDestination)}.
         * 
         * @param codeCommit
         *        a consumer that will call methods on {@link CodeCommitCodeDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeCommit(CodeCommitCodeDestination)
         */
        default Builder codeCommit(Consumer<CodeCommitCodeDestination.Builder> codeCommit) {
            return codeCommit(CodeCommitCodeDestination.builder().applyMutation(codeCommit).build());
        }

        /**
         * <p>
         * Information about the GitHub repository to be created in AWS CodeStar. This is where the source code files
         * provided with the project request will be uploaded after project creation.
         * </p>
         * 
         * @param gitHub
         *        Information about the GitHub repository to be created in AWS CodeStar. This is where the source code
         *        files provided with the project request will be uploaded after project creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHub(GitHubCodeDestination gitHub);

        /**
         * <p>
         * Information about the GitHub repository to be created in AWS CodeStar. This is where the source code files
         * provided with the project request will be uploaded after project creation.
         * </p>
         * This is a convenience that creates an instance of the {@link GitHubCodeDestination.Builder} avoiding the need
         * to create one manually via {@link GitHubCodeDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link GitHubCodeDestination.Builder#build()} is called immediately and
         * its result is passed to {@link #gitHub(GitHubCodeDestination)}.
         * 
         * @param gitHub
         *        a consumer that will call methods on {@link GitHubCodeDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitHub(GitHubCodeDestination)
         */
        default Builder gitHub(Consumer<GitHubCodeDestination.Builder> gitHub) {
            return gitHub(GitHubCodeDestination.builder().applyMutation(gitHub).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CodeCommitCodeDestination codeCommit;

        private GitHubCodeDestination gitHub;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeDestination model) {
            codeCommit(model.codeCommit);
            gitHub(model.gitHub);
        }

        public final CodeCommitCodeDestination.Builder getCodeCommit() {
            return codeCommit != null ? codeCommit.toBuilder() : null;
        }

        @Override
        public final Builder codeCommit(CodeCommitCodeDestination codeCommit) {
            this.codeCommit = codeCommit;
            return this;
        }

        public final void setCodeCommit(CodeCommitCodeDestination.BuilderImpl codeCommit) {
            this.codeCommit = codeCommit != null ? codeCommit.build() : null;
        }

        public final GitHubCodeDestination.Builder getGitHub() {
            return gitHub != null ? gitHub.toBuilder() : null;
        }

        @Override
        public final Builder gitHub(GitHubCodeDestination gitHub) {
            this.gitHub = gitHub;
            return this;
        }

        public final void setGitHub(GitHubCodeDestination.BuilderImpl gitHub) {
            this.gitHub = gitHub != null ? gitHub.build() : null;
        }

        @Override
        public CodeDestination build() {
            return new CodeDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
