/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProjectsResponse extends CodeStarResponse implements
        ToCopyableBuilder<ListProjectsResponse.Builder, ListProjectsResponse> {
    private static final SdkField<List<ProjectSummary>> PROJECTS_FIELD = SdkField
            .<List<ProjectSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListProjectsResponse::projects))
            .setter(setter(Builder::projects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListProjectsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ProjectSummary> projects;

    private final String nextToken;

    private ListProjectsResponse(BuilderImpl builder) {
        super(builder);
        this.projects = builder.projects;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of projects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of projects.
     */
    public List<ProjectSummary> projects() {
        return projects;
    }

    /**
     * <p>
     * The continuation token to use when requesting the next set of results, if there are more results to be returned.
     * </p>
     * 
     * @return The continuation token to use when requesting the next set of results, if there are more results to be
     *         returned.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projects());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProjectsResponse)) {
            return false;
        }
        ListProjectsResponse other = (ListProjectsResponse) obj;
        return Objects.equals(projects(), other.projects()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListProjectsResponse").add("Projects", projects()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projects":
            return Optional.ofNullable(clazz.cast(projects()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProjectsResponse, T> g) {
        return obj -> g.apply((ListProjectsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListProjectsResponse> {
        /**
         * <p>
         * A list of projects.
         * </p>
         * 
         * @param projects
         *        A list of projects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projects(Collection<ProjectSummary> projects);

        /**
         * <p>
         * A list of projects.
         * </p>
         * 
         * @param projects
         *        A list of projects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projects(ProjectSummary... projects);

        /**
         * <p>
         * A list of projects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProjectSummary>.Builder} avoiding the need
         * to create one manually via {@link List<ProjectSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #projects(List<ProjectSummary>)}.
         * 
         * @param projects
         *        a consumer that will call methods on {@link List<ProjectSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projects(List<ProjectSummary>)
         */
        Builder projects(Consumer<ProjectSummary.Builder>... projects);

        /**
         * <p>
         * The continuation token to use when requesting the next set of results, if there are more results to be
         * returned.
         * </p>
         * 
         * @param nextToken
         *        The continuation token to use when requesting the next set of results, if there are more results to be
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeStarResponse.BuilderImpl implements Builder {
        private List<ProjectSummary> projects = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProjectsResponse model) {
            super(model);
            projects(model.projects);
            nextToken(model.nextToken);
        }

        public final Collection<ProjectSummary.Builder> getProjects() {
            return projects != null ? projects.stream().map(ProjectSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder projects(Collection<ProjectSummary> projects) {
            this.projects = ProjectsListCopier.copy(projects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(ProjectSummary... projects) {
            projects(Arrays.asList(projects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(Consumer<ProjectSummary.Builder>... projects) {
            projects(Stream.of(projects).map(c -> ProjectSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProjects(Collection<ProjectSummary.BuilderImpl> projects) {
            this.projects = ProjectsListCopier.copyFromBuilder(projects);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListProjectsResponse build() {
            return new ListProjectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
