/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codestar.model.CodeCommitCodeDestination;
import software.amazon.awssdk.services.codestar.model.GitHubCodeDestination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeDestination> {
    private static final SdkField<CodeCommitCodeDestination> CODE_COMMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CodeDestination.getter(CodeDestination::codeCommit)).setter(CodeDestination.setter(Builder::codeCommit)).constructor(CodeCommitCodeDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeCommit").build()}).build();
    private static final SdkField<GitHubCodeDestination> GIT_HUB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CodeDestination.getter(CodeDestination::gitHub)).setter(CodeDestination.setter(Builder::gitHub)).constructor(GitHubCodeDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitHub").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_COMMIT_FIELD, GIT_HUB_FIELD));
    private static final long serialVersionUID = 1L;
    private final CodeCommitCodeDestination codeCommit;
    private final GitHubCodeDestination gitHub;

    private CodeDestination(BuilderImpl builder) {
        this.codeCommit = builder.codeCommit;
        this.gitHub = builder.gitHub;
    }

    public CodeCommitCodeDestination codeCommit() {
        return this.codeCommit;
    }

    public GitHubCodeDestination gitHub() {
        return this.gitHub;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeCommit());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitHub());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeDestination)) {
            return false;
        }
        CodeDestination other = (CodeDestination)obj;
        return Objects.equals(this.codeCommit(), other.codeCommit()) && Objects.equals(this.gitHub(), other.gitHub());
    }

    public String toString() {
        return ToString.builder((String)"CodeDestination").add("CodeCommit", (Object)this.codeCommit()).add("GitHub", (Object)this.gitHub()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "codeCommit": {
                return Optional.ofNullable(clazz.cast(this.codeCommit()));
            }
            case "gitHub": {
                return Optional.ofNullable(clazz.cast(this.gitHub()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeDestination, T> g) {
        return obj -> g.apply((CodeDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CodeCommitCodeDestination codeCommit;
        private GitHubCodeDestination gitHub;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeDestination model) {
            this.codeCommit(model.codeCommit);
            this.gitHub(model.gitHub);
        }

        public final CodeCommitCodeDestination.Builder getCodeCommit() {
            return this.codeCommit != null ? this.codeCommit.toBuilder() : null;
        }

        @Override
        public final Builder codeCommit(CodeCommitCodeDestination codeCommit) {
            this.codeCommit = codeCommit;
            return this;
        }

        public final void setCodeCommit(CodeCommitCodeDestination.BuilderImpl codeCommit) {
            this.codeCommit = codeCommit != null ? codeCommit.build() : null;
        }

        public final GitHubCodeDestination.Builder getGitHub() {
            return this.gitHub != null ? this.gitHub.toBuilder() : null;
        }

        @Override
        public final Builder gitHub(GitHubCodeDestination gitHub) {
            this.gitHub = gitHub;
            return this;
        }

        public final void setGitHub(GitHubCodeDestination.BuilderImpl gitHub) {
            this.gitHub = gitHub != null ? gitHub.build() : null;
        }

        public CodeDestination build() {
            return new CodeDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeDestination> {
        public Builder codeCommit(CodeCommitCodeDestination var1);

        default public Builder codeCommit(Consumer<CodeCommitCodeDestination.Builder> codeCommit) {
            return this.codeCommit((CodeCommitCodeDestination)((CodeCommitCodeDestination.Builder)CodeCommitCodeDestination.builder().applyMutation(codeCommit)).build());
        }

        public Builder gitHub(GitHubCodeDestination var1);

        default public Builder gitHub(Consumer<GitHubCodeDestination.Builder> gitHub) {
            return this.gitHub((GitHubCodeDestination)((GitHubCodeDestination.Builder)GitHubCodeDestination.builder().applyMutation(gitHub)).build());
        }
    }
}

