/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codestar.model.CodeStarResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProjectResponse
extends CodeStarResponse
implements ToCopyableBuilder<Builder, CreateProjectResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProjectResponse.getter(CreateProjectResponse::id)).setter(CreateProjectResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProjectResponse.getter(CreateProjectResponse::arn)).setter(CreateProjectResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProjectResponse.getter(CreateProjectResponse::clientRequestToken)).setter(CreateProjectResponse.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<String> PROJECT_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProjectResponse.getter(CreateProjectResponse::projectTemplateId)).setter(CreateProjectResponse.setter(Builder::projectTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectTemplateId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, PROJECT_TEMPLATE_ID_FIELD));
    private final String id;
    private final String arn;
    private final String clientRequestToken;
    private final String projectTemplateId;

    private CreateProjectResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.clientRequestToken = builder.clientRequestToken;
        this.projectTemplateId = builder.projectTemplateId;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public String projectTemplateId() {
        return this.projectTemplateId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectTemplateId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectResponse)) {
            return false;
        }
        CreateProjectResponse other = (CreateProjectResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.projectTemplateId(), other.projectTemplateId());
    }

    public String toString() {
        return ToString.builder((String)"CreateProjectResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("ProjectTemplateId", (Object)this.projectTemplateId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "projectTemplateId": {
                return Optional.ofNullable(clazz.cast(this.projectTemplateId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectResponse, T> g) {
        return obj -> g.apply((CreateProjectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeStarResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String clientRequestToken;
        private String projectTemplateId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.clientRequestToken(model.clientRequestToken);
            this.projectTemplateId(model.projectTemplateId);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getProjectTemplateId() {
            return this.projectTemplateId;
        }

        @Override
        public final Builder projectTemplateId(String projectTemplateId) {
            this.projectTemplateId = projectTemplateId;
            return this;
        }

        public final void setProjectTemplateId(String projectTemplateId) {
            this.projectTemplateId = projectTemplateId;
        }

        @Override
        public CreateProjectResponse build() {
            return new CreateProjectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeStarResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProjectResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder clientRequestToken(String var1);

        public Builder projectTemplateId(String var1);
    }
}

