/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codestar.model.CodeStarRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUserProfileRequest
extends CodeStarRequest
implements ToCopyableBuilder<Builder, CreateUserProfileRequest> {
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateUserProfileRequest.getter(CreateUserProfileRequest::userArn)).setter(CreateUserProfileRequest.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateUserProfileRequest.getter(CreateUserProfileRequest::displayName)).setter(CreateUserProfileRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateUserProfileRequest.getter(CreateUserProfileRequest::emailAddress)).setter(CreateUserProfileRequest.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()}).build();
    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateUserProfileRequest.getter(CreateUserProfileRequest::sshPublicKey)).setter(CreateUserProfileRequest.setter(Builder::sshPublicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sshPublicKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ARN_FIELD, DISPLAY_NAME_FIELD, EMAIL_ADDRESS_FIELD, SSH_PUBLIC_KEY_FIELD));
    private final String userArn;
    private final String displayName;
    private final String emailAddress;
    private final String sshPublicKey;

    private CreateUserProfileRequest(BuilderImpl builder) {
        super(builder);
        this.userArn = builder.userArn;
        this.displayName = builder.displayName;
        this.emailAddress = builder.emailAddress;
        this.sshPublicKey = builder.sshPublicKey;
    }

    public String userArn() {
        return this.userArn;
    }

    public String displayName() {
        return this.displayName;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public String sshPublicKey() {
        return this.sshPublicKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserProfileRequest)) {
            return false;
        }
        CreateUserProfileRequest other = (CreateUserProfileRequest)((Object)obj);
        return Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.sshPublicKey(), other.sshPublicKey());
    }

    public String toString() {
        return ToString.builder((String)"CreateUserProfileRequest").add("UserArn", (Object)this.userArn()).add("DisplayName", (Object)this.displayName()).add("EmailAddress", (Object)this.emailAddress()).add("SshPublicKey", (Object)this.sshPublicKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "emailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "sshPublicKey": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKey()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserProfileRequest, T> g) {
        return obj -> g.apply((CreateUserProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeStarRequest.BuilderImpl
    implements Builder {
        private String userArn;
        private String displayName;
        private String emailAddress;
        private String sshPublicKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserProfileRequest model) {
            super(model);
            this.userArn(model.userArn);
            this.displayName(model.displayName);
            this.emailAddress(model.emailAddress);
            this.sshPublicKey(model.sshPublicKey);
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getSshPublicKey() {
            return this.sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserProfileRequest build() {
            return new CreateUserProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeStarRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUserProfileRequest> {
        public Builder userArn(String var1);

        public Builder displayName(String var1);

        public Builder emailAddress(String var1);

        public Builder sshPublicKey(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

