/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codestar.model.CodeStarRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTeamMemberRequest
extends CodeStarRequest
implements ToCopyableBuilder<Builder, UpdateTeamMemberRequest> {
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateTeamMemberRequest.getter(UpdateTeamMemberRequest::projectId)).setter(UpdateTeamMemberRequest.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()}).build();
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateTeamMemberRequest.getter(UpdateTeamMemberRequest::userArn)).setter(UpdateTeamMemberRequest.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()}).build();
    private static final SdkField<String> PROJECT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateTeamMemberRequest.getter(UpdateTeamMemberRequest::projectRole)).setter(UpdateTeamMemberRequest.setter(Builder::projectRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectRole").build()}).build();
    private static final SdkField<Boolean> REMOTE_ACCESS_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateTeamMemberRequest.getter(UpdateTeamMemberRequest::remoteAccessAllowed)).setter(UpdateTeamMemberRequest.setter(Builder::remoteAccessAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccessAllowed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ID_FIELD, USER_ARN_FIELD, PROJECT_ROLE_FIELD, REMOTE_ACCESS_ALLOWED_FIELD));
    private final String projectId;
    private final String userArn;
    private final String projectRole;
    private final Boolean remoteAccessAllowed;

    private UpdateTeamMemberRequest(BuilderImpl builder) {
        super(builder);
        this.projectId = builder.projectId;
        this.userArn = builder.userArn;
        this.projectRole = builder.projectRole;
        this.remoteAccessAllowed = builder.remoteAccessAllowed;
    }

    public String projectId() {
        return this.projectId;
    }

    public String userArn() {
        return this.userArn;
    }

    public String projectRole() {
        return this.projectRole;
    }

    public Boolean remoteAccessAllowed() {
        return this.remoteAccessAllowed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAccessAllowed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTeamMemberRequest)) {
            return false;
        }
        UpdateTeamMemberRequest other = (UpdateTeamMemberRequest)((Object)obj);
        return Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.projectRole(), other.projectRole()) && Objects.equals(this.remoteAccessAllowed(), other.remoteAccessAllowed());
    }

    public String toString() {
        return ToString.builder((String)"UpdateTeamMemberRequest").add("ProjectId", (Object)this.projectId()).add("UserArn", (Object)this.userArn()).add("ProjectRole", (Object)this.projectRole()).add("RemoteAccessAllowed", (Object)this.remoteAccessAllowed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "userArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "projectRole": {
                return Optional.ofNullable(clazz.cast(this.projectRole()));
            }
            case "remoteAccessAllowed": {
                return Optional.ofNullable(clazz.cast(this.remoteAccessAllowed()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTeamMemberRequest, T> g) {
        return obj -> g.apply((UpdateTeamMemberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeStarRequest.BuilderImpl
    implements Builder {
        private String projectId;
        private String userArn;
        private String projectRole;
        private Boolean remoteAccessAllowed;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTeamMemberRequest model) {
            super(model);
            this.projectId(model.projectId);
            this.userArn(model.userArn);
            this.projectRole(model.projectRole);
            this.remoteAccessAllowed(model.remoteAccessAllowed);
        }

        public final String getProjectId() {
            return this.projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getProjectRole() {
            return this.projectRole;
        }

        @Override
        public final Builder projectRole(String projectRole) {
            this.projectRole = projectRole;
            return this;
        }

        public final void setProjectRole(String projectRole) {
            this.projectRole = projectRole;
        }

        public final Boolean getRemoteAccessAllowed() {
            return this.remoteAccessAllowed;
        }

        @Override
        public final Builder remoteAccessAllowed(Boolean remoteAccessAllowed) {
            this.remoteAccessAllowed = remoteAccessAllowed;
            return this;
        }

        public final void setRemoteAccessAllowed(Boolean remoteAccessAllowed) {
            this.remoteAccessAllowed = remoteAccessAllowed;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTeamMemberRequest build() {
            return new UpdateTeamMemberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeStarRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTeamMemberRequest> {
        public Builder projectId(String var1);

        public Builder userArn(String var1);

        public Builder projectRole(String var1);

        public Builder remoteAccessAllowed(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

