/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateTeamMemberRequest extends CodeStarRequest implements
        ToCopyableBuilder<AssociateTeamMemberRequest.Builder, AssociateTeamMemberRequest> {
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateTeamMemberRequest::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateTeamMemberRequest::clientRequestToken)).setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateTeamMemberRequest::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()).build();

    private static final SdkField<String> PROJECT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateTeamMemberRequest::projectRole)).setter(setter(Builder::projectRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectRole").build()).build();

    private static final SdkField<Boolean> REMOTE_ACCESS_ALLOWED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AssociateTeamMemberRequest::remoteAccessAllowed)).setter(setter(Builder::remoteAccessAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccessAllowed").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ID_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, USER_ARN_FIELD, PROJECT_ROLE_FIELD, REMOTE_ACCESS_ALLOWED_FIELD));

    private final String projectId;

    private final String clientRequestToken;

    private final String userArn;

    private final String projectRole;

    private final Boolean remoteAccessAllowed;

    private AssociateTeamMemberRequest(BuilderImpl builder) {
        super(builder);
        this.projectId = builder.projectId;
        this.clientRequestToken = builder.clientRequestToken;
        this.userArn = builder.userArn;
        this.projectRole = builder.projectRole;
        this.remoteAccessAllowed = builder.remoteAccessAllowed;
    }

    /**
     * <p>
     * The ID of the project to which you will add the IAM user.
     * </p>
     * 
     * @return The ID of the project to which you will add the IAM user.
     */
    public String projectId() {
        return projectId;
    }

    /**
     * <p>
     * A user- or system-generated token that identifies the entity that requested the team member association to the
     * project. This token can be used to repeat the request.
     * </p>
     * 
     * @return A user- or system-generated token that identifies the entity that requested the team member association
     *         to the project. This token can be used to repeat the request.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the IAM user you want to add to the AWS CodeStar project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the IAM user you want to add to the AWS CodeStar project.
     */
    public String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The AWS CodeStar project role that will apply to this user. This role determines what actions a user can take in
     * an AWS CodeStar project.
     * </p>
     * 
     * @return The AWS CodeStar project role that will apply to this user. This role determines what actions a user can
     *         take in an AWS CodeStar project.
     */
    public String projectRole() {
        return projectRole;
    }

    /**
     * <p>
     * Whether the team member is allowed to use an SSH public/private key pair to remotely access project resources,
     * for example Amazon EC2 instances.
     * </p>
     * 
     * @return Whether the team member is allowed to use an SSH public/private key pair to remotely access project
     *         resources, for example Amazon EC2 instances.
     */
    public Boolean remoteAccessAllowed() {
        return remoteAccessAllowed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(projectRole());
        hashCode = 31 * hashCode + Objects.hashCode(remoteAccessAllowed());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateTeamMemberRequest)) {
            return false;
        }
        AssociateTeamMemberRequest other = (AssociateTeamMemberRequest) obj;
        return Objects.equals(projectId(), other.projectId()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(userArn(), other.userArn()) && Objects.equals(projectRole(), other.projectRole())
                && Objects.equals(remoteAccessAllowed(), other.remoteAccessAllowed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateTeamMemberRequest").add("ProjectId", projectId())
                .add("ClientRequestToken", clientRequestToken()).add("UserArn", userArn()).add("ProjectRole", projectRole())
                .add("RemoteAccessAllowed", remoteAccessAllowed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "userArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "projectRole":
            return Optional.ofNullable(clazz.cast(projectRole()));
        case "remoteAccessAllowed":
            return Optional.ofNullable(clazz.cast(remoteAccessAllowed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateTeamMemberRequest, T> g) {
        return obj -> g.apply((AssociateTeamMemberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateTeamMemberRequest> {
        /**
         * <p>
         * The ID of the project to which you will add the IAM user.
         * </p>
         * 
         * @param projectId
         *        The ID of the project to which you will add the IAM user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * A user- or system-generated token that identifies the entity that requested the team member association to
         * the project. This token can be used to repeat the request.
         * </p>
         * 
         * @param clientRequestToken
         *        A user- or system-generated token that identifies the entity that requested the team member
         *        association to the project. This token can be used to repeat the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the IAM user you want to add to the AWS CodeStar project.
         * </p>
         * 
         * @param userArn
         *        The Amazon Resource Name (ARN) for the IAM user you want to add to the AWS CodeStar project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The AWS CodeStar project role that will apply to this user. This role determines what actions a user can take
         * in an AWS CodeStar project.
         * </p>
         * 
         * @param projectRole
         *        The AWS CodeStar project role that will apply to this user. This role determines what actions a user
         *        can take in an AWS CodeStar project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectRole(String projectRole);

        /**
         * <p>
         * Whether the team member is allowed to use an SSH public/private key pair to remotely access project
         * resources, for example Amazon EC2 instances.
         * </p>
         * 
         * @param remoteAccessAllowed
         *        Whether the team member is allowed to use an SSH public/private key pair to remotely access project
         *        resources, for example Amazon EC2 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessAllowed(Boolean remoteAccessAllowed);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeStarRequest.BuilderImpl implements Builder {
        private String projectId;

        private String clientRequestToken;

        private String userArn;

        private String projectRole;

        private Boolean remoteAccessAllowed;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateTeamMemberRequest model) {
            super(model);
            projectId(model.projectId);
            clientRequestToken(model.clientRequestToken);
            userArn(model.userArn);
            projectRole(model.projectRole);
            remoteAccessAllowed(model.remoteAccessAllowed);
        }

        public final String getProjectId() {
            return projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getUserArn() {
            return userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getProjectRole() {
            return projectRole;
        }

        @Override
        public final Builder projectRole(String projectRole) {
            this.projectRole = projectRole;
            return this;
        }

        public final void setProjectRole(String projectRole) {
            this.projectRole = projectRole;
        }

        public final Boolean getRemoteAccessAllowed() {
            return remoteAccessAllowed;
        }

        @Override
        public final Builder remoteAccessAllowed(Boolean remoteAccessAllowed) {
            this.remoteAccessAllowed = remoteAccessAllowed;
            return this;
        }

        public final void setRemoteAccessAllowed(Boolean remoteAccessAllowed) {
            this.remoteAccessAllowed = remoteAccessAllowed;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateTeamMemberRequest build() {
            return new AssociateTeamMemberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
