/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProjectResponse extends CodeStarResponse implements
        ToCopyableBuilder<CreateProjectResponse.Builder, CreateProjectResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProjectResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProjectResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProjectResponse::clientRequestToken)).setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<String> PROJECT_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProjectResponse::projectTemplateId)).setter(setter(Builder::projectTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectTemplateId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, PROJECT_TEMPLATE_ID_FIELD));

    private final String id;

    private final String arn;

    private final String clientRequestToken;

    private final String projectTemplateId;

    private CreateProjectResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.clientRequestToken = builder.clientRequestToken;
        this.projectTemplateId = builder.projectTemplateId;
    }

    /**
     * <p>
     * The ID of the project.
     * </p>
     * 
     * @return The ID of the project.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the created project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the created project.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * A user- or system-generated token that identifies the entity that requested project creation.
     * </p>
     * 
     * @return A user- or system-generated token that identifies the entity that requested project creation.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public String projectTemplateId() {
        return projectTemplateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(projectTemplateId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectResponse)) {
            return false;
        }
        CreateProjectResponse other = (CreateProjectResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(projectTemplateId(), other.projectTemplateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateProjectResponse").add("Id", id()).add("Arn", arn())
                .add("ClientRequestToken", clientRequestToken()).add("ProjectTemplateId", projectTemplateId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "projectTemplateId":
            return Optional.ofNullable(clazz.cast(projectTemplateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectResponse, T> g) {
        return obj -> g.apply((CreateProjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateProjectResponse> {
        /**
         * <p>
         * The ID of the project.
         * </p>
         * 
         * @param id
         *        The ID of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the created project.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the created project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A user- or system-generated token that identifies the entity that requested project creation.
         * </p>
         * 
         * @param clientRequestToken
         *        A user- or system-generated token that identifies the entity that requested project creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param projectTemplateId
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectTemplateId(String projectTemplateId);
    }

    static final class BuilderImpl extends CodeStarResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String clientRequestToken;

        private String projectTemplateId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            clientRequestToken(model.clientRequestToken);
            projectTemplateId(model.projectTemplateId);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getProjectTemplateId() {
            return projectTemplateId;
        }

        @Override
        public final Builder projectTemplateId(String projectTemplateId) {
            this.projectTemplateId = projectTemplateId;
            return this;
        }

        public final void setProjectTemplateId(String projectTemplateId) {
            this.projectTemplateId = projectTemplateId;
        }

        @Override
        public CreateProjectResponse build() {
            return new CreateProjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
