/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codestar.model.CodeStarResponse;
import software.amazon.awssdk.services.codestar.model.TeamMember;
import software.amazon.awssdk.services.codestar.model.TeamMemberResultCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTeamMembersResponse
extends CodeStarResponse
implements ToCopyableBuilder<Builder, ListTeamMembersResponse> {
    private static final SdkField<List<TeamMember>> TEAM_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListTeamMembersResponse.getter(ListTeamMembersResponse::teamMembers)).setter(ListTeamMembersResponse.setter(Builder::teamMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teamMembers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TeamMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTeamMembersResponse.getter(ListTeamMembersResponse::nextToken)).setter(ListTeamMembersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEAM_MEMBERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TeamMember> teamMembers;
    private final String nextToken;

    private ListTeamMembersResponse(BuilderImpl builder) {
        super(builder);
        this.teamMembers = builder.teamMembers;
        this.nextToken = builder.nextToken;
    }

    public List<TeamMember> teamMembers() {
        return this.teamMembers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.teamMembers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTeamMembersResponse)) {
            return false;
        }
        ListTeamMembersResponse other = (ListTeamMembersResponse)((Object)obj);
        return Objects.equals(this.teamMembers(), other.teamMembers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTeamMembersResponse").add("TeamMembers", this.teamMembers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "teamMembers": {
                return Optional.ofNullable(clazz.cast(this.teamMembers()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTeamMembersResponse, T> g) {
        return obj -> g.apply((ListTeamMembersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeStarResponse.BuilderImpl
    implements Builder {
        private List<TeamMember> teamMembers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTeamMembersResponse model) {
            super(model);
            this.teamMembers(model.teamMembers);
            this.nextToken(model.nextToken);
        }

        public final Collection<TeamMember.Builder> getTeamMembers() {
            return this.teamMembers != null ? (Collection)this.teamMembers.stream().map(TeamMember::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder teamMembers(Collection<TeamMember> teamMembers) {
            this.teamMembers = TeamMemberResultCopier.copy(teamMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder teamMembers(TeamMember ... teamMembers) {
            this.teamMembers(Arrays.asList(teamMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder teamMembers(Consumer<TeamMember.Builder> ... teamMembers) {
            this.teamMembers(Stream.of(teamMembers).map(c -> (TeamMember)((TeamMember.Builder)TeamMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTeamMembers(Collection<TeamMember.BuilderImpl> teamMembers) {
            this.teamMembers = TeamMemberResultCopier.copyFromBuilder(teamMembers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTeamMembersResponse build() {
            return new ListTeamMembersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeStarResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTeamMembersResponse> {
        public Builder teamMembers(Collection<TeamMember> var1);

        public Builder teamMembers(TeamMember ... var1);

        public Builder teamMembers(Consumer<TeamMember.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

