/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateHostRequest extends CodeStarConnectionsRequest implements
        ToCopyableBuilder<UpdateHostRequest.Builder, UpdateHostRequest> {
    private static final SdkField<String> HOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostArn").getter(getter(UpdateHostRequest::hostArn)).setter(setter(Builder::hostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostArn").build()).build();

    private static final SdkField<String> PROVIDER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderEndpoint").getter(getter(UpdateHostRequest::providerEndpoint))
            .setter(setter(Builder::providerEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderEndpoint").build()).build();

    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<VpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(UpdateHostRequest::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(VpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_ARN_FIELD,
            PROVIDER_ENDPOINT_FIELD, VPC_CONFIGURATION_FIELD));

    private final String hostArn;

    private final String providerEndpoint;

    private final VpcConfiguration vpcConfiguration;

    private UpdateHostRequest(BuilderImpl builder) {
        super(builder);
        this.hostArn = builder.hostArn;
        this.providerEndpoint = builder.providerEndpoint;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the host to be updated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the host to be updated.
     */
    public final String hostArn() {
        return hostArn;
    }

    /**
     * <p>
     * The URL or endpoint of the host to be updated.
     * </p>
     * 
     * @return The URL or endpoint of the host to be updated.
     */
    public final String providerEndpoint() {
        return providerEndpoint;
    }

    /**
     * <p>
     * The VPC configuration of the host to be updated. A VPC must be configured and the infrastructure to be
     * represented by the host must already be connected to the VPC.
     * </p>
     * 
     * @return The VPC configuration of the host to be updated. A VPC must be configured and the infrastructure to be
     *         represented by the host must already be connected to the VPC.
     */
    public final VpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hostArn());
        hashCode = 31 * hashCode + Objects.hashCode(providerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHostRequest)) {
            return false;
        }
        UpdateHostRequest other = (UpdateHostRequest) obj;
        return Objects.equals(hostArn(), other.hostArn()) && Objects.equals(providerEndpoint(), other.providerEndpoint())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateHostRequest").add("HostArn", hostArn()).add("ProviderEndpoint", providerEndpoint())
                .add("VpcConfiguration", vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostArn":
            return Optional.ofNullable(clazz.cast(hostArn()));
        case "ProviderEndpoint":
            return Optional.ofNullable(clazz.cast(providerEndpoint()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateHostRequest, T> g) {
        return obj -> g.apply((UpdateHostRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarConnectionsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateHostRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the host to be updated.
         * </p>
         * 
         * @param hostArn
         *        The Amazon Resource Name (ARN) of the host to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostArn(String hostArn);

        /**
         * <p>
         * The URL or endpoint of the host to be updated.
         * </p>
         * 
         * @param providerEndpoint
         *        The URL or endpoint of the host to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerEndpoint(String providerEndpoint);

        /**
         * <p>
         * The VPC configuration of the host to be updated. A VPC must be configured and the infrastructure to be
         * represented by the host must already be connected to the VPC.
         * </p>
         * 
         * @param vpcConfiguration
         *        The VPC configuration of the host to be updated. A VPC must be configured and the infrastructure to be
         *        represented by the host must already be connected to the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(VpcConfiguration vpcConfiguration);

        /**
         * <p>
         * The VPC configuration of the host to be updated. A VPC must be configured and the infrastructure to be
         * represented by the host must already be connected to the VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfiguration.Builder} avoiding the
         * need to create one manually via {@link VpcConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfiguration(VpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link VpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(VpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(VpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeStarConnectionsRequest.BuilderImpl implements Builder {
        private String hostArn;

        private String providerEndpoint;

        private VpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHostRequest model) {
            super(model);
            hostArn(model.hostArn);
            providerEndpoint(model.providerEndpoint);
            vpcConfiguration(model.vpcConfiguration);
        }

        public final String getHostArn() {
            return hostArn;
        }

        public final void setHostArn(String hostArn) {
            this.hostArn = hostArn;
        }

        @Override
        public final Builder hostArn(String hostArn) {
            this.hostArn = hostArn;
            return this;
        }

        public final String getProviderEndpoint() {
            return providerEndpoint;
        }

        public final void setProviderEndpoint(String providerEndpoint) {
            this.providerEndpoint = providerEndpoint;
        }

        @Override
        public final Builder providerEndpoint(String providerEndpoint) {
            this.providerEndpoint = providerEndpoint;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHostRequest build() {
            return new UpdateHostRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
