/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarconnections;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.codestarconnections.model.CreateConnectionRequest;
import software.amazon.awssdk.services.codestarconnections.model.CreateConnectionResponse;
import software.amazon.awssdk.services.codestarconnections.model.CreateHostRequest;
import software.amazon.awssdk.services.codestarconnections.model.CreateHostResponse;
import software.amazon.awssdk.services.codestarconnections.model.CreateRepositoryLinkRequest;
import software.amazon.awssdk.services.codestarconnections.model.CreateRepositoryLinkResponse;
import software.amazon.awssdk.services.codestarconnections.model.CreateSyncConfigurationRequest;
import software.amazon.awssdk.services.codestarconnections.model.CreateSyncConfigurationResponse;
import software.amazon.awssdk.services.codestarconnections.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.codestarconnections.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.codestarconnections.model.DeleteHostRequest;
import software.amazon.awssdk.services.codestarconnections.model.DeleteHostResponse;
import software.amazon.awssdk.services.codestarconnections.model.DeleteRepositoryLinkRequest;
import software.amazon.awssdk.services.codestarconnections.model.DeleteRepositoryLinkResponse;
import software.amazon.awssdk.services.codestarconnections.model.DeleteSyncConfigurationRequest;
import software.amazon.awssdk.services.codestarconnections.model.DeleteSyncConfigurationResponse;
import software.amazon.awssdk.services.codestarconnections.model.GetConnectionRequest;
import software.amazon.awssdk.services.codestarconnections.model.GetConnectionResponse;
import software.amazon.awssdk.services.codestarconnections.model.GetHostRequest;
import software.amazon.awssdk.services.codestarconnections.model.GetHostResponse;
import software.amazon.awssdk.services.codestarconnections.model.GetRepositoryLinkRequest;
import software.amazon.awssdk.services.codestarconnections.model.GetRepositoryLinkResponse;
import software.amazon.awssdk.services.codestarconnections.model.GetRepositorySyncStatusRequest;
import software.amazon.awssdk.services.codestarconnections.model.GetRepositorySyncStatusResponse;
import software.amazon.awssdk.services.codestarconnections.model.GetResourceSyncStatusRequest;
import software.amazon.awssdk.services.codestarconnections.model.GetResourceSyncStatusResponse;
import software.amazon.awssdk.services.codestarconnections.model.GetSyncBlockerSummaryRequest;
import software.amazon.awssdk.services.codestarconnections.model.GetSyncBlockerSummaryResponse;
import software.amazon.awssdk.services.codestarconnections.model.GetSyncConfigurationRequest;
import software.amazon.awssdk.services.codestarconnections.model.GetSyncConfigurationResponse;
import software.amazon.awssdk.services.codestarconnections.model.ListConnectionsRequest;
import software.amazon.awssdk.services.codestarconnections.model.ListConnectionsResponse;
import software.amazon.awssdk.services.codestarconnections.model.ListHostsRequest;
import software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse;
import software.amazon.awssdk.services.codestarconnections.model.ListRepositoryLinksRequest;
import software.amazon.awssdk.services.codestarconnections.model.ListRepositoryLinksResponse;
import software.amazon.awssdk.services.codestarconnections.model.ListRepositorySyncDefinitionsRequest;
import software.amazon.awssdk.services.codestarconnections.model.ListRepositorySyncDefinitionsResponse;
import software.amazon.awssdk.services.codestarconnections.model.ListSyncConfigurationsRequest;
import software.amazon.awssdk.services.codestarconnections.model.ListSyncConfigurationsResponse;
import software.amazon.awssdk.services.codestarconnections.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codestarconnections.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codestarconnections.model.TagResourceRequest;
import software.amazon.awssdk.services.codestarconnections.model.TagResourceResponse;
import software.amazon.awssdk.services.codestarconnections.model.UntagResourceRequest;
import software.amazon.awssdk.services.codestarconnections.model.UntagResourceResponse;
import software.amazon.awssdk.services.codestarconnections.model.UpdateHostRequest;
import software.amazon.awssdk.services.codestarconnections.model.UpdateHostResponse;
import software.amazon.awssdk.services.codestarconnections.model.UpdateRepositoryLinkRequest;
import software.amazon.awssdk.services.codestarconnections.model.UpdateRepositoryLinkResponse;
import software.amazon.awssdk.services.codestarconnections.model.UpdateSyncBlockerRequest;
import software.amazon.awssdk.services.codestarconnections.model.UpdateSyncBlockerResponse;
import software.amazon.awssdk.services.codestarconnections.model.UpdateSyncConfigurationRequest;
import software.amazon.awssdk.services.codestarconnections.model.UpdateSyncConfigurationResponse;
import software.amazon.awssdk.services.codestarconnections.paginators.ListConnectionsPublisher;
import software.amazon.awssdk.services.codestarconnections.paginators.ListHostsPublisher;
import software.amazon.awssdk.services.codestarconnections.paginators.ListRepositoryLinksPublisher;
import software.amazon.awssdk.services.codestarconnections.paginators.ListSyncConfigurationsPublisher;

/**
 * Service client for accessing AWS CodeStar connections asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <fullname>AWS CodeStar Connections</fullname>
 * <p>
 * This Amazon Web Services CodeStar Connections API Reference provides descriptions and usage examples of the
 * operations and data types for the Amazon Web Services CodeStar Connections API. You can use the connections API to
 * work with connections and installations.
 * </p>
 * <p>
 * <i>Connections</i> are configurations that you use to connect Amazon Web Services resources to external code
 * repositories. Each connection is a resource that can be given to services such as CodePipeline to connect to a
 * third-party repository such as Bitbucket. For example, you can add the connection in CodePipeline so that it triggers
 * your pipeline when a code change is made to your third-party code repository. Each connection is named and associated
 * with a unique ARN that is used to reference the connection.
 * </p>
 * <p>
 * When you create a connection, the console initiates a third-party connection handshake. <i>Installations</i> are the
 * apps that are used to conduct this handshake. For example, the installation for the Bitbucket provider type is the
 * Bitbucket app. When you create a connection, you can choose an existing installation or create one.
 * </p>
 * <p>
 * When you want to create a connection to an installed provider type such as GitHub Enterprise Server, you create a
 * <i>host</i> for your connections.
 * </p>
 * <p>
 * You can work with connections by calling:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateConnection</a>, which creates a uniquely named connection that can be referenced by services such as
 * CodePipeline.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteConnection</a>, which deletes the specified connection.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetConnection</a>, which returns information about the connection, including the connection status.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListConnections</a>, which lists the connections associated with your account.
 * </p>
 * </li>
 * </ul>
 * <p>
 * You can work with hosts by calling:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateHost</a>, which creates a host that represents the infrastructure where your provider is installed.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteHost</a>, which deletes the specified host.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetHost</a>, which returns information about the host, including the setup status.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListHosts</a>, which lists the hosts associated with your account.
 * </p>
 * </li>
 * </ul>
 * <p>
 * You can work with tags in Amazon Web Services CodeStar Connections by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>ListTagsForResource</a>, which gets information about Amazon Web Services tags for a specified Amazon Resource
 * Name (ARN) in Amazon Web Services CodeStar Connections.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>TagResource</a>, which adds or updates tags for a resource in Amazon Web Services CodeStar Connections.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UntagResource</a>, which removes tags for a resource in Amazon Web Services CodeStar Connections.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For information about how to use Amazon Web Services CodeStar Connections, see the <a
 * href="https://docs.aws.amazon.com/dtconsole/latest/userguide/welcome-connections.html">Developer Tools User
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CodeStarConnectionsAsyncClient extends AwsClient {
    String SERVICE_NAME = "codestar-connections";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "codestar-connections";

    /**
     * <p>
     * Creates a connection that can then be given to other Amazon Web Services services like CodePipeline so that it
     * can access third-party code repositories. The connection is in pending status until the third-party connection
     * handshake is completed from the console.
     * </p>
     *
     * @param createConnectionRequest
     * @return A Java Future containing the result of the CreateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Exceeded the maximum limit for connections.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ResourceUnavailableException Resource not found. Verify the ARN for the host resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectionResponse> createConnection(CreateConnectionRequest createConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a connection that can then be given to other Amazon Web Services services like CodePipeline so that it
     * can access third-party code repositories. The connection is in pending status until the third-party connection
     * handshake is completed from the console.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectionRequest#builder()}
     * </p>
     *
     * @param createConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.CreateConnectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Exceeded the maximum limit for connections.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ResourceUnavailableException Resource not found. Verify the ARN for the host resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectionResponse> createConnection(
            Consumer<CreateConnectionRequest.Builder> createConnectionRequest) {
        return createConnection(CreateConnectionRequest.builder().applyMutation(createConnectionRequest).build());
    }

    /**
     * <p>
     * Creates a resource that represents the infrastructure where a third-party provider is installed. The host is used
     * when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You
     * create one host for all connections to that provider.
     * </p>
     * <note>
     * <p>
     * A host created through the CLI or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE`
     * by setting up the host in the console.
     * </p>
     * </note>
     *
     * @param createHostRequest
     * @return A Java Future containing the result of the CreateHost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Exceeded the maximum limit for connections.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.CreateHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateHost"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHostResponse> createHost(CreateHostRequest createHostRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resource that represents the infrastructure where a third-party provider is installed. The host is used
     * when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You
     * create one host for all connections to that provider.
     * </p>
     * <note>
     * <p>
     * A host created through the CLI or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE`
     * by setting up the host in the console.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHostRequest.Builder} avoiding the need to
     * create one manually via {@link CreateHostRequest#builder()}
     * </p>
     *
     * @param createHostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.CreateHostRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateHost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Exceeded the maximum limit for connections.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.CreateHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateHost"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHostResponse> createHost(Consumer<CreateHostRequest.Builder> createHostRequest) {
        return createHost(CreateHostRequest.builder().applyMutation(createHostRequest).build());
    }

    /**
     * <p>
     * Creates a link to a specified external Git repository. A repository link allows Git sync to monitor and sync
     * changes to files in a specified Git repository.
     * </p>
     *
     * @param createRepositoryLinkRequest
     * @return A Java Future containing the result of the CreateRepositoryLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>LimitExceededException Exceeded the maximum limit for connections.</li>
     *         <li>ResourceAlreadyExistsException Unable to create resource. Resource already exists.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.CreateRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRepositoryLinkResponse> createRepositoryLink(
            CreateRepositoryLinkRequest createRepositoryLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a link to a specified external Git repository. A repository link allows Git sync to monitor and sync
     * changes to files in a specified Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRepositoryLinkRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRepositoryLinkRequest#builder()}
     * </p>
     *
     * @param createRepositoryLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.CreateRepositoryLinkRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateRepositoryLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>LimitExceededException Exceeded the maximum limit for connections.</li>
     *         <li>ResourceAlreadyExistsException Unable to create resource. Resource already exists.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.CreateRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRepositoryLinkResponse> createRepositoryLink(
            Consumer<CreateRepositoryLinkRequest.Builder> createRepositoryLinkRequest) {
        return createRepositoryLink(CreateRepositoryLinkRequest.builder().applyMutation(createRepositoryLinkRequest).build());
    }

    /**
     * <p>
     * Creates a sync configuration which allows Amazon Web Services to sync content from a Git repository to update a
     * specified Amazon Web Services resource. Parameters for the sync configuration are determined by the sync type.
     * </p>
     *
     * @param createSyncConfigurationRequest
     * @return A Java Future containing the result of the CreateSyncConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>LimitExceededException Exceeded the maximum limit for connections.</li>
     *         <li>ResourceAlreadyExistsException Unable to create resource. Resource already exists.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.CreateSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSyncConfigurationResponse> createSyncConfiguration(
            CreateSyncConfigurationRequest createSyncConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a sync configuration which allows Amazon Web Services to sync content from a Git repository to update a
     * specified Amazon Web Services resource. Parameters for the sync configuration are determined by the sync type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSyncConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSyncConfigurationRequest#builder()}
     * </p>
     *
     * @param createSyncConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.CreateSyncConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateSyncConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>LimitExceededException Exceeded the maximum limit for connections.</li>
     *         <li>ResourceAlreadyExistsException Unable to create resource. Resource already exists.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.CreateSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/CreateSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSyncConfigurationResponse> createSyncConfiguration(
            Consumer<CreateSyncConfigurationRequest.Builder> createSyncConfigurationRequest) {
        return createSyncConfiguration(CreateSyncConfigurationRequest.builder().applyMutation(createSyncConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * The connection to be deleted.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest deleteConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The connection to be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectionRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.DeleteConnectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectionResponse> deleteConnection(
            Consumer<DeleteConnectionRequest.Builder> deleteConnectionRequest) {
        return deleteConnection(DeleteConnectionRequest.builder().applyMutation(deleteConnectionRequest).build());
    }

    /**
     * <p>
     * The host to be deleted. Before you delete a host, all connections associated to the host must be deleted.
     * </p>
     * <note>
     * <p>
     * A host cannot be deleted if it is in the VPC_CONFIG_INITIALIZING or VPC_CONFIG_DELETING state.
     * </p>
     * </note>
     *
     * @param deleteHostRequest
     * @return A Java Future containing the result of the DeleteHost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ResourceUnavailableException Resource not found. Verify the ARN for the host resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.DeleteHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteHost"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHostResponse> deleteHost(DeleteHostRequest deleteHostRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The host to be deleted. Before you delete a host, all connections associated to the host must be deleted.
     * </p>
     * <note>
     * <p>
     * A host cannot be deleted if it is in the VPC_CONFIG_INITIALIZING or VPC_CONFIG_DELETING state.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHostRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteHostRequest#builder()}
     * </p>
     *
     * @param deleteHostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.DeleteHostRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteHost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ResourceUnavailableException Resource not found. Verify the ARN for the host resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.DeleteHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteHost"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHostResponse> deleteHost(Consumer<DeleteHostRequest.Builder> deleteHostRequest) {
        return deleteHost(DeleteHostRequest.builder().applyMutation(deleteHostRequest).build());
    }

    /**
     * <p>
     * Deletes the association between your connection and a specified external Git repository.
     * </p>
     *
     * @param deleteRepositoryLinkRequest
     * @return A Java Future containing the result of the DeleteRepositoryLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>SyncConfigurationStillExistsException Unable to continue. The sync blocker still exists.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>UnsupportedProviderTypeException The specified provider type is not supported for connections.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.DeleteRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryLinkResponse> deleteRepositoryLink(
            DeleteRepositoryLinkRequest deleteRepositoryLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the association between your connection and a specified external Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRepositoryLinkRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRepositoryLinkRequest#builder()}
     * </p>
     *
     * @param deleteRepositoryLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.DeleteRepositoryLinkRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRepositoryLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>SyncConfigurationStillExistsException Unable to continue. The sync blocker still exists.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>UnsupportedProviderTypeException The specified provider type is not supported for connections.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.DeleteRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryLinkResponse> deleteRepositoryLink(
            Consumer<DeleteRepositoryLinkRequest.Builder> deleteRepositoryLinkRequest) {
        return deleteRepositoryLink(DeleteRepositoryLinkRequest.builder().applyMutation(deleteRepositoryLinkRequest).build());
    }

    /**
     * <p>
     * Deletes the sync configuration for a specified repository and connection.
     * </p>
     *
     * @param deleteSyncConfigurationRequest
     * @return A Java Future containing the result of the DeleteSyncConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>LimitExceededException Exceeded the maximum limit for connections.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.DeleteSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSyncConfigurationResponse> deleteSyncConfiguration(
            DeleteSyncConfigurationRequest deleteSyncConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the sync configuration for a specified repository and connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSyncConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSyncConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteSyncConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.DeleteSyncConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteSyncConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>LimitExceededException Exceeded the maximum limit for connections.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.DeleteSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/DeleteSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSyncConfigurationResponse> deleteSyncConfiguration(
            Consumer<DeleteSyncConfigurationRequest.Builder> deleteSyncConfigurationRequest) {
        return deleteSyncConfiguration(DeleteSyncConfigurationRequest.builder().applyMutation(deleteSyncConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Returns the connection ARN and details such as status, owner, and provider type.
     * </p>
     *
     * @param getConnectionRequest
     * @return A Java Future containing the result of the GetConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ResourceUnavailableException Resource not found. Verify the ARN for the host resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectionResponse> getConnection(GetConnectionRequest getConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the connection ARN and details such as status, owner, and provider type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionRequest#builder()}
     * </p>
     *
     * @param getConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.GetConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ResourceUnavailableException Resource not found. Verify the ARN for the host resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectionResponse> getConnection(Consumer<GetConnectionRequest.Builder> getConnectionRequest) {
        return getConnection(GetConnectionRequest.builder().applyMutation(getConnectionRequest).build());
    }

    /**
     * <p>
     * Returns the host ARN and details such as status, provider type, endpoint, and, if applicable, the VPC
     * configuration.
     * </p>
     *
     * @param getHostRequest
     * @return A Java Future containing the result of the GetHost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ResourceUnavailableException Resource not found. Verify the ARN for the host resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.GetHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetHost" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHostResponse> getHost(GetHostRequest getHostRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the host ARN and details such as status, provider type, endpoint, and, if applicable, the VPC
     * configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHostRequest.Builder} avoiding the need to create
     * one manually via {@link GetHostRequest#builder()}
     * </p>
     *
     * @param getHostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.GetHostRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetHost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ResourceUnavailableException Resource not found. Verify the ARN for the host resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.GetHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetHost" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHostResponse> getHost(Consumer<GetHostRequest.Builder> getHostRequest) {
        return getHost(GetHostRequest.builder().applyMutation(getHostRequest).build());
    }

    /**
     * <p>
     * Returns details about a repository link. A repository link allows Git sync to monitor and sync changes from files
     * in a specified Git repository.
     * </p>
     *
     * @param getRepositoryLinkRequest
     * @return A Java Future containing the result of the GetRepositoryLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.GetRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositoryLinkResponse> getRepositoryLink(GetRepositoryLinkRequest getRepositoryLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a repository link. A repository link allows Git sync to monitor and sync changes from files
     * in a specified Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositoryLinkRequest.Builder} avoiding the need
     * to create one manually via {@link GetRepositoryLinkRequest#builder()}
     * </p>
     *
     * @param getRepositoryLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.GetRepositoryLinkRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRepositoryLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.GetRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositoryLinkResponse> getRepositoryLink(
            Consumer<GetRepositoryLinkRequest.Builder> getRepositoryLinkRequest) {
        return getRepositoryLink(GetRepositoryLinkRequest.builder().applyMutation(getRepositoryLinkRequest).build());
    }

    /**
     * <p>
     * Returns details about the sync status for a repository. A repository sync uses Git sync to push and pull changes
     * from your remote repository.
     * </p>
     *
     * @param getRepositorySyncStatusRequest
     * @return A Java Future containing the result of the GetRepositorySyncStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.GetRepositorySyncStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetRepositorySyncStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositorySyncStatusResponse> getRepositorySyncStatus(
            GetRepositorySyncStatusRequest getRepositorySyncStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the sync status for a repository. A repository sync uses Git sync to push and pull changes
     * from your remote repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositorySyncStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetRepositorySyncStatusRequest#builder()}
     * </p>
     *
     * @param getRepositorySyncStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.GetRepositorySyncStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetRepositorySyncStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.GetRepositorySyncStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetRepositorySyncStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositorySyncStatusResponse> getRepositorySyncStatus(
            Consumer<GetRepositorySyncStatusRequest.Builder> getRepositorySyncStatusRequest) {
        return getRepositorySyncStatus(GetRepositorySyncStatusRequest.builder().applyMutation(getRepositorySyncStatusRequest)
                .build());
    }

    /**
     * <p>
     * Returns the status of the sync with the Git repository for a specific Amazon Web Services resource.
     * </p>
     *
     * @param getResourceSyncStatusRequest
     * @return A Java Future containing the result of the GetResourceSyncStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.GetResourceSyncStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetResourceSyncStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceSyncStatusResponse> getResourceSyncStatus(
            GetResourceSyncStatusRequest getResourceSyncStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the status of the sync with the Git repository for a specific Amazon Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceSyncStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceSyncStatusRequest#builder()}
     * </p>
     *
     * @param getResourceSyncStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.GetResourceSyncStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetResourceSyncStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.GetResourceSyncStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetResourceSyncStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceSyncStatusResponse> getResourceSyncStatus(
            Consumer<GetResourceSyncStatusRequest.Builder> getResourceSyncStatusRequest) {
        return getResourceSyncStatus(GetResourceSyncStatusRequest.builder().applyMutation(getResourceSyncStatusRequest).build());
    }

    /**
     * <p>
     * Returns a list of the most recent sync blockers.
     * </p>
     *
     * @param getSyncBlockerSummaryRequest
     * @return A Java Future containing the result of the GetSyncBlockerSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.GetSyncBlockerSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetSyncBlockerSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSyncBlockerSummaryResponse> getSyncBlockerSummary(
            GetSyncBlockerSummaryRequest getSyncBlockerSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the most recent sync blockers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSyncBlockerSummaryRequest.Builder} avoiding the
     * need to create one manually via {@link GetSyncBlockerSummaryRequest#builder()}
     * </p>
     *
     * @param getSyncBlockerSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.GetSyncBlockerSummaryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetSyncBlockerSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.GetSyncBlockerSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetSyncBlockerSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSyncBlockerSummaryResponse> getSyncBlockerSummary(
            Consumer<GetSyncBlockerSummaryRequest.Builder> getSyncBlockerSummaryRequest) {
        return getSyncBlockerSummary(GetSyncBlockerSummaryRequest.builder().applyMutation(getSyncBlockerSummaryRequest).build());
    }

    /**
     * <p>
     * Returns details about a sync configuration, including the sync type and resource name. A sync configuration
     * allows the configuration to sync (push and pull) changes from the remote repository for a specified branch in a
     * Git repository.
     * </p>
     *
     * @param getSyncConfigurationRequest
     * @return A Java Future containing the result of the GetSyncConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.GetSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSyncConfigurationResponse> getSyncConfiguration(
            GetSyncConfigurationRequest getSyncConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a sync configuration, including the sync type and resource name. A sync configuration
     * allows the configuration to sync (push and pull) changes from the remote repository for a specified branch in a
     * Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSyncConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetSyncConfigurationRequest#builder()}
     * </p>
     *
     * @param getSyncConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.GetSyncConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetSyncConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.GetSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/GetSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSyncConfigurationResponse> getSyncConfiguration(
            Consumer<GetSyncConfigurationRequest.Builder> getSyncConfigurationRequest) {
        return getSyncConfiguration(GetSyncConfigurationRequest.builder().applyMutation(getSyncConfigurationRequest).build());
    }

    /**
     * <p>
     * Lists the connections associated with your account.
     * </p>
     *
     * @param listConnectionsRequest
     * @return A Java Future containing the result of the ListConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConnectionsResponse> listConnections(ListConnectionsRequest listConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the connections associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListConnectionsRequest#builder()}
     * </p>
     *
     * @param listConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.ListConnectionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConnectionsResponse> listConnections(
            Consumer<ListConnectionsRequest.Builder> listConnectionsRequest) {
        return listConnections(ListConnectionsRequest.builder().applyMutation(listConnectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnections(software.amazon.awssdk.services.codestarconnections.model.ListConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListConnectionsPublisher publisher = client.listConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListConnectionsPublisher publisher = client.listConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codestarconnections.model.ListConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codestarconnections.model.ListConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnections(software.amazon.awssdk.services.codestarconnections.model.ListConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConnectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectionsPublisher listConnectionsPaginator(ListConnectionsRequest listConnectionsRequest) {
        return new ListConnectionsPublisher(this, listConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnections(software.amazon.awssdk.services.codestarconnections.model.ListConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListConnectionsPublisher publisher = client.listConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListConnectionsPublisher publisher = client.listConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codestarconnections.model.ListConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codestarconnections.model.ListConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnections(software.amazon.awssdk.services.codestarconnections.model.ListConnectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListConnectionsRequest#builder()}
     * </p>
     *
     * @param listConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.ListConnectionsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectionsPublisher listConnectionsPaginator(Consumer<ListConnectionsRequest.Builder> listConnectionsRequest) {
        return listConnectionsPaginator(ListConnectionsRequest.builder().applyMutation(listConnectionsRequest).build());
    }

    /**
     * <p>
     * Lists the hosts associated with your account.
     * </p>
     *
     * @param listHostsRequest
     * @return A Java Future containing the result of the ListHosts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListHosts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListHosts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHostsResponse> listHosts(ListHostsRequest listHostsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the hosts associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHostsRequest.Builder} avoiding the need to
     * create one manually via {@link ListHostsRequest#builder()}
     * </p>
     *
     * @param listHostsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.ListHostsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListHosts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListHosts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListHosts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHostsResponse> listHosts(Consumer<ListHostsRequest.Builder> listHostsRequest) {
        return listHosts(ListHostsRequest.builder().applyMutation(listHostsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHosts(software.amazon.awssdk.services.codestarconnections.model.ListHostsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListHostsPublisher publisher = client.listHostsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListHostsPublisher publisher = client.listHostsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHosts(software.amazon.awssdk.services.codestarconnections.model.ListHostsRequest)} operation.</b>
     * </p>
     *
     * @param listHostsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListHosts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListHosts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHostsPublisher listHostsPaginator(ListHostsRequest listHostsRequest) {
        return new ListHostsPublisher(this, listHostsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHosts(software.amazon.awssdk.services.codestarconnections.model.ListHostsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListHostsPublisher publisher = client.listHostsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListHostsPublisher publisher = client.listHostsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHosts(software.amazon.awssdk.services.codestarconnections.model.ListHostsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHostsRequest.Builder} avoiding the need to
     * create one manually via {@link ListHostsRequest#builder()}
     * </p>
     *
     * @param listHostsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.ListHostsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListHosts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListHosts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHostsPublisher listHostsPaginator(Consumer<ListHostsRequest.Builder> listHostsRequest) {
        return listHostsPaginator(ListHostsRequest.builder().applyMutation(listHostsRequest).build());
    }

    /**
     * <p>
     * Lists the repository links created for connections in your account.
     * </p>
     *
     * @param listRepositoryLinksRequest
     * @return A Java Future containing the result of the ListRepositoryLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListRepositoryLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListRepositoryLinks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRepositoryLinksResponse> listRepositoryLinks(
            ListRepositoryLinksRequest listRepositoryLinksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the repository links created for connections in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositoryLinksRequest.Builder} avoiding the
     * need to create one manually via {@link ListRepositoryLinksRequest#builder()}
     * </p>
     *
     * @param listRepositoryLinksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.ListRepositoryLinksRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListRepositoryLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListRepositoryLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListRepositoryLinks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRepositoryLinksResponse> listRepositoryLinks(
            Consumer<ListRepositoryLinksRequest.Builder> listRepositoryLinksRequest) {
        return listRepositoryLinks(ListRepositoryLinksRequest.builder().applyMutation(listRepositoryLinksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRepositoryLinks(software.amazon.awssdk.services.codestarconnections.model.ListRepositoryLinksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListRepositoryLinksPublisher publisher = client.listRepositoryLinksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListRepositoryLinksPublisher publisher = client.listRepositoryLinksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codestarconnections.model.ListRepositoryLinksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codestarconnections.model.ListRepositoryLinksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositoryLinks(software.amazon.awssdk.services.codestarconnections.model.ListRepositoryLinksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRepositoryLinksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListRepositoryLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListRepositoryLinks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRepositoryLinksPublisher listRepositoryLinksPaginator(ListRepositoryLinksRequest listRepositoryLinksRequest) {
        return new ListRepositoryLinksPublisher(this, listRepositoryLinksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRepositoryLinks(software.amazon.awssdk.services.codestarconnections.model.ListRepositoryLinksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListRepositoryLinksPublisher publisher = client.listRepositoryLinksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListRepositoryLinksPublisher publisher = client.listRepositoryLinksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codestarconnections.model.ListRepositoryLinksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codestarconnections.model.ListRepositoryLinksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositoryLinks(software.amazon.awssdk.services.codestarconnections.model.ListRepositoryLinksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositoryLinksRequest.Builder} avoiding the
     * need to create one manually via {@link ListRepositoryLinksRequest#builder()}
     * </p>
     *
     * @param listRepositoryLinksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.ListRepositoryLinksRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListRepositoryLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListRepositoryLinks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRepositoryLinksPublisher listRepositoryLinksPaginator(
            Consumer<ListRepositoryLinksRequest.Builder> listRepositoryLinksRequest) {
        return listRepositoryLinksPaginator(ListRepositoryLinksRequest.builder().applyMutation(listRepositoryLinksRequest)
                .build());
    }

    /**
     * <p>
     * Lists the repository sync definitions for repository links in your account.
     * </p>
     *
     * @param listRepositorySyncDefinitionsRequest
     * @return A Java Future containing the result of the ListRepositorySyncDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListRepositorySyncDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListRepositorySyncDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRepositorySyncDefinitionsResponse> listRepositorySyncDefinitions(
            ListRepositorySyncDefinitionsRequest listRepositorySyncDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the repository sync definitions for repository links in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositorySyncDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListRepositorySyncDefinitionsRequest#builder()}
     * </p>
     *
     * @param listRepositorySyncDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.ListRepositorySyncDefinitionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListRepositorySyncDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListRepositorySyncDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListRepositorySyncDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRepositorySyncDefinitionsResponse> listRepositorySyncDefinitions(
            Consumer<ListRepositorySyncDefinitionsRequest.Builder> listRepositorySyncDefinitionsRequest) {
        return listRepositorySyncDefinitions(ListRepositorySyncDefinitionsRequest.builder()
                .applyMutation(listRepositorySyncDefinitionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of sync configurations for a specified repository.
     * </p>
     *
     * @param listSyncConfigurationsRequest
     * @return A Java Future containing the result of the ListSyncConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListSyncConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListSyncConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSyncConfigurationsResponse> listSyncConfigurations(
            ListSyncConfigurationsRequest listSyncConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of sync configurations for a specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSyncConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSyncConfigurationsRequest#builder()}
     * </p>
     *
     * @param listSyncConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.ListSyncConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListSyncConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListSyncConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListSyncConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSyncConfigurationsResponse> listSyncConfigurations(
            Consumer<ListSyncConfigurationsRequest.Builder> listSyncConfigurationsRequest) {
        return listSyncConfigurations(ListSyncConfigurationsRequest.builder().applyMutation(listSyncConfigurationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSyncConfigurations(software.amazon.awssdk.services.codestarconnections.model.ListSyncConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListSyncConfigurationsPublisher publisher = client.listSyncConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListSyncConfigurationsPublisher publisher = client.listSyncConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codestarconnections.model.ListSyncConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codestarconnections.model.ListSyncConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSyncConfigurations(software.amazon.awssdk.services.codestarconnections.model.ListSyncConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSyncConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListSyncConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListSyncConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSyncConfigurationsPublisher listSyncConfigurationsPaginator(
            ListSyncConfigurationsRequest listSyncConfigurationsRequest) {
        return new ListSyncConfigurationsPublisher(this, listSyncConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSyncConfigurations(software.amazon.awssdk.services.codestarconnections.model.ListSyncConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListSyncConfigurationsPublisher publisher = client.listSyncConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarconnections.paginators.ListSyncConfigurationsPublisher publisher = client.listSyncConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codestarconnections.model.ListSyncConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codestarconnections.model.ListSyncConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSyncConfigurations(software.amazon.awssdk.services.codestarconnections.model.ListSyncConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSyncConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSyncConfigurationsRequest#builder()}
     * </p>
     *
     * @param listSyncConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.ListSyncConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListSyncConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListSyncConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSyncConfigurationsPublisher listSyncConfigurationsPaginator(
            Consumer<ListSyncConfigurationsRequest.Builder> listSyncConfigurationsRequest) {
        return listSyncConfigurationsPaginator(ListSyncConfigurationsRequest.builder()
                .applyMutation(listSyncConfigurationsRequest).build());
    }

    /**
     * <p>
     * Gets the set of key-value pairs (metadata) that are used to manage the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the set of key-value pairs (metadata) that are used to manage the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>LimitExceededException Exceeded the maximum limit for connections.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>LimitExceededException Exceeded the maximum limit for connections.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from an Amazon Web Services resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from an Amazon Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a specified host with the provided configurations.
     * </p>
     *
     * @param updateHostRequest
     * @return A Java Future containing the result of the UpdateHost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Two conflicting operations have been made on the same resource.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ResourceUnavailableException Resource not found. Verify the ARN for the host resource and try again.</li>
     *         <li>UnsupportedOperationException The operation is not supported. Check the connection status and try
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.UpdateHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateHost"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateHostResponse> updateHost(UpdateHostRequest updateHostRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a specified host with the provided configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateHostRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateHostRequest#builder()}
     * </p>
     *
     * @param updateHostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.UpdateHostRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateHost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Two conflicting operations have been made on the same resource.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ResourceUnavailableException Resource not found. Verify the ARN for the host resource and try again.</li>
     *         <li>UnsupportedOperationException The operation is not supported. Check the connection status and try
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.UpdateHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateHost"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateHostResponse> updateHost(Consumer<UpdateHostRequest.Builder> updateHostRequest) {
        return updateHost(UpdateHostRequest.builder().applyMutation(updateHostRequest).build());
    }

    /**
     * <p>
     * Updates the association between your connection and a specified external Git repository. A repository link allows
     * Git sync to monitor and sync changes to files in a specified Git repository.
     * </p>
     *
     * @param updateRepositoryLinkRequest
     * @return A Java Future containing the result of the UpdateRepositoryLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConditionalCheckFailedException The conditional check failed. Try again later.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>UpdateOutOfSyncException The update is out of sync. Try syncing again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.UpdateRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRepositoryLinkResponse> updateRepositoryLink(
            UpdateRepositoryLinkRequest updateRepositoryLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the association between your connection and a specified external Git repository. A repository link allows
     * Git sync to monitor and sync changes to files in a specified Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRepositoryLinkRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRepositoryLinkRequest#builder()}
     * </p>
     *
     * @param updateRepositoryLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.UpdateRepositoryLinkRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateRepositoryLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConditionalCheckFailedException The conditional check failed. Try again later.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>UpdateOutOfSyncException The update is out of sync. Try syncing again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.UpdateRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRepositoryLinkResponse> updateRepositoryLink(
            Consumer<UpdateRepositoryLinkRequest.Builder> updateRepositoryLinkRequest) {
        return updateRepositoryLink(UpdateRepositoryLinkRequest.builder().applyMutation(updateRepositoryLinkRequest).build());
    }

    /**
     * <p>
     * Allows you to update the status of a sync blocker, resolving the blocker and allowing syncing to continue.
     * </p>
     *
     * @param updateSyncBlockerRequest
     * @return A Java Future containing the result of the UpdateSyncBlocker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>RetryLatestCommitFailedException Retrying the latest commit failed. Try again later.</li>
     *         <li>SyncBlockerDoesNotExistException Unable to continue. The sync blocker does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.UpdateSyncBlocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateSyncBlocker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSyncBlockerResponse> updateSyncBlocker(UpdateSyncBlockerRequest updateSyncBlockerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to update the status of a sync blocker, resolving the blocker and allowing syncing to continue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSyncBlockerRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSyncBlockerRequest#builder()}
     * </p>
     *
     * @param updateSyncBlockerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.UpdateSyncBlockerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateSyncBlocker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>RetryLatestCommitFailedException Retrying the latest commit failed. Try again later.</li>
     *         <li>SyncBlockerDoesNotExistException Unable to continue. The sync blocker does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.UpdateSyncBlocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateSyncBlocker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSyncBlockerResponse> updateSyncBlocker(
            Consumer<UpdateSyncBlockerRequest.Builder> updateSyncBlockerRequest) {
        return updateSyncBlocker(UpdateSyncBlockerRequest.builder().applyMutation(updateSyncBlockerRequest).build());
    }

    /**
     * <p>
     * Updates the sync configuration for your connection and a specified external Git repository.
     * </p>
     *
     * @param updateSyncConfigurationRequest
     * @return A Java Future containing the result of the UpdateSyncConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>UpdateOutOfSyncException The update is out of sync. Try syncing again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.UpdateSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSyncConfigurationResponse> updateSyncConfiguration(
            UpdateSyncConfigurationRequest updateSyncConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the sync configuration for your connection and a specified external Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSyncConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateSyncConfigurationRequest#builder()}
     * </p>
     *
     * @param updateSyncConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codestarconnections.model.UpdateSyncConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateSyncConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConcurrentModificationException Exception thrown as a result of concurrent modification to an
     *         application. For example, two individuals attempting to edit the same application at the same time.</li>
     *         <li>InternalServerException Received an internal server exception. Try again later.</li>
     *         <li>InvalidInputException The input is not valid. Verify that the action is typed correctly.</li>
     *         <li>ResourceNotFoundException Resource not found. Verify the connection resource ARN and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>UpdateOutOfSyncException The update is out of sync. Try syncing again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeStarConnectionsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CodeStarConnectionsAsyncClient.UpdateSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/UpdateSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSyncConfigurationResponse> updateSyncConfiguration(
            Consumer<UpdateSyncConfigurationRequest.Builder> updateSyncConfigurationRequest) {
        return updateSyncConfiguration(UpdateSyncConfigurationRequest.builder().applyMutation(updateSyncConfigurationRequest)
                .build());
    }

    @Override
    default CodeStarConnectionsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CodeStarConnectionsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CodeStarConnectionsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CodeStarConnectionsAsyncClient}.
     */
    static CodeStarConnectionsAsyncClientBuilder builder() {
        return new DefaultCodeStarConnectionsAsyncClientBuilder();
    }
}
