/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectionResponse extends CodeStarConnectionsResponse implements
        ToCopyableBuilder<GetConnectionResponse.Builder, GetConnectionResponse> {
    private static final SdkField<Connection> CONNECTION_FIELD = SdkField.<Connection> builder(MarshallingType.SDK_POJO)
            .memberName("Connection").getter(getter(GetConnectionResponse::connection)).setter(setter(Builder::connection))
            .constructor(Connection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Connection", CONNECTION_FIELD);
                }
            });

    private final Connection connection;

    private GetConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connection = builder.connection;
    }

    /**
     * <p>
     * The connection details, such as status, owner, and provider type.
     * </p>
     * 
     * @return The connection details, such as status, owner, and provider type.
     */
    public final Connection connection() {
        return connection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionResponse)) {
            return false;
        }
        GetConnectionResponse other = (GetConnectionResponse) obj;
        return Objects.equals(connection(), other.connection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConnectionResponse").add("Connection", connection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Connection":
            return Optional.ofNullable(clazz.cast(connection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionResponse, T> g) {
        return obj -> g.apply((GetConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarConnectionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConnectionResponse> {
        /**
         * <p>
         * The connection details, such as status, owner, and provider type.
         * </p>
         * 
         * @param connection
         *        The connection details, such as status, owner, and provider type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connection(Connection connection);

        /**
         * <p>
         * The connection details, such as status, owner, and provider type.
         * </p>
         * This is a convenience method that creates an instance of the {@link Connection.Builder} avoiding the need to
         * create one manually via {@link Connection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Connection.Builder#build()} is called immediately and its result
         * is passed to {@link #connection(Connection)}.
         * 
         * @param connection
         *        a consumer that will call methods on {@link Connection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connection(Connection)
         */
        default Builder connection(Consumer<Connection.Builder> connection) {
            return connection(Connection.builder().applyMutation(connection).build());
        }
    }

    static final class BuilderImpl extends CodeStarConnectionsResponse.BuilderImpl implements Builder {
        private Connection connection;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionResponse model) {
            super(model);
            connection(model.connection);
        }

        public final Connection.Builder getConnection() {
            return connection != null ? connection.toBuilder() : null;
        }

        public final void setConnection(Connection.BuilderImpl connection) {
            this.connection = connection != null ? connection.build() : null;
        }

        @Override
        public final Builder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public GetConnectionResponse build() {
            return new GetConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
