/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarconnections.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary for sync blockers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SyncBlockerSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SyncBlockerSummary.Builder, SyncBlockerSummary> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(SyncBlockerSummary::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> PARENT_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentResourceName").getter(getter(SyncBlockerSummary::parentResourceName))
            .setter(setter(Builder::parentResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentResourceName").build())
            .build();

    private static final SdkField<List<SyncBlocker>> LATEST_BLOCKERS_FIELD = SdkField
            .<List<SyncBlocker>> builder(MarshallingType.LIST)
            .memberName("LatestBlockers")
            .getter(getter(SyncBlockerSummary::latestBlockers))
            .setter(setter(Builder::latestBlockers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestBlockers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SyncBlocker> builder(MarshallingType.SDK_POJO)
                                            .constructor(SyncBlocker::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD,
            PARENT_RESOURCE_NAME_FIELD, LATEST_BLOCKERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ResourceName", RESOURCE_NAME_FIELD);
                    put("ParentResourceName", PARENT_RESOURCE_NAME_FIELD);
                    put("LatestBlockers", LATEST_BLOCKERS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String resourceName;

    private final String parentResourceName;

    private final List<SyncBlocker> latestBlockers;

    private SyncBlockerSummary(BuilderImpl builder) {
        this.resourceName = builder.resourceName;
        this.parentResourceName = builder.parentResourceName;
        this.latestBlockers = builder.latestBlockers;
    }

    /**
     * <p>
     * The resource name for sync blocker summary.
     * </p>
     * 
     * @return The resource name for sync blocker summary.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The parent resource name for a sync blocker summary.
     * </p>
     * 
     * @return The parent resource name for a sync blocker summary.
     */
    public final String parentResourceName() {
        return parentResourceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LatestBlockers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLatestBlockers() {
        return latestBlockers != null && !(latestBlockers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The latest events for a sync blocker summary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLatestBlockers} method.
     * </p>
     * 
     * @return The latest events for a sync blocker summary.
     */
    public final List<SyncBlocker> latestBlockers() {
        return latestBlockers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(parentResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLatestBlockers() ? latestBlockers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncBlockerSummary)) {
            return false;
        }
        SyncBlockerSummary other = (SyncBlockerSummary) obj;
        return Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(parentResourceName(), other.parentResourceName())
                && hasLatestBlockers() == other.hasLatestBlockers() && Objects.equals(latestBlockers(), other.latestBlockers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SyncBlockerSummary").add("ResourceName", resourceName())
                .add("ParentResourceName", parentResourceName())
                .add("LatestBlockers", hasLatestBlockers() ? latestBlockers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "ParentResourceName":
            return Optional.ofNullable(clazz.cast(parentResourceName()));
        case "LatestBlockers":
            return Optional.ofNullable(clazz.cast(latestBlockers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SyncBlockerSummary, T> g) {
        return obj -> g.apply((SyncBlockerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SyncBlockerSummary> {
        /**
         * <p>
         * The resource name for sync blocker summary.
         * </p>
         * 
         * @param resourceName
         *        The resource name for sync blocker summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The parent resource name for a sync blocker summary.
         * </p>
         * 
         * @param parentResourceName
         *        The parent resource name for a sync blocker summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentResourceName(String parentResourceName);

        /**
         * <p>
         * The latest events for a sync blocker summary.
         * </p>
         * 
         * @param latestBlockers
         *        The latest events for a sync blocker summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestBlockers(Collection<SyncBlocker> latestBlockers);

        /**
         * <p>
         * The latest events for a sync blocker summary.
         * </p>
         * 
         * @param latestBlockers
         *        The latest events for a sync blocker summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestBlockers(SyncBlocker... latestBlockers);

        /**
         * <p>
         * The latest events for a sync blocker summary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codestarconnections.model.SyncBlocker.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.codestarconnections.model.SyncBlocker#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codestarconnections.model.SyncBlocker.Builder#build()} is called
         * immediately and its result is passed to {@link #latestBlockers(List<SyncBlocker>)}.
         * 
         * @param latestBlockers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codestarconnections.model.SyncBlocker.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestBlockers(java.util.Collection<SyncBlocker>)
         */
        Builder latestBlockers(Consumer<SyncBlocker.Builder>... latestBlockers);
    }

    static final class BuilderImpl implements Builder {
        private String resourceName;

        private String parentResourceName;

        private List<SyncBlocker> latestBlockers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SyncBlockerSummary model) {
            resourceName(model.resourceName);
            parentResourceName(model.parentResourceName);
            latestBlockers(model.latestBlockers);
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getParentResourceName() {
            return parentResourceName;
        }

        public final void setParentResourceName(String parentResourceName) {
            this.parentResourceName = parentResourceName;
        }

        @Override
        public final Builder parentResourceName(String parentResourceName) {
            this.parentResourceName = parentResourceName;
            return this;
        }

        public final List<SyncBlocker.Builder> getLatestBlockers() {
            List<SyncBlocker.Builder> result = LatestSyncBlockerListCopier.copyToBuilder(this.latestBlockers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLatestBlockers(Collection<SyncBlocker.BuilderImpl> latestBlockers) {
            this.latestBlockers = LatestSyncBlockerListCopier.copyFromBuilder(latestBlockers);
        }

        @Override
        public final Builder latestBlockers(Collection<SyncBlocker> latestBlockers) {
            this.latestBlockers = LatestSyncBlockerListCopier.copy(latestBlockers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestBlockers(SyncBlocker... latestBlockers) {
            latestBlockers(Arrays.asList(latestBlockers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestBlockers(Consumer<SyncBlocker.Builder>... latestBlockers) {
            latestBlockers(Stream.of(latestBlockers).map(c -> SyncBlocker.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SyncBlockerSummary build() {
            return new SyncBlockerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
