/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSyncBlockerResponse extends CodeStarConnectionsResponse implements
        ToCopyableBuilder<UpdateSyncBlockerResponse.Builder, UpdateSyncBlockerResponse> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(UpdateSyncBlockerResponse::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> PARENT_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentResourceName").getter(getter(UpdateSyncBlockerResponse::parentResourceName))
            .setter(setter(Builder::parentResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentResourceName").build())
            .build();

    private static final SdkField<SyncBlocker> SYNC_BLOCKER_FIELD = SdkField.<SyncBlocker> builder(MarshallingType.SDK_POJO)
            .memberName("SyncBlocker").getter(getter(UpdateSyncBlockerResponse::syncBlocker))
            .setter(setter(Builder::syncBlocker)).constructor(SyncBlocker::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncBlocker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD,
            PARENT_RESOURCE_NAME_FIELD, SYNC_BLOCKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ResourceName", RESOURCE_NAME_FIELD);
                    put("ParentResourceName", PARENT_RESOURCE_NAME_FIELD);
                    put("SyncBlocker", SYNC_BLOCKER_FIELD);
                }
            });

    private final String resourceName;

    private final String parentResourceName;

    private final SyncBlocker syncBlocker;

    private UpdateSyncBlockerResponse(BuilderImpl builder) {
        super(builder);
        this.resourceName = builder.resourceName;
        this.parentResourceName = builder.parentResourceName;
        this.syncBlocker = builder.syncBlocker;
    }

    /**
     * <p>
     * The resource name for the sync blocker.
     * </p>
     * 
     * @return The resource name for the sync blocker.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The parent resource name for the sync blocker.
     * </p>
     * 
     * @return The parent resource name for the sync blocker.
     */
    public final String parentResourceName() {
        return parentResourceName;
    }

    /**
     * <p>
     * Information about the sync blocker to be updated.
     * </p>
     * 
     * @return Information about the sync blocker to be updated.
     */
    public final SyncBlocker syncBlocker() {
        return syncBlocker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(parentResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(syncBlocker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSyncBlockerResponse)) {
            return false;
        }
        UpdateSyncBlockerResponse other = (UpdateSyncBlockerResponse) obj;
        return Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(parentResourceName(), other.parentResourceName())
                && Objects.equals(syncBlocker(), other.syncBlocker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSyncBlockerResponse").add("ResourceName", resourceName())
                .add("ParentResourceName", parentResourceName()).add("SyncBlocker", syncBlocker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "ParentResourceName":
            return Optional.ofNullable(clazz.cast(parentResourceName()));
        case "SyncBlocker":
            return Optional.ofNullable(clazz.cast(syncBlocker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSyncBlockerResponse, T> g) {
        return obj -> g.apply((UpdateSyncBlockerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarConnectionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSyncBlockerResponse> {
        /**
         * <p>
         * The resource name for the sync blocker.
         * </p>
         * 
         * @param resourceName
         *        The resource name for the sync blocker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The parent resource name for the sync blocker.
         * </p>
         * 
         * @param parentResourceName
         *        The parent resource name for the sync blocker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentResourceName(String parentResourceName);

        /**
         * <p>
         * Information about the sync blocker to be updated.
         * </p>
         * 
         * @param syncBlocker
         *        Information about the sync blocker to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncBlocker(SyncBlocker syncBlocker);

        /**
         * <p>
         * Information about the sync blocker to be updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link SyncBlocker.Builder} avoiding the need to
         * create one manually via {@link SyncBlocker#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SyncBlocker.Builder#build()} is called immediately and its result
         * is passed to {@link #syncBlocker(SyncBlocker)}.
         * 
         * @param syncBlocker
         *        a consumer that will call methods on {@link SyncBlocker.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syncBlocker(SyncBlocker)
         */
        default Builder syncBlocker(Consumer<SyncBlocker.Builder> syncBlocker) {
            return syncBlocker(SyncBlocker.builder().applyMutation(syncBlocker).build());
        }
    }

    static final class BuilderImpl extends CodeStarConnectionsResponse.BuilderImpl implements Builder {
        private String resourceName;

        private String parentResourceName;

        private SyncBlocker syncBlocker;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSyncBlockerResponse model) {
            super(model);
            resourceName(model.resourceName);
            parentResourceName(model.parentResourceName);
            syncBlocker(model.syncBlocker);
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getParentResourceName() {
            return parentResourceName;
        }

        public final void setParentResourceName(String parentResourceName) {
            this.parentResourceName = parentResourceName;
        }

        @Override
        public final Builder parentResourceName(String parentResourceName) {
            this.parentResourceName = parentResourceName;
            return this;
        }

        public final SyncBlocker.Builder getSyncBlocker() {
            return syncBlocker != null ? syncBlocker.toBuilder() : null;
        }

        public final void setSyncBlocker(SyncBlocker.BuilderImpl syncBlocker) {
            this.syncBlocker = syncBlocker != null ? syncBlocker.build() : null;
        }

        @Override
        public final Builder syncBlocker(SyncBlocker syncBlocker) {
            this.syncBlocker = syncBlocker;
            return this;
        }

        @Override
        public UpdateSyncBlockerResponse build() {
            return new UpdateSyncBlockerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
