/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSyncConfigurationRequest extends CodeStarConnectionsRequest implements
        ToCopyableBuilder<UpdateSyncConfigurationRequest.Builder, UpdateSyncConfigurationRequest> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Branch")
            .getter(getter(UpdateSyncConfigurationRequest::branch)).setter(setter(Builder::branch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branch").build()).build();

    private static final SdkField<String> CONFIG_FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigFile").getter(getter(UpdateSyncConfigurationRequest::configFile))
            .setter(setter(Builder::configFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigFile").build()).build();

    private static final SdkField<String> REPOSITORY_LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryLinkId").getter(getter(UpdateSyncConfigurationRequest::repositoryLinkId))
            .setter(setter(Builder::repositoryLinkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryLinkId").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(UpdateSyncConfigurationRequest::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateSyncConfigurationRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> SYNC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyncType").getter(getter(UpdateSyncConfigurationRequest::syncTypeAsString))
            .setter(setter(Builder::syncType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncType").build()).build();

    private static final SdkField<String> PUBLISH_DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublishDeploymentStatus")
            .getter(getter(UpdateSyncConfigurationRequest::publishDeploymentStatusAsString))
            .setter(setter(Builder::publishDeploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishDeploymentStatus").build())
            .build();

    private static final SdkField<String> TRIGGER_RESOURCE_UPDATE_ON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TriggerResourceUpdateOn")
            .getter(getter(UpdateSyncConfigurationRequest::triggerResourceUpdateOnAsString))
            .setter(setter(Builder::triggerResourceUpdateOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerResourceUpdateOn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD,
            CONFIG_FILE_FIELD, REPOSITORY_LINK_ID_FIELD, RESOURCE_NAME_FIELD, ROLE_ARN_FIELD, SYNC_TYPE_FIELD,
            PUBLISH_DEPLOYMENT_STATUS_FIELD, TRIGGER_RESOURCE_UPDATE_ON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String branch;

    private final String configFile;

    private final String repositoryLinkId;

    private final String resourceName;

    private final String roleArn;

    private final String syncType;

    private final String publishDeploymentStatus;

    private final String triggerResourceUpdateOn;

    private UpdateSyncConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.branch = builder.branch;
        this.configFile = builder.configFile;
        this.repositoryLinkId = builder.repositoryLinkId;
        this.resourceName = builder.resourceName;
        this.roleArn = builder.roleArn;
        this.syncType = builder.syncType;
        this.publishDeploymentStatus = builder.publishDeploymentStatus;
        this.triggerResourceUpdateOn = builder.triggerResourceUpdateOn;
    }

    /**
     * <p>
     * The branch for the sync configuration to be updated.
     * </p>
     * 
     * @return The branch for the sync configuration to be updated.
     */
    public final String branch() {
        return branch;
    }

    /**
     * <p>
     * The configuration file for the sync configuration to be updated.
     * </p>
     * 
     * @return The configuration file for the sync configuration to be updated.
     */
    public final String configFile() {
        return configFile;
    }

    /**
     * <p>
     * The ID of the repository link for the sync configuration to be updated.
     * </p>
     * 
     * @return The ID of the repository link for the sync configuration to be updated.
     */
    public final String repositoryLinkId() {
        return repositoryLinkId;
    }

    /**
     * <p>
     * The name of the Amazon Web Services resource for the sync configuration to be updated.
     * </p>
     * 
     * @return The name of the Amazon Web Services resource for the sync configuration to be updated.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The ARN of the IAM role for the sync configuration to be updated.
     * </p>
     * 
     * @return The ARN of the IAM role for the sync configuration to be updated.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The sync type for the sync configuration to be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncType} will
     * return {@link SyncConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #syncTypeAsString}.
     * </p>
     * 
     * @return The sync type for the sync configuration to be updated.
     * @see SyncConfigurationType
     */
    public final SyncConfigurationType syncType() {
        return SyncConfigurationType.fromValue(syncType);
    }

    /**
     * <p>
     * The sync type for the sync configuration to be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncType} will
     * return {@link SyncConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #syncTypeAsString}.
     * </p>
     * 
     * @return The sync type for the sync configuration to be updated.
     * @see SyncConfigurationType
     */
    public final String syncTypeAsString() {
        return syncType;
    }

    /**
     * <p>
     * Whether to enable or disable publishing of deployment status to source providers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #publishDeploymentStatus} will return {@link PublishDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #publishDeploymentStatusAsString}.
     * </p>
     * 
     * @return Whether to enable or disable publishing of deployment status to source providers.
     * @see PublishDeploymentStatus
     */
    public final PublishDeploymentStatus publishDeploymentStatus() {
        return PublishDeploymentStatus.fromValue(publishDeploymentStatus);
    }

    /**
     * <p>
     * Whether to enable or disable publishing of deployment status to source providers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #publishDeploymentStatus} will return {@link PublishDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #publishDeploymentStatusAsString}.
     * </p>
     * 
     * @return Whether to enable or disable publishing of deployment status to source providers.
     * @see PublishDeploymentStatus
     */
    public final String publishDeploymentStatusAsString() {
        return publishDeploymentStatus;
    }

    /**
     * <p>
     * When to trigger Git sync to begin the stack update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #triggerResourceUpdateOn} will return {@link TriggerResourceUpdateOn#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #triggerResourceUpdateOnAsString}.
     * </p>
     * 
     * @return When to trigger Git sync to begin the stack update.
     * @see TriggerResourceUpdateOn
     */
    public final TriggerResourceUpdateOn triggerResourceUpdateOn() {
        return TriggerResourceUpdateOn.fromValue(triggerResourceUpdateOn);
    }

    /**
     * <p>
     * When to trigger Git sync to begin the stack update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #triggerResourceUpdateOn} will return {@link TriggerResourceUpdateOn#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #triggerResourceUpdateOnAsString}.
     * </p>
     * 
     * @return When to trigger Git sync to begin the stack update.
     * @see TriggerResourceUpdateOn
     */
    public final String triggerResourceUpdateOnAsString() {
        return triggerResourceUpdateOn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(branch());
        hashCode = 31 * hashCode + Objects.hashCode(configFile());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(syncTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publishDeploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(triggerResourceUpdateOnAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSyncConfigurationRequest)) {
            return false;
        }
        UpdateSyncConfigurationRequest other = (UpdateSyncConfigurationRequest) obj;
        return Objects.equals(branch(), other.branch()) && Objects.equals(configFile(), other.configFile())
                && Objects.equals(repositoryLinkId(), other.repositoryLinkId())
                && Objects.equals(resourceName(), other.resourceName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(syncTypeAsString(), other.syncTypeAsString())
                && Objects.equals(publishDeploymentStatusAsString(), other.publishDeploymentStatusAsString())
                && Objects.equals(triggerResourceUpdateOnAsString(), other.triggerResourceUpdateOnAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSyncConfigurationRequest").add("Branch", branch()).add("ConfigFile", configFile())
                .add("RepositoryLinkId", repositoryLinkId()).add("ResourceName", resourceName()).add("RoleArn", roleArn())
                .add("SyncType", syncTypeAsString()).add("PublishDeploymentStatus", publishDeploymentStatusAsString())
                .add("TriggerResourceUpdateOn", triggerResourceUpdateOnAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Branch":
            return Optional.ofNullable(clazz.cast(branch()));
        case "ConfigFile":
            return Optional.ofNullable(clazz.cast(configFile()));
        case "RepositoryLinkId":
            return Optional.ofNullable(clazz.cast(repositoryLinkId()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SyncType":
            return Optional.ofNullable(clazz.cast(syncTypeAsString()));
        case "PublishDeploymentStatus":
            return Optional.ofNullable(clazz.cast(publishDeploymentStatusAsString()));
        case "TriggerResourceUpdateOn":
            return Optional.ofNullable(clazz.cast(triggerResourceUpdateOnAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Branch", BRANCH_FIELD);
        map.put("ConfigFile", CONFIG_FILE_FIELD);
        map.put("RepositoryLinkId", REPOSITORY_LINK_ID_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("SyncType", SYNC_TYPE_FIELD);
        map.put("PublishDeploymentStatus", PUBLISH_DEPLOYMENT_STATUS_FIELD);
        map.put("TriggerResourceUpdateOn", TRIGGER_RESOURCE_UPDATE_ON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSyncConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateSyncConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarConnectionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSyncConfigurationRequest> {
        /**
         * <p>
         * The branch for the sync configuration to be updated.
         * </p>
         * 
         * @param branch
         *        The branch for the sync configuration to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branch(String branch);

        /**
         * <p>
         * The configuration file for the sync configuration to be updated.
         * </p>
         * 
         * @param configFile
         *        The configuration file for the sync configuration to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configFile(String configFile);

        /**
         * <p>
         * The ID of the repository link for the sync configuration to be updated.
         * </p>
         * 
         * @param repositoryLinkId
         *        The ID of the repository link for the sync configuration to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryLinkId(String repositoryLinkId);

        /**
         * <p>
         * The name of the Amazon Web Services resource for the sync configuration to be updated.
         * </p>
         * 
         * @param resourceName
         *        The name of the Amazon Web Services resource for the sync configuration to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The ARN of the IAM role for the sync configuration to be updated.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role for the sync configuration to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The sync type for the sync configuration to be updated.
         * </p>
         * 
         * @param syncType
         *        The sync type for the sync configuration to be updated.
         * @see SyncConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncConfigurationType
         */
        Builder syncType(String syncType);

        /**
         * <p>
         * The sync type for the sync configuration to be updated.
         * </p>
         * 
         * @param syncType
         *        The sync type for the sync configuration to be updated.
         * @see SyncConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncConfigurationType
         */
        Builder syncType(SyncConfigurationType syncType);

        /**
         * <p>
         * Whether to enable or disable publishing of deployment status to source providers.
         * </p>
         * 
         * @param publishDeploymentStatus
         *        Whether to enable or disable publishing of deployment status to source providers.
         * @see PublishDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublishDeploymentStatus
         */
        Builder publishDeploymentStatus(String publishDeploymentStatus);

        /**
         * <p>
         * Whether to enable or disable publishing of deployment status to source providers.
         * </p>
         * 
         * @param publishDeploymentStatus
         *        Whether to enable or disable publishing of deployment status to source providers.
         * @see PublishDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublishDeploymentStatus
         */
        Builder publishDeploymentStatus(PublishDeploymentStatus publishDeploymentStatus);

        /**
         * <p>
         * When to trigger Git sync to begin the stack update.
         * </p>
         * 
         * @param triggerResourceUpdateOn
         *        When to trigger Git sync to begin the stack update.
         * @see TriggerResourceUpdateOn
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerResourceUpdateOn
         */
        Builder triggerResourceUpdateOn(String triggerResourceUpdateOn);

        /**
         * <p>
         * When to trigger Git sync to begin the stack update.
         * </p>
         * 
         * @param triggerResourceUpdateOn
         *        When to trigger Git sync to begin the stack update.
         * @see TriggerResourceUpdateOn
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerResourceUpdateOn
         */
        Builder triggerResourceUpdateOn(TriggerResourceUpdateOn triggerResourceUpdateOn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeStarConnectionsRequest.BuilderImpl implements Builder {
        private String branch;

        private String configFile;

        private String repositoryLinkId;

        private String resourceName;

        private String roleArn;

        private String syncType;

        private String publishDeploymentStatus;

        private String triggerResourceUpdateOn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSyncConfigurationRequest model) {
            super(model);
            branch(model.branch);
            configFile(model.configFile);
            repositoryLinkId(model.repositoryLinkId);
            resourceName(model.resourceName);
            roleArn(model.roleArn);
            syncType(model.syncType);
            publishDeploymentStatus(model.publishDeploymentStatus);
            triggerResourceUpdateOn(model.triggerResourceUpdateOn);
        }

        public final String getBranch() {
            return branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getConfigFile() {
            return configFile;
        }

        public final void setConfigFile(String configFile) {
            this.configFile = configFile;
        }

        @Override
        public final Builder configFile(String configFile) {
            this.configFile = configFile;
            return this;
        }

        public final String getRepositoryLinkId() {
            return repositoryLinkId;
        }

        public final void setRepositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
        }

        @Override
        public final Builder repositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSyncType() {
            return syncType;
        }

        public final void setSyncType(String syncType) {
            this.syncType = syncType;
        }

        @Override
        public final Builder syncType(String syncType) {
            this.syncType = syncType;
            return this;
        }

        @Override
        public final Builder syncType(SyncConfigurationType syncType) {
            this.syncType(syncType == null ? null : syncType.toString());
            return this;
        }

        public final String getPublishDeploymentStatus() {
            return publishDeploymentStatus;
        }

        public final void setPublishDeploymentStatus(String publishDeploymentStatus) {
            this.publishDeploymentStatus = publishDeploymentStatus;
        }

        @Override
        public final Builder publishDeploymentStatus(String publishDeploymentStatus) {
            this.publishDeploymentStatus = publishDeploymentStatus;
            return this;
        }

        @Override
        public final Builder publishDeploymentStatus(PublishDeploymentStatus publishDeploymentStatus) {
            this.publishDeploymentStatus(publishDeploymentStatus == null ? null : publishDeploymentStatus.toString());
            return this;
        }

        public final String getTriggerResourceUpdateOn() {
            return triggerResourceUpdateOn;
        }

        public final void setTriggerResourceUpdateOn(String triggerResourceUpdateOn) {
            this.triggerResourceUpdateOn = triggerResourceUpdateOn;
        }

        @Override
        public final Builder triggerResourceUpdateOn(String triggerResourceUpdateOn) {
            this.triggerResourceUpdateOn = triggerResourceUpdateOn;
            return this;
        }

        @Override
        public final Builder triggerResourceUpdateOn(TriggerResourceUpdateOn triggerResourceUpdateOn) {
            this.triggerResourceUpdateOn(triggerResourceUpdateOn == null ? null : triggerResourceUpdateOn.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSyncConfigurationRequest build() {
            return new UpdateSyncConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
