/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarconnections.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource that is used to connect third-party source providers with services like CodePipeline.
 * </p>
 * <p>
 * Note: A connection created through CloudFormation, the CLI, or the SDK is in `PENDING` status by default. You can
 * make its status `AVAILABLE` by updating the connection in the console.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Connection implements SdkPojo, Serializable, ToCopyableBuilder<Connection.Builder, Connection> {
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionName").getter(getter(Connection::connectionName)).setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionArn").getter(getter(Connection::connectionArn)).setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderType").getter(getter(Connection::providerTypeAsString)).setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(Connection::ownerAccountId)).setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final SdkField<String> CONNECTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionStatus").getter(getter(Connection::connectionStatusAsString))
            .setter(setter(Builder::connectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()).build();

    private static final SdkField<String> HOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostArn").getter(getter(Connection::hostArn)).setter(setter(Builder::hostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NAME_FIELD,
            CONNECTION_ARN_FIELD, PROVIDER_TYPE_FIELD, OWNER_ACCOUNT_ID_FIELD, CONNECTION_STATUS_FIELD, HOST_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectionName;

    private final String connectionArn;

    private final String providerType;

    private final String ownerAccountId;

    private final String connectionStatus;

    private final String hostArn;

    private Connection(BuilderImpl builder) {
        this.connectionName = builder.connectionName;
        this.connectionArn = builder.connectionArn;
        this.providerType = builder.providerType;
        this.ownerAccountId = builder.ownerAccountId;
        this.connectionStatus = builder.connectionStatus;
        this.hostArn = builder.hostArn;
    }

    /**
     * <p>
     * The name of the connection. Connection names must be unique in an Amazon Web Services account.
     * </p>
     * 
     * @return The name of the connection. Connection names must be unique in an Amazon Web Services account.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connection. The ARN is used as the connection reference when the connection
     * is shared between Amazon Web Services.
     * </p>
     * <note>
     * <p>
     * The ARN is never reused if the connection is deleted.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the connection. The ARN is used as the connection reference when the
     *         connection is shared between Amazon Web Services.</p> <note>
     *         <p>
     *         The ARN is never reused if the connection is deleted.
     *         </p>
     */
    public final String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The name of the external provider where your third-party code repository is configured.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The name of the external provider where your third-party code repository is configured.
     * @see ProviderType
     */
    public final ProviderType providerType() {
        return ProviderType.fromValue(providerType);
    }

    /**
     * <p>
     * The name of the external provider where your third-party code repository is configured.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The name of the external provider where your third-party code repository is configured.
     * @see ProviderType
     */
    public final String providerTypeAsString() {
        return providerType;
    }

    /**
     * <p>
     * The identifier of the external provider where your third-party code repository is configured. For Bitbucket, this
     * is the account ID of the owner of the Bitbucket repository.
     * </p>
     * 
     * @return The identifier of the external provider where your third-party code repository is configured. For
     *         Bitbucket, this is the account ID of the owner of the Bitbucket repository.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * The current status of the connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionStatus}
     * will return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStatusAsString}.
     * </p>
     * 
     * @return The current status of the connection.
     * @see ConnectionStatus
     */
    public final ConnectionStatus connectionStatus() {
        return ConnectionStatus.fromValue(connectionStatus);
    }

    /**
     * <p>
     * The current status of the connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionStatus}
     * will return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStatusAsString}.
     * </p>
     * 
     * @return The current status of the connection.
     * @see ConnectionStatus
     */
    public final String connectionStatusAsString() {
        return connectionStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the host associated with the connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the host associated with the connection.
     */
    public final String hostArn() {
        return hostArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connection)) {
            return false;
        }
        Connection other = (Connection) obj;
        return Objects.equals(connectionName(), other.connectionName()) && Objects.equals(connectionArn(), other.connectionArn())
                && Objects.equals(providerTypeAsString(), other.providerTypeAsString())
                && Objects.equals(ownerAccountId(), other.ownerAccountId())
                && Objects.equals(connectionStatusAsString(), other.connectionStatusAsString())
                && Objects.equals(hostArn(), other.hostArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Connection").add("ConnectionName", connectionName()).add("ConnectionArn", connectionArn())
                .add("ProviderType", providerTypeAsString()).add("OwnerAccountId", ownerAccountId())
                .add("ConnectionStatus", connectionStatusAsString()).add("HostArn", hostArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "ConnectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "ProviderType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "ConnectionStatus":
            return Optional.ofNullable(clazz.cast(connectionStatusAsString()));
        case "HostArn":
            return Optional.ofNullable(clazz.cast(hostArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionName", CONNECTION_NAME_FIELD);
        map.put("ConnectionArn", CONNECTION_ARN_FIELD);
        map.put("ProviderType", PROVIDER_TYPE_FIELD);
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("ConnectionStatus", CONNECTION_STATUS_FIELD);
        map.put("HostArn", HOST_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Connection, T> g) {
        return obj -> g.apply((Connection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Connection> {
        /**
         * <p>
         * The name of the connection. Connection names must be unique in an Amazon Web Services account.
         * </p>
         * 
         * @param connectionName
         *        The name of the connection. Connection names must be unique in an Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connection. The ARN is used as the connection reference when the
         * connection is shared between Amazon Web Services.
         * </p>
         * <note>
         * <p>
         * The ARN is never reused if the connection is deleted.
         * </p>
         * </note>
         * 
         * @param connectionArn
         *        The Amazon Resource Name (ARN) of the connection. The ARN is used as the connection reference when the
         *        connection is shared between Amazon Web Services.</p> <note>
         *        <p>
         *        The ARN is never reused if the connection is deleted.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The name of the external provider where your third-party code repository is configured.
         * </p>
         * 
         * @param providerType
         *        The name of the external provider where your third-party code repository is configured.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The name of the external provider where your third-party code repository is configured.
         * </p>
         * 
         * @param providerType
         *        The name of the external provider where your third-party code repository is configured.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(ProviderType providerType);

        /**
         * <p>
         * The identifier of the external provider where your third-party code repository is configured. For Bitbucket,
         * this is the account ID of the owner of the Bitbucket repository.
         * </p>
         * 
         * @param ownerAccountId
         *        The identifier of the external provider where your third-party code repository is configured. For
         *        Bitbucket, this is the account ID of the owner of the Bitbucket repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * The current status of the connection.
         * </p>
         * 
         * @param connectionStatus
         *        The current status of the connection.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder connectionStatus(String connectionStatus);

        /**
         * <p>
         * The current status of the connection.
         * </p>
         * 
         * @param connectionStatus
         *        The current status of the connection.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder connectionStatus(ConnectionStatus connectionStatus);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the host associated with the connection.
         * </p>
         * 
         * @param hostArn
         *        The Amazon Resource Name (ARN) of the host associated with the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostArn(String hostArn);
    }

    static final class BuilderImpl implements Builder {
        private String connectionName;

        private String connectionArn;

        private String providerType;

        private String ownerAccountId;

        private String connectionStatus;

        private String hostArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Connection model) {
            connectionName(model.connectionName);
            connectionArn(model.connectionArn);
            providerType(model.providerType);
            ownerAccountId(model.ownerAccountId);
            connectionStatus(model.connectionStatus);
            hostArn(model.hostArn);
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getProviderType() {
            return providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getConnectionStatus() {
            return connectionStatus;
        }

        public final void setConnectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
        }

        @Override
        public final Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        @Override
        public final Builder connectionStatus(ConnectionStatus connectionStatus) {
            this.connectionStatus(connectionStatus == null ? null : connectionStatus.toString());
            return this;
        }

        public final String getHostArn() {
            return hostArn;
        }

        public final void setHostArn(String hostArn) {
            this.hostArn = hostArn;
        }

        @Override
        public final Builder hostArn(String hostArn) {
            this.hostArn = hostArn;
            return this;
        }

        @Override
        public Connection build() {
            return new Connection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
