/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarnotifications.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNotificationRuleResponse extends CodestarNotificationsResponse implements
        ToCopyableBuilder<DescribeNotificationRuleResponse.Builder, DescribeNotificationRuleResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotificationRuleResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotificationRuleResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<EventTypeSummary>> EVENT_TYPES_FIELD = SdkField
            .<List<EventTypeSummary>> builder(MarshallingType.LIST)
            .getter(getter(DescribeNotificationRuleResponse::eventTypes))
            .setter(setter(Builder::eventTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventTypeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventTypeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotificationRuleResponse::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<List<TargetSummary>> TARGETS_FIELD = SdkField
            .<List<TargetSummary>> builder(MarshallingType.LIST)
            .getter(getter(DescribeNotificationRuleResponse::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DETAIL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotificationRuleResponse::detailTypeAsString)).setter(setter(Builder::detailType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailType").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotificationRuleResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotificationRuleResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeNotificationRuleResponse::createdTimestamp)).setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeNotificationRuleResponse::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimestamp").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DescribeNotificationRuleResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            EVENT_TYPES_FIELD, RESOURCE_FIELD, TARGETS_FIELD, DETAIL_TYPE_FIELD, CREATED_BY_FIELD, STATUS_FIELD,
            CREATED_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, TAGS_FIELD));

    private final String arn;

    private final String name;

    private final List<EventTypeSummary> eventTypes;

    private final String resource;

    private final List<TargetSummary> targets;

    private final String detailType;

    private final String createdBy;

    private final String status;

    private final Instant createdTimestamp;

    private final Instant lastModifiedTimestamp;

    private final Map<String, String> tags;

    private DescribeNotificationRuleResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.eventTypes = builder.eventTypes;
        this.resource = builder.resource;
        this.targets = builder.targets;
        this.detailType = builder.detailType;
        this.createdBy = builder.createdBy;
        this.status = builder.status;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the notification rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the notification rule.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the notification rule.
     * </p>
     * 
     * @return The name of the notification rule.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A list of the event types associated with the notification rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the event types associated with the notification rule.
     */
    public List<EventTypeSummary> eventTypes() {
        return eventTypes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource associated with the notification rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource associated with the notification rule.
     */
    public String resource() {
        return resource;
    }

    /**
     * <p>
     * A list of the SNS topics associated with the notification rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the SNS topics associated with the notification rule.
     */
    public List<TargetSummary> targets() {
        return targets;
    }

    /**
     * <p>
     * The level of detail included in the notifications for this resource. BASIC will include only the contents of the
     * event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS
     * CodeStar Notifications and/or the service for the resource for which the notification is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailType} will
     * return {@link DetailType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #detailTypeAsString}.
     * </p>
     * 
     * @return The level of detail included in the notifications for this resource. BASIC will include only the contents
     *         of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information
     *         provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is
     *         created.
     * @see DetailType
     */
    public DetailType detailType() {
        return DetailType.fromValue(detailType);
    }

    /**
     * <p>
     * The level of detail included in the notifications for this resource. BASIC will include only the contents of the
     * event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS
     * CodeStar Notifications and/or the service for the resource for which the notification is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailType} will
     * return {@link DetailType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #detailTypeAsString}.
     * </p>
     * 
     * @return The level of detail included in the notifications for this resource. BASIC will include only the contents
     *         of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information
     *         provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is
     *         created.
     * @see DetailType
     */
    public String detailTypeAsString() {
        return detailType;
    }

    /**
     * <p>
     * The name or email alias of the person who created the notification rule.
     * </p>
     * 
     * @return The name or email alias of the person who created the notification rule.
     */
    public String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
     * notifications).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotificationRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
     *         notifications).
     * @see NotificationRuleStatus
     */
    public NotificationRuleStatus status() {
        return NotificationRuleStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
     * notifications).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotificationRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
     *         notifications).
     * @see NotificationRuleStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time the notification rule was created, in timestamp format.
     * </p>
     * 
     * @return The date and time the notification rule was created, in timestamp format.
     */
    public Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The date and time the notification rule was most recently updated, in timestamp format.
     * </p>
     * 
     * @return The date and time the notification rule was most recently updated, in timestamp format.
     */
    public Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    /**
     * <p>
     * The tags associated with the notification rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags associated with the notification rule.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypes());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(detailTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationRuleResponse)) {
            return false;
        }
        DescribeNotificationRuleResponse other = (DescribeNotificationRuleResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(eventTypes(), other.eventTypes()) && Objects.equals(resource(), other.resource())
                && Objects.equals(targets(), other.targets()) && Objects.equals(detailTypeAsString(), other.detailTypeAsString())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeNotificationRuleResponse").add("Arn", arn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("EventTypes", eventTypes())
                .add("Resource", resource()).add("Targets", targets()).add("DetailType", detailTypeAsString())
                .add("CreatedBy", createdBy()).add("Status", statusAsString()).add("CreatedTimestamp", createdTimestamp())
                .add("LastModifiedTimestamp", lastModifiedTimestamp()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EventTypes":
            return Optional.ofNullable(clazz.cast(eventTypes()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "DetailType":
            return Optional.ofNullable(clazz.cast(detailTypeAsString()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "LastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNotificationRuleResponse, T> g) {
        return obj -> g.apply((DescribeNotificationRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodestarNotificationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNotificationRuleResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the notification rule.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the notification rule.
         * </p>
         * 
         * @param name
         *        The name of the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of the event types associated with the notification rule.
         * </p>
         * 
         * @param eventTypes
         *        A list of the event types associated with the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypes(Collection<EventTypeSummary> eventTypes);

        /**
         * <p>
         * A list of the event types associated with the notification rule.
         * </p>
         * 
         * @param eventTypes
         *        A list of the event types associated with the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypes(EventTypeSummary... eventTypes);

        /**
         * <p>
         * A list of the event types associated with the notification rule.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventTypeSummary>.Builder} avoiding the
         * need to create one manually via {@link List<EventTypeSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventTypeSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #eventTypes(List<EventTypeSummary>)}.
         * 
         * @param eventTypes
         *        a consumer that will call methods on {@link List<EventTypeSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTypes(List<EventTypeSummary>)
         */
        Builder eventTypes(Consumer<EventTypeSummary.Builder>... eventTypes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource associated with the notification rule.
         * </p>
         * 
         * @param resource
         *        The Amazon Resource Name (ARN) of the resource associated with the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * A list of the SNS topics associated with the notification rule.
         * </p>
         * 
         * @param targets
         *        A list of the SNS topics associated with the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<TargetSummary> targets);

        /**
         * <p>
         * A list of the SNS topics associated with the notification rule.
         * </p>
         * 
         * @param targets
         *        A list of the SNS topics associated with the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(TargetSummary... targets);

        /**
         * <p>
         * A list of the SNS topics associated with the notification rule.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TargetSummary>.Builder} avoiding the need
         * to create one manually via {@link List<TargetSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #targets(List<TargetSummary>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link List<TargetSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(List<TargetSummary>)
         */
        Builder targets(Consumer<TargetSummary.Builder>... targets);

        /**
         * <p>
         * The level of detail included in the notifications for this resource. BASIC will include only the contents of
         * the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by
         * AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
         * </p>
         * 
         * @param detailType
         *        The level of detail included in the notifications for this resource. BASIC will include only the
         *        contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental
         *        information provided by AWS CodeStar Notifications and/or the service for the resource for which the
         *        notification is created.
         * @see DetailType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailType
         */
        Builder detailType(String detailType);

        /**
         * <p>
         * The level of detail included in the notifications for this resource. BASIC will include only the contents of
         * the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by
         * AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
         * </p>
         * 
         * @param detailType
         *        The level of detail included in the notifications for this resource. BASIC will include only the
         *        contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental
         *        information provided by AWS CodeStar Notifications and/or the service for the resource for which the
         *        notification is created.
         * @see DetailType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailType
         */
        Builder detailType(DetailType detailType);

        /**
         * <p>
         * The name or email alias of the person who created the notification rule.
         * </p>
         * 
         * @param createdBy
         *        The name or email alias of the person who created the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
         * notifications).
         * </p>
         * 
         * @param status
         *        The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
         *        notifications).
         * @see NotificationRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationRuleStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
         * notifications).
         * </p>
         * 
         * @param status
         *        The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
         *        notifications).
         * @see NotificationRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationRuleStatus
         */
        Builder status(NotificationRuleStatus status);

        /**
         * <p>
         * The date and time the notification rule was created, in timestamp format.
         * </p>
         * 
         * @param createdTimestamp
         *        The date and time the notification rule was created, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The date and time the notification rule was most recently updated, in timestamp format.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The date and time the notification rule was most recently updated, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);

        /**
         * <p>
         * The tags associated with the notification rule.
         * </p>
         * 
         * @param tags
         *        The tags associated with the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends CodestarNotificationsResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private List<EventTypeSummary> eventTypes = DefaultSdkAutoConstructList.getInstance();

        private String resource;

        private List<TargetSummary> targets = DefaultSdkAutoConstructList.getInstance();

        private String detailType;

        private String createdBy;

        private String status;

        private Instant createdTimestamp;

        private Instant lastModifiedTimestamp;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationRuleResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            eventTypes(model.eventTypes);
            resource(model.resource);
            targets(model.targets);
            detailType(model.detailType);
            createdBy(model.createdBy);
            status(model.status);
            createdTimestamp(model.createdTimestamp);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<EventTypeSummary.Builder> getEventTypes() {
            return eventTypes != null ? eventTypes.stream().map(EventTypeSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventTypes(Collection<EventTypeSummary> eventTypes) {
            this.eventTypes = EventTypeBatchCopier.copy(eventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypes(EventTypeSummary... eventTypes) {
            eventTypes(Arrays.asList(eventTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypes(Consumer<EventTypeSummary.Builder>... eventTypes) {
            eventTypes(Stream.of(eventTypes).map(c -> EventTypeSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEventTypes(Collection<EventTypeSummary.BuilderImpl> eventTypes) {
            this.eventTypes = EventTypeBatchCopier.copyFromBuilder(eventTypes);
        }

        public final String getResource() {
            return resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final Collection<TargetSummary.Builder> getTargets() {
            return targets != null ? targets.stream().map(TargetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<TargetSummary> targets) {
            this.targets = TargetsBatchCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(TargetSummary... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<TargetSummary.Builder>... targets) {
            targets(Stream.of(targets).map(c -> TargetSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<TargetSummary.BuilderImpl> targets) {
            this.targets = TargetsBatchCopier.copyFromBuilder(targets);
        }

        public final String getDetailTypeAsString() {
            return detailType;
        }

        @Override
        public final Builder detailType(String detailType) {
            this.detailType = detailType;
            return this;
        }

        @Override
        public final Builder detailType(DetailType detailType) {
            this.detailType(detailType == null ? null : detailType.toString());
            return this;
        }

        public final void setDetailType(String detailType) {
            this.detailType = detailType;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotificationRuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public DescribeNotificationRuleResponse build() {
            return new DescribeNotificationRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
