/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarnotifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNotificationRulesResponse extends CodestarNotificationsResponse implements
        ToCopyableBuilder<ListNotificationRulesResponse.Builder, ListNotificationRulesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListNotificationRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<NotificationRuleSummary>> NOTIFICATION_RULES_FIELD = SdkField
            .<List<NotificationRuleSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListNotificationRulesResponse::notificationRules))
            .setter(setter(Builder::notificationRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotificationRuleSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotificationRuleSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            NOTIFICATION_RULES_FIELD));

    private final String nextToken;

    private final List<NotificationRuleSummary> notificationRules;

    private ListNotificationRulesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.notificationRules = builder.notificationRules;
    }

    /**
     * <p>
     * An enumeration token that can be used in a request to return the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that can be used in a request to return the next batch of the results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the NotificationRules property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNotificationRules() {
        return notificationRules != null && !(notificationRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of notification rules for the AWS account, by Amazon Resource Name (ARN) and ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNotificationRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of notification rules for the AWS account, by Amazon Resource Name (ARN) and ID.
     */
    public List<NotificationRuleSummary> notificationRules() {
        return notificationRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(notificationRules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationRulesResponse)) {
            return false;
        }
        ListNotificationRulesResponse other = (ListNotificationRulesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(notificationRules(), other.notificationRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListNotificationRulesResponse").add("NextToken", nextToken())
                .add("NotificationRules", notificationRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "NotificationRules":
            return Optional.ofNullable(clazz.cast(notificationRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationRulesResponse, T> g) {
        return obj -> g.apply((ListNotificationRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodestarNotificationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListNotificationRulesResponse> {
        /**
         * <p>
         * An enumeration token that can be used in a request to return the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that can be used in a request to return the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of notification rules for the AWS account, by Amazon Resource Name (ARN) and ID.
         * </p>
         * 
         * @param notificationRules
         *        The list of notification rules for the AWS account, by Amazon Resource Name (ARN) and ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationRules(Collection<NotificationRuleSummary> notificationRules);

        /**
         * <p>
         * The list of notification rules for the AWS account, by Amazon Resource Name (ARN) and ID.
         * </p>
         * 
         * @param notificationRules
         *        The list of notification rules for the AWS account, by Amazon Resource Name (ARN) and ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationRules(NotificationRuleSummary... notificationRules);

        /**
         * <p>
         * The list of notification rules for the AWS account, by Amazon Resource Name (ARN) and ID.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NotificationRuleSummary>.Builder} avoiding
         * the need to create one manually via {@link List<NotificationRuleSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NotificationRuleSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #notificationRules(List<NotificationRuleSummary>)}.
         * 
         * @param notificationRules
         *        a consumer that will call methods on {@link List<NotificationRuleSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationRules(List<NotificationRuleSummary>)
         */
        Builder notificationRules(Consumer<NotificationRuleSummary.Builder>... notificationRules);
    }

    static final class BuilderImpl extends CodestarNotificationsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<NotificationRuleSummary> notificationRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationRulesResponse model) {
            super(model);
            nextToken(model.nextToken);
            notificationRules(model.notificationRules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<NotificationRuleSummary.Builder> getNotificationRules() {
            return notificationRules != null ? notificationRules.stream().map(NotificationRuleSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder notificationRules(Collection<NotificationRuleSummary> notificationRules) {
            this.notificationRules = NotificationRuleBatchCopier.copy(notificationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationRules(NotificationRuleSummary... notificationRules) {
            notificationRules(Arrays.asList(notificationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationRules(Consumer<NotificationRuleSummary.Builder>... notificationRules) {
            notificationRules(Stream.of(notificationRules).map(c -> NotificationRuleSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNotificationRules(Collection<NotificationRuleSummary.BuilderImpl> notificationRules) {
            this.notificationRules = NotificationRuleBatchCopier.copyFromBuilder(notificationRules);
        }

        @Override
        public ListNotificationRulesResponse build() {
            return new ListNotificationRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
