/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarnotifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a filter to apply to the list of returned targets. You can filter by target type, address, or
 * status. For example, to filter results to notification rules that have active Amazon SNS topics as targets, you could
 * specify a ListTargetsFilter Name as TargetType and a Value of SNS, and a Name of TARGET_STATUS and a Value of ACTIVE.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTargetsFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListTargetsFilter.Builder, ListTargetsFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ListTargetsFilter::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(ListTargetsFilter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String value;

    private ListTargetsFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the attribute you want to use to filter the returned targets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ListTargetsFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the attribute you want to use to filter the returned targets.
     * @see ListTargetsFilterName
     */
    public ListTargetsFilterName name() {
        return ListTargetsFilterName.fromValue(name);
    }

    /**
     * <p>
     * The name of the attribute you want to use to filter the returned targets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ListTargetsFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the attribute you want to use to filter the returned targets.
     * @see ListTargetsFilterName
     */
    public String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The value of the attribute you want to use to filter the returned targets. For example, if you specify <i>SNS</i>
     * for the Target type, you could specify an Amazon Resource Name (ARN) for a topic as the value.
     * </p>
     * 
     * @return The value of the attribute you want to use to filter the returned targets. For example, if you specify
     *         <i>SNS</i> for the Target type, you could specify an Amazon Resource Name (ARN) for a topic as the value.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetsFilter)) {
            return false;
        }
        ListTargetsFilter other = (ListTargetsFilter) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTargetsFilter").add("Name", nameAsString()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTargetsFilter, T> g) {
        return obj -> g.apply((ListTargetsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListTargetsFilter> {
        /**
         * <p>
         * The name of the attribute you want to use to filter the returned targets.
         * </p>
         * 
         * @param name
         *        The name of the attribute you want to use to filter the returned targets.
         * @see ListTargetsFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListTargetsFilterName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the attribute you want to use to filter the returned targets.
         * </p>
         * 
         * @param name
         *        The name of the attribute you want to use to filter the returned targets.
         * @see ListTargetsFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListTargetsFilterName
         */
        Builder name(ListTargetsFilterName name);

        /**
         * <p>
         * The value of the attribute you want to use to filter the returned targets. For example, if you specify
         * <i>SNS</i> for the Target type, you could specify an Amazon Resource Name (ARN) for a topic as the value.
         * </p>
         * 
         * @param value
         *        The value of the attribute you want to use to filter the returned targets. For example, if you specify
         *        <i>SNS</i> for the Target type, you could specify an Amazon Resource Name (ARN) for a topic as the
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTargetsFilter model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ListTargetsFilterName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public ListTargetsFilter build() {
            return new ListTargetsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
