/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarnotifications.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventTypesResponse extends CodestarNotificationsResponse implements
        ToCopyableBuilder<ListEventTypesResponse.Builder, ListEventTypesResponse> {
    private static final SdkField<List<EventTypeSummary>> EVENT_TYPES_FIELD = SdkField
            .<List<EventTypeSummary>> builder(MarshallingType.LIST)
            .memberName("EventTypes")
            .getter(getter(ListEventTypesResponse::eventTypes))
            .setter(setter(Builder::eventTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventTypeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventTypeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEventTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EventTypeSummary> eventTypes;

    private final String nextToken;

    private ListEventTypesResponse(BuilderImpl builder) {
        super(builder);
        this.eventTypes = builder.eventTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEventTypes() {
        return eventTypes != null && !(eventTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about each event, including service name, resource type, event ID, and event name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTypes} method.
     * </p>
     * 
     * @return Information about each event, including service name, resource type, event ID, and event name.
     */
    public final List<EventTypeSummary> eventTypes() {
        return eventTypes;
    }

    /**
     * <p>
     * An enumeration token that can be used in a request to return the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that can be used in a request to return the next batch of the results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTypes() ? eventTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventTypesResponse)) {
            return false;
        }
        ListEventTypesResponse other = (ListEventTypesResponse) obj;
        return hasEventTypes() == other.hasEventTypes() && Objects.equals(eventTypes(), other.eventTypes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEventTypesResponse").add("EventTypes", hasEventTypes() ? eventTypes() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventTypes":
            return Optional.ofNullable(clazz.cast(eventTypes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventTypesResponse, T> g) {
        return obj -> g.apply((ListEventTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodestarNotificationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEventTypesResponse> {
        /**
         * <p>
         * Information about each event, including service name, resource type, event ID, and event name.
         * </p>
         * 
         * @param eventTypes
         *        Information about each event, including service name, resource type, event ID, and event name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypes(Collection<EventTypeSummary> eventTypes);

        /**
         * <p>
         * Information about each event, including service name, resource type, event ID, and event name.
         * </p>
         * 
         * @param eventTypes
         *        Information about each event, including service name, resource type, event ID, and event name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypes(EventTypeSummary... eventTypes);

        /**
         * <p>
         * Information about each event, including service name, resource type, event ID, and event name.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventTypeSummary>.Builder} avoiding the
         * need to create one manually via {@link List<EventTypeSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventTypeSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #eventTypes(List<EventTypeSummary>)}.
         * 
         * @param eventTypes
         *        a consumer that will call methods on {@link List<EventTypeSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTypes(List<EventTypeSummary>)
         */
        Builder eventTypes(Consumer<EventTypeSummary.Builder>... eventTypes);

        /**
         * <p>
         * An enumeration token that can be used in a request to return the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that can be used in a request to return the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodestarNotificationsResponse.BuilderImpl implements Builder {
        private List<EventTypeSummary> eventTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventTypesResponse model) {
            super(model);
            eventTypes(model.eventTypes);
            nextToken(model.nextToken);
        }

        public final List<EventTypeSummary.Builder> getEventTypes() {
            List<EventTypeSummary.Builder> result = EventTypeBatchCopier.copyToBuilder(this.eventTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventTypes(Collection<EventTypeSummary.BuilderImpl> eventTypes) {
            this.eventTypes = EventTypeBatchCopier.copyFromBuilder(eventTypes);
        }

        @Override
        @Transient
        public final Builder eventTypes(Collection<EventTypeSummary> eventTypes) {
            this.eventTypes = EventTypeBatchCopier.copy(eventTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventTypes(EventTypeSummary... eventTypes) {
            eventTypes(Arrays.asList(eventTypes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventTypes(Consumer<EventTypeSummary.Builder>... eventTypes) {
            eventTypes(Stream.of(eventTypes).map(c -> EventTypeSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEventTypesResponse build() {
            return new ListEventTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
