/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarnotifications.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNotificationRuleRequest extends CodestarNotificationsRequest implements
        ToCopyableBuilder<CreateNotificationRuleRequest.Builder, CreateNotificationRuleRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateNotificationRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> EVENT_TYPE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EventTypeIds")
            .getter(getter(CreateNotificationRuleRequest::eventTypeIds))
            .setter(setter(Builder::eventTypeIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTypeIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Resource").getter(getter(CreateNotificationRuleRequest::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField
            .<List<Target>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(CreateNotificationRuleRequest::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Target> builder(MarshallingType.SDK_POJO)
                                            .constructor(Target::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DETAIL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailType").getter(getter(CreateNotificationRuleRequest::detailTypeAsString))
            .setter(setter(Builder::detailType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailType").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateNotificationRuleRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateNotificationRuleRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreateNotificationRuleRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            EVENT_TYPE_IDS_FIELD, RESOURCE_FIELD, TARGETS_FIELD, DETAIL_TYPE_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD,
            STATUS_FIELD));

    private final String name;

    private final List<String> eventTypeIds;

    private final String resource;

    private final List<Target> targets;

    private final String detailType;

    private final String clientRequestToken;

    private final Map<String, String> tags;

    private final String status;

    private CreateNotificationRuleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.eventTypeIds = builder.eventTypeIds;
        this.resource = builder.resource;
        this.targets = builder.targets;
        this.detailType = builder.detailType;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name for the notification rule. Notifictaion rule names must be unique in your AWS account.
     * </p>
     * 
     * @return The name for the notification rule. Notifictaion rule names must be unique in your AWS account.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventTypeIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventTypeIds() {
        return eventTypeIds != null && !(eventTypeIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event types associated with this notification rule. For a list of allowed events, see
     * <a>EventTypeSummary</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTypeIds} method.
     * </p>
     * 
     * @return A list of event types associated with this notification rule. For a list of allowed events, see
     *         <a>EventTypeSummary</a>.
     */
    public final List<String> eventTypeIds() {
        return eventTypeIds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources
     * include pipelines in AWS CodePipeline, repositories in AWS CodeCommit, and build projects in AWS CodeBuild.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported
     *         resources include pipelines in AWS CodePipeline, repositories in AWS CodeCommit, and build projects in
     *         AWS CodeBuild.
     */
    public final String resource() {
        return resource;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Resource Names (ARNs) of SNS topics to associate with the notification rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return A list of Amazon Resource Names (ARNs) of SNS topics to associate with the notification rule.
     */
    public final List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * The level of detail to include in the notifications for this resource. BASIC will include only the contents of
     * the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS
     * CodeStar Notifications and/or the service for the resource for which the notification is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailType} will
     * return {@link DetailType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #detailTypeAsString}.
     * </p>
     * 
     * @return The level of detail to include in the notifications for this resource. BASIC will include only the
     *         contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental
     *         information provided by AWS CodeStar Notifications and/or the service for the resource for which the
     *         notification is created.
     * @see DetailType
     */
    public final DetailType detailType() {
        return DetailType.fromValue(detailType);
    }

    /**
     * <p>
     * The level of detail to include in the notifications for this resource. BASIC will include only the contents of
     * the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS
     * CodeStar Notifications and/or the service for the resource for which the notification is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailType} will
     * return {@link DetailType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #detailTypeAsString}.
     * </p>
     * 
     * @return The level of detail to include in the notifications for this resource. BASIC will include only the
     *         contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental
     *         information provided by AWS CodeStar Notifications and/or the service for the resource for which the
     *         notification is created.
     * @see DetailType
     */
    public final String detailTypeAsString() {
        return detailType;
    }

    /**
     * <p>
     * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be
     * repeated with a changed parameter. If a request with the same parameters is received and a token is included, the
     * request returns information about the initial request that used that token.
     * </p>
     * <note>
     * <p>
     * The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created for
     * you.
     * </p>
     * </note>
     * 
     * @return A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot
     *         be repeated with a changed parameter. If a request with the same parameters is received and a token is
     *         included, the request returns information about the initial request that used that token.</p> <note>
     *         <p>
     *         The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is
     *         created for you.
     *         </p>
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags to apply to this notification rule. Key names cannot start with "aws".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to apply to this notification rule. Key names cannot start with "aws".
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The status of the notification rule. The default value is ENABLED. If the status is set to DISABLED,
     * notifications aren't sent for the notification rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotificationRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the notification rule. The default value is ENABLED. If the status is set to DISABLED,
     *         notifications aren't sent for the notification rule.
     * @see NotificationRuleStatus
     */
    public final NotificationRuleStatus status() {
        return NotificationRuleStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the notification rule. The default value is ENABLED. If the status is set to DISABLED,
     * notifications aren't sent for the notification rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotificationRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the notification rule. The default value is ENABLED. If the status is set to DISABLED,
     *         notifications aren't sent for the notification rule.
     * @see NotificationRuleStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTypeIds() ? eventTypeIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(detailTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotificationRuleRequest)) {
            return false;
        }
        CreateNotificationRuleRequest other = (CreateNotificationRuleRequest) obj;
        return Objects.equals(name(), other.name()) && hasEventTypeIds() == other.hasEventTypeIds()
                && Objects.equals(eventTypeIds(), other.eventTypeIds()) && Objects.equals(resource(), other.resource())
                && hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && Objects.equals(detailTypeAsString(), other.detailTypeAsString())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNotificationRuleRequest")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EventTypeIds", hasEventTypeIds() ? eventTypeIds() : null).add("Resource", resource())
                .add("Targets", hasTargets() ? targets() : null).add("DetailType", detailTypeAsString())
                .add("ClientRequestToken", clientRequestToken()).add("Tags", hasTags() ? tags() : null)
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EventTypeIds":
            return Optional.ofNullable(clazz.cast(eventTypeIds()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "DetailType":
            return Optional.ofNullable(clazz.cast(detailTypeAsString()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNotificationRuleRequest, T> g) {
        return obj -> g.apply((CreateNotificationRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodestarNotificationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateNotificationRuleRequest> {
        /**
         * <p>
         * The name for the notification rule. Notifictaion rule names must be unique in your AWS account.
         * </p>
         * 
         * @param name
         *        The name for the notification rule. Notifictaion rule names must be unique in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of event types associated with this notification rule. For a list of allowed events, see
         * <a>EventTypeSummary</a>.
         * </p>
         * 
         * @param eventTypeIds
         *        A list of event types associated with this notification rule. For a list of allowed events, see
         *        <a>EventTypeSummary</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeIds(Collection<String> eventTypeIds);

        /**
         * <p>
         * A list of event types associated with this notification rule. For a list of allowed events, see
         * <a>EventTypeSummary</a>.
         * </p>
         * 
         * @param eventTypeIds
         *        A list of event types associated with this notification rule. For a list of allowed events, see
         *        <a>EventTypeSummary</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeIds(String... eventTypeIds);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources
         * include pipelines in AWS CodePipeline, repositories in AWS CodeCommit, and build projects in AWS CodeBuild.
         * </p>
         * 
         * @param resource
         *        The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported
         *        resources include pipelines in AWS CodePipeline, repositories in AWS CodeCommit, and build projects in
         *        AWS CodeBuild.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * A list of Amazon Resource Names (ARNs) of SNS topics to associate with the notification rule.
         * </p>
         * 
         * @param targets
         *        A list of Amazon Resource Names (ARNs) of SNS topics to associate with the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * A list of Amazon Resource Names (ARNs) of SNS topics to associate with the notification rule.
         * </p>
         * 
         * @param targets
         *        A list of Amazon Resource Names (ARNs) of SNS topics to associate with the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * A list of Amazon Resource Names (ARNs) of SNS topics to associate with the notification rule.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Target>.Builder} avoiding the need to
         * create one manually via {@link List<Target>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Target>.Builder#build()} is called immediately and its
         * result is passed to {@link #targets(List<Target>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link List<Target>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(List<Target>)
         */
        Builder targets(Consumer<Target.Builder>... targets);

        /**
         * <p>
         * The level of detail to include in the notifications for this resource. BASIC will include only the contents
         * of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by
         * AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
         * </p>
         * 
         * @param detailType
         *        The level of detail to include in the notifications for this resource. BASIC will include only the
         *        contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental
         *        information provided by AWS CodeStar Notifications and/or the service for the resource for which the
         *        notification is created.
         * @see DetailType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailType
         */
        Builder detailType(String detailType);

        /**
         * <p>
         * The level of detail to include in the notifications for this resource. BASIC will include only the contents
         * of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by
         * AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
         * </p>
         * 
         * @param detailType
         *        The level of detail to include in the notifications for this resource. BASIC will include only the
         *        contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental
         *        information provided by AWS CodeStar Notifications and/or the service for the resource for which the
         *        notification is created.
         * @see DetailType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailType
         */
        Builder detailType(DetailType detailType);

        /**
         * <p>
         * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be
         * repeated with a changed parameter. If a request with the same parameters is received and a token is included,
         * the request returns information about the initial request that used that token.
         * </p>
         * <note>
         * <p>
         * The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created
         * for you.
         * </p>
         * </note>
         * 
         * @param clientRequestToken
         *        A unique, client-generated idempotency token that, when provided in a request, ensures the request
         *        cannot be repeated with a changed parameter. If a request with the same parameters is received and a
         *        token is included, the request returns information about the initial request that used that token.</p>
         *        <note>
         *        <p>
         *        The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is
         *        created for you.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * A list of tags to apply to this notification rule. Key names cannot start with "aws".
         * </p>
         * 
         * @param tags
         *        A list of tags to apply to this notification rule. Key names cannot start with "aws".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The status of the notification rule. The default value is ENABLED. If the status is set to DISABLED,
         * notifications aren't sent for the notification rule.
         * </p>
         * 
         * @param status
         *        The status of the notification rule. The default value is ENABLED. If the status is set to DISABLED,
         *        notifications aren't sent for the notification rule.
         * @see NotificationRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationRuleStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the notification rule. The default value is ENABLED. If the status is set to DISABLED,
         * notifications aren't sent for the notification rule.
         * </p>
         * 
         * @param status
         *        The status of the notification rule. The default value is ENABLED. If the status is set to DISABLED,
         *        notifications aren't sent for the notification rule.
         * @see NotificationRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationRuleStatus
         */
        Builder status(NotificationRuleStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodestarNotificationsRequest.BuilderImpl implements Builder {
        private String name;

        private List<String> eventTypeIds = DefaultSdkAutoConstructList.getInstance();

        private String resource;

        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();

        private String detailType;

        private String clientRequestToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotificationRuleRequest model) {
            super(model);
            name(model.name);
            eventTypeIds(model.eventTypeIds);
            resource(model.resource);
            targets(model.targets);
            detailType(model.detailType);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
            status(model.status);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getEventTypeIds() {
            if (eventTypeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return eventTypeIds;
        }

        public final void setEventTypeIds(Collection<String> eventTypeIds) {
            this.eventTypeIds = EventTypeIdsCopier.copy(eventTypeIds);
        }

        @Override
        @Transient
        public final Builder eventTypeIds(Collection<String> eventTypeIds) {
            this.eventTypeIds = EventTypeIdsCopier.copy(eventTypeIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventTypeIds(String... eventTypeIds) {
            eventTypeIds(Arrays.asList(eventTypeIds));
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        @Transient
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        @Transient
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder>... targets) {
            targets(Stream.of(targets).map(c -> Target.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDetailType() {
            return detailType;
        }

        public final void setDetailType(String detailType) {
            this.detailType = detailType;
        }

        @Override
        @Transient
        public final Builder detailType(String detailType) {
            this.detailType = detailType;
            return this;
        }

        @Override
        @Transient
        public final Builder detailType(DetailType detailType) {
            this.detailType(detailType == null ? null : detailType.toString());
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(NotificationRuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNotificationRuleRequest build() {
            return new CreateNotificationRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
