/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarnotifications;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.codestarnotifications.model.CreateNotificationRuleRequest;
import software.amazon.awssdk.services.codestarnotifications.model.CreateNotificationRuleResponse;
import software.amazon.awssdk.services.codestarnotifications.model.DeleteNotificationRuleRequest;
import software.amazon.awssdk.services.codestarnotifications.model.DeleteNotificationRuleResponse;
import software.amazon.awssdk.services.codestarnotifications.model.DeleteTargetRequest;
import software.amazon.awssdk.services.codestarnotifications.model.DeleteTargetResponse;
import software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleRequest;
import software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleResponse;
import software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesRequest;
import software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesResponse;
import software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesRequest;
import software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesResponse;
import software.amazon.awssdk.services.codestarnotifications.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codestarnotifications.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest;
import software.amazon.awssdk.services.codestarnotifications.model.ListTargetsResponse;
import software.amazon.awssdk.services.codestarnotifications.model.SubscribeRequest;
import software.amazon.awssdk.services.codestarnotifications.model.SubscribeResponse;
import software.amazon.awssdk.services.codestarnotifications.model.TagResourceRequest;
import software.amazon.awssdk.services.codestarnotifications.model.TagResourceResponse;
import software.amazon.awssdk.services.codestarnotifications.model.UnsubscribeRequest;
import software.amazon.awssdk.services.codestarnotifications.model.UnsubscribeResponse;
import software.amazon.awssdk.services.codestarnotifications.model.UntagResourceRequest;
import software.amazon.awssdk.services.codestarnotifications.model.UntagResourceResponse;
import software.amazon.awssdk.services.codestarnotifications.model.UpdateNotificationRuleRequest;
import software.amazon.awssdk.services.codestarnotifications.model.UpdateNotificationRuleResponse;
import software.amazon.awssdk.services.codestarnotifications.paginators.ListEventTypesPublisher;
import software.amazon.awssdk.services.codestarnotifications.paginators.ListNotificationRulesPublisher;
import software.amazon.awssdk.services.codestarnotifications.paginators.ListTargetsPublisher;

/**
 * Service client for accessing AWS CodeStar Notifications asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * This AWS CodeStar Notifications API Reference provides descriptions and usage examples of the operations and data
 * types for the AWS CodeStar Notifications API. You can use the AWS CodeStar Notifications API to work with the
 * following objects:
 * </p>
 * <p>
 * Notification rules, by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateNotificationRule</a>, which creates a notification rule for a resource in your account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteNotificationRule</a>, which deletes a notification rule.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeNotificationRule</a>, which provides information about a notification rule.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListNotificationRules</a>, which lists the notification rules associated with your account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateNotificationRule</a>, which changes the name, events, or targets associated with a notification rule.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>Subscribe</a>, which subscribes a target to a notification rule.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>Unsubscribe</a>, which removes a target from a notification rule.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Targets, by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>DeleteTarget</a>, which removes a notification rule target from a notification rule.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListTargets</a>, which lists the targets associated with a notification rule.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Events, by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>ListEventTypes</a>, which lists the event types you can include in a notification rule.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Tags, by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>ListTagsForResource</a>, which lists the tags already associated with a notification rule in your account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>TagResource</a>, which associates a tag you provide with a notification rule in your account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UntagResource</a>, which removes a tag from a notification rule in your account.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For information about how to use AWS CodeStar Notifications, see the <a
 * href="https://docs.aws.amazon.com/dtconsole/latest/userguide/what-is-dtconsole.html">Amazon Web Services Developer
 * Tools Console User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CodestarNotificationsAsyncClient extends SdkClient {
    String SERVICE_NAME = "codestar-notifications";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "codestar-notifications";

    /**
     * <p>
     * Creates a notification rule for a resource. The rule specifies the events you want notifications about and the
     * targets (such as Chatbot topics or Chatbot clients configured for Slack) where you want to receive them.
     * </p>
     *
     * @param createNotificationRuleRequest
     * @return A Java Future containing the result of the CreateNotificationRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException A resource with the same name or ID already exists. Notification rule
     *         names must be unique in your Amazon Web Services account.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>LimitExceededException One of the AWS CodeStar Notifications limits has been exceeded. Limits apply
     *         to accounts, notification rules, notifications, resources, and targets. For more information, see Limits.
     *         </li>
     *         <li>ConfigurationException Some or all of the configuration is incomplete, missing, or not valid.</li>
     *         <li>ConcurrentModificationException AWS CodeStar Notifications can't complete the request because the
     *         resource is being modified by another process. Wait a few minutes and try again.</li>
     *         <li>AccessDeniedException AWS CodeStar Notifications can't create the notification rule because you do
     *         not have sufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.CreateNotificationRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/CreateNotificationRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNotificationRuleResponse> createNotificationRule(
            CreateNotificationRuleRequest createNotificationRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a notification rule for a resource. The rule specifies the events you want notifications about and the
     * targets (such as Chatbot topics or Chatbot clients configured for Slack) where you want to receive them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNotificationRuleRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNotificationRuleRequest#builder()}
     * </p>
     *
     * @param createNotificationRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateNotificationRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateNotificationRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException A resource with the same name or ID already exists. Notification rule
     *         names must be unique in your Amazon Web Services account.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>LimitExceededException One of the AWS CodeStar Notifications limits has been exceeded. Limits apply
     *         to accounts, notification rules, notifications, resources, and targets. For more information, see Limits.
     *         </li>
     *         <li>ConfigurationException Some or all of the configuration is incomplete, missing, or not valid.</li>
     *         <li>ConcurrentModificationException AWS CodeStar Notifications can't complete the request because the
     *         resource is being modified by another process. Wait a few minutes and try again.</li>
     *         <li>AccessDeniedException AWS CodeStar Notifications can't create the notification rule because you do
     *         not have sufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.CreateNotificationRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/CreateNotificationRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNotificationRuleResponse> createNotificationRule(
            Consumer<CreateNotificationRuleRequest.Builder> createNotificationRuleRequest) {
        return createNotificationRule(CreateNotificationRuleRequest.builder().applyMutation(createNotificationRuleRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a notification rule for a resource.
     * </p>
     *
     * @param deleteNotificationRuleRequest
     * @return A Java Future containing the result of the DeleteNotificationRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>LimitExceededException One of the AWS CodeStar Notifications limits has been exceeded. Limits apply
     *         to accounts, notification rules, notifications, resources, and targets. For more information, see Limits.
     *         </li>
     *         <li>ConcurrentModificationException AWS CodeStar Notifications can't complete the request because the
     *         resource is being modified by another process. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.DeleteNotificationRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/DeleteNotificationRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNotificationRuleResponse> deleteNotificationRule(
            DeleteNotificationRuleRequest deleteNotificationRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a notification rule for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotificationRuleRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNotificationRuleRequest#builder()}
     * </p>
     *
     * @param deleteNotificationRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNotificationRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteNotificationRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>LimitExceededException One of the AWS CodeStar Notifications limits has been exceeded. Limits apply
     *         to accounts, notification rules, notifications, resources, and targets. For more information, see Limits.
     *         </li>
     *         <li>ConcurrentModificationException AWS CodeStar Notifications can't complete the request because the
     *         resource is being modified by another process. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.DeleteNotificationRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/DeleteNotificationRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNotificationRuleResponse> deleteNotificationRule(
            Consumer<DeleteNotificationRuleRequest.Builder> deleteNotificationRuleRequest) {
        return deleteNotificationRule(DeleteNotificationRuleRequest.builder().applyMutation(deleteNotificationRuleRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a specified target for notifications.
     * </p>
     *
     * @param deleteTargetRequest
     * @return A Java Future containing the result of the DeleteTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.DeleteTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/DeleteTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTargetResponse> deleteTarget(DeleteTargetRequest deleteTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified target for notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTargetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTargetRequest#builder()}
     * </p>
     *
     * @param deleteTargetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTargetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.DeleteTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/DeleteTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTargetResponse> deleteTarget(Consumer<DeleteTargetRequest.Builder> deleteTargetRequest) {
        return deleteTarget(DeleteTargetRequest.builder().applyMutation(deleteTargetRequest).build());
    }

    /**
     * <p>
     * Returns information about a specified notification rule.
     * </p>
     *
     * @param describeNotificationRuleRequest
     * @return A Java Future containing the result of the DescribeNotificationRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException AWS CodeStar Notifications can't find a resource that matches the provided
     *         ARN.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.DescribeNotificationRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/DescribeNotificationRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNotificationRuleResponse> describeNotificationRule(
            DescribeNotificationRuleRequest describeNotificationRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specified notification rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotificationRuleRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeNotificationRuleRequest#builder()}
     * </p>
     *
     * @param describeNotificationRuleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeNotificationRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeNotificationRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException AWS CodeStar Notifications can't find a resource that matches the provided
     *         ARN.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.DescribeNotificationRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/DescribeNotificationRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNotificationRuleResponse> describeNotificationRule(
            Consumer<DescribeNotificationRuleRequest.Builder> describeNotificationRuleRequest) {
        return describeNotificationRule(DescribeNotificationRuleRequest.builder().applyMutation(describeNotificationRuleRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the event types available for configuring notifications.
     * </p>
     *
     * @param listEventTypesRequest
     * @return A Java Future containing the result of the ListEventTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value for the enumeration token used in the request to return the next
     *         batch of the results is not valid.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.ListEventTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListEventTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventTypesResponse> listEventTypes(ListEventTypesRequest listEventTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the event types available for configuring notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventTypesRequest#builder()}
     * </p>
     *
     * @param listEventTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListEventTypesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListEventTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value for the enumeration token used in the request to return the next
     *         batch of the results is not valid.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.ListEventTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListEventTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventTypesResponse> listEventTypes(Consumer<ListEventTypesRequest.Builder> listEventTypesRequest) {
        return listEventTypes(ListEventTypesRequest.builder().applyMutation(listEventTypesRequest).build());
    }

    /**
     * <p>
     * Returns information about the event types available for configuring notifications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventTypes(software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarnotifications.paginators.ListEventTypesPublisher publisher = client.listEventTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarnotifications.paginators.ListEventTypesPublisher publisher = client.listEventTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventTypes(software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value for the enumeration token used in the request to return the next
     *         batch of the results is not valid.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.ListEventTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListEventTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventTypesPublisher listEventTypesPaginator(ListEventTypesRequest listEventTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the event types available for configuring notifications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventTypes(software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarnotifications.paginators.ListEventTypesPublisher publisher = client.listEventTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarnotifications.paginators.ListEventTypesPublisher publisher = client.listEventTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventTypes(software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventTypesRequest#builder()}
     * </p>
     *
     * @param listEventTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListEventTypesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value for the enumeration token used in the request to return the next
     *         batch of the results is not valid.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.ListEventTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListEventTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventTypesPublisher listEventTypesPaginator(Consumer<ListEventTypesRequest.Builder> listEventTypesRequest) {
        return listEventTypesPaginator(ListEventTypesRequest.builder().applyMutation(listEventTypesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the notification rules for an Amazon Web Services account.
     * </p>
     *
     * @param listNotificationRulesRequest
     * @return A Java Future containing the result of the ListNotificationRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value for the enumeration token used in the request to return the next
     *         batch of the results is not valid.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.ListNotificationRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListNotificationRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationRulesResponse> listNotificationRules(
            ListNotificationRulesRequest listNotificationRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the notification rules for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationRulesRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotificationRulesRequest#builder()}
     * </p>
     *
     * @param listNotificationRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListNotificationRulesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListNotificationRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value for the enumeration token used in the request to return the next
     *         batch of the results is not valid.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.ListNotificationRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListNotificationRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationRulesResponse> listNotificationRules(
            Consumer<ListNotificationRulesRequest.Builder> listNotificationRulesRequest) {
        return listNotificationRules(ListNotificationRulesRequest.builder().applyMutation(listNotificationRulesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the notification rules for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotificationRules(software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarnotifications.paginators.ListNotificationRulesPublisher publisher = client.listNotificationRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarnotifications.paginators.ListNotificationRulesPublisher publisher = client.listNotificationRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationRules(software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value for the enumeration token used in the request to return the next
     *         batch of the results is not valid.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.ListNotificationRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListNotificationRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationRulesPublisher listNotificationRulesPaginator(
            ListNotificationRulesRequest listNotificationRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the notification rules for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotificationRules(software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarnotifications.paginators.ListNotificationRulesPublisher publisher = client.listNotificationRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarnotifications.paginators.ListNotificationRulesPublisher publisher = client.listNotificationRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationRules(software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationRulesRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotificationRulesRequest#builder()}
     * </p>
     *
     * @param listNotificationRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListNotificationRulesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value for the enumeration token used in the request to return the next
     *         batch of the results is not valid.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.ListNotificationRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListNotificationRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationRulesPublisher listNotificationRulesPaginator(
            Consumer<ListNotificationRulesRequest.Builder> listNotificationRulesRequest) {
        return listNotificationRulesPaginator(ListNotificationRulesRequest.builder().applyMutation(listNotificationRulesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the tags associated with a notification rule.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException AWS CodeStar Notifications can't find a resource that matches the provided
     *         ARN.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the tags associated with a notification rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException AWS CodeStar Notifications can't find a resource that matches the provided
     *         ARN.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of the notification rule targets for an Amazon Web Services account.
     * </p>
     *
     * @param listTargetsRequest
     * @return A Java Future containing the result of the ListTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value for the enumeration token used in the request to return the next
     *         batch of the results is not valid.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.ListTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTargetsResponse> listTargets(ListTargetsRequest listTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the notification rule targets for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTargetsRequest#builder()}
     * </p>
     *
     * @param listTargetsRequest
     *        A {@link Consumer} that will call methods on {@link ListTargetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value for the enumeration token used in the request to return the next
     *         batch of the results is not valid.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.ListTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTargetsResponse> listTargets(Consumer<ListTargetsRequest.Builder> listTargetsRequest) {
        return listTargets(ListTargetsRequest.builder().applyMutation(listTargetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the notification rule targets for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTargets(software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarnotifications.paginators.ListTargetsPublisher publisher = client.listTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarnotifications.paginators.ListTargetsPublisher publisher = client.listTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codestarnotifications.model.ListTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codestarnotifications.model.ListTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargets(software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTargetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value for the enumeration token used in the request to return the next
     *         batch of the results is not valid.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.ListTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTargetsPublisher listTargetsPaginator(ListTargetsRequest listTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the notification rule targets for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTargets(software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarnotifications.paginators.ListTargetsPublisher publisher = client.listTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codestarnotifications.paginators.ListTargetsPublisher publisher = client.listTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codestarnotifications.model.ListTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codestarnotifications.model.ListTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargets(software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTargetsRequest#builder()}
     * </p>
     *
     * @param listTargetsRequest
     *        A {@link Consumer} that will call methods on {@link ListTargetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The value for the enumeration token used in the request to return the next
     *         batch of the results is not valid.</li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.ListTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTargetsPublisher listTargetsPaginator(Consumer<ListTargetsRequest.Builder> listTargetsRequest) {
        return listTargetsPaginator(ListTargetsRequest.builder().applyMutation(listTargetsRequest).build());
    }

    /**
     * <p>
     * Creates an association between a notification rule and an Chatbot topic or Chatbot client so that the associated
     * target can receive notifications when the events described in the rule are triggered.
     * </p>
     *
     * @param subscribeRequest
     * @return A Java Future containing the result of the Subscribe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException AWS CodeStar Notifications can't find a resource that matches the provided
     *         ARN.</li>
     *         <li>ConfigurationException Some or all of the configuration is incomplete, missing, or not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.Subscribe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/Subscribe"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SubscribeResponse> subscribe(SubscribeRequest subscribeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between a notification rule and an Chatbot topic or Chatbot client so that the associated
     * target can receive notifications when the events described in the rule are triggered.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubscribeRequest.Builder} avoiding the need to
     * create one manually via {@link SubscribeRequest#builder()}
     * </p>
     *
     * @param subscribeRequest
     *        A {@link Consumer} that will call methods on {@link SubscribeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the Subscribe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException AWS CodeStar Notifications can't find a resource that matches the provided
     *         ARN.</li>
     *         <li>ConfigurationException Some or all of the configuration is incomplete, missing, or not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.Subscribe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/Subscribe"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SubscribeResponse> subscribe(Consumer<SubscribeRequest.Builder> subscribeRequest) {
        return subscribe(SubscribeRequest.builder().applyMutation(subscribeRequest).build());
    }

    /**
     * <p>
     * Associates a set of provided tags with a notification rule.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException AWS CodeStar Notifications can't find a resource that matches the provided
     *         ARN.</li>
     *         <li>LimitExceededException One of the AWS CodeStar Notifications limits has been exceeded. Limits apply
     *         to accounts, notification rules, notifications, resources, and targets. For more information, see Limits.
     *         </li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>ConcurrentModificationException AWS CodeStar Notifications can't complete the request because the
     *         resource is being modified by another process. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a set of provided tags with a notification rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException AWS CodeStar Notifications can't find a resource that matches the provided
     *         ARN.</li>
     *         <li>LimitExceededException One of the AWS CodeStar Notifications limits has been exceeded. Limits apply
     *         to accounts, notification rules, notifications, resources, and targets. For more information, see Limits.
     *         </li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>ConcurrentModificationException AWS CodeStar Notifications can't complete the request because the
     *         resource is being modified by another process. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes an association between a notification rule and an Chatbot topic so that subscribers to that topic stop
     * receiving notifications when the events described in the rule are triggered.
     * </p>
     *
     * @param unsubscribeRequest
     * @return A Java Future containing the result of the Unsubscribe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.Unsubscribe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/Unsubscribe"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UnsubscribeResponse> unsubscribe(UnsubscribeRequest unsubscribeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an association between a notification rule and an Chatbot topic so that subscribers to that topic stop
     * receiving notifications when the events described in the rule are triggered.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnsubscribeRequest.Builder} avoiding the need to
     * create one manually via {@link UnsubscribeRequest#builder()}
     * </p>
     *
     * @param unsubscribeRequest
     *        A {@link Consumer} that will call methods on {@link UnsubscribeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the Unsubscribe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.Unsubscribe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/Unsubscribe"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UnsubscribeResponse> unsubscribe(Consumer<UnsubscribeRequest.Builder> unsubscribeRequest) {
        return unsubscribe(UnsubscribeRequest.builder().applyMutation(unsubscribeRequest).build());
    }

    /**
     * <p>
     * Removes the association between one or more provided tags and a notification rule.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException AWS CodeStar Notifications can't find a resource that matches the provided
     *         ARN.</li>
     *         <li>LimitExceededException One of the AWS CodeStar Notifications limits has been exceeded. Limits apply
     *         to accounts, notification rules, notifications, resources, and targets. For more information, see Limits.
     *         </li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>ConcurrentModificationException AWS CodeStar Notifications can't complete the request because the
     *         resource is being modified by another process. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association between one or more provided tags and a notification rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException AWS CodeStar Notifications can't find a resource that matches the provided
     *         ARN.</li>
     *         <li>LimitExceededException One of the AWS CodeStar Notifications limits has been exceeded. Limits apply
     *         to accounts, notification rules, notifications, resources, and targets. For more information, see Limits.
     *         </li>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>ConcurrentModificationException AWS CodeStar Notifications can't complete the request because the
     *         resource is being modified by another process. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a notification rule for a resource. You can change the events that trigger the notification rule, the
     * status of the rule, and the targets that receive the notifications.
     * </p>
     * <note>
     * <p>
     * To add or remove tags for a notification rule, you must use <a>TagResource</a> and <a>UntagResource</a>.
     * </p>
     * </note>
     *
     * @param updateNotificationRuleRequest
     * @return A Java Future containing the result of the UpdateNotificationRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException AWS CodeStar Notifications can't find a resource that matches the provided
     *         ARN.</li>
     *         <li>ConfigurationException Some or all of the configuration is incomplete, missing, or not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.UpdateNotificationRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/UpdateNotificationRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNotificationRuleResponse> updateNotificationRule(
            UpdateNotificationRuleRequest updateNotificationRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a notification rule for a resource. You can change the events that trigger the notification rule, the
     * status of the rule, and the targets that receive the notifications.
     * </p>
     * <note>
     * <p>
     * To add or remove tags for a notification rule, you must use <a>TagResource</a> and <a>UntagResource</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNotificationRuleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNotificationRuleRequest#builder()}
     * </p>
     *
     * @param updateNotificationRuleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNotificationRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateNotificationRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException AWS CodeStar Notifications can't find a resource that matches the provided
     *         ARN.</li>
     *         <li>ConfigurationException Some or all of the configuration is incomplete, missing, or not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodestarNotificationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CodestarNotificationsAsyncClient.UpdateNotificationRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/UpdateNotificationRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNotificationRuleResponse> updateNotificationRule(
            Consumer<UpdateNotificationRuleRequest.Builder> updateNotificationRuleRequest) {
        return updateNotificationRule(UpdateNotificationRuleRequest.builder().applyMutation(updateNotificationRuleRequest)
                .build());
    }

    /**
     * Create a {@link CodestarNotificationsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CodestarNotificationsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CodestarNotificationsAsyncClient}.
     */
    static CodestarNotificationsAsyncClientBuilder builder() {
        return new DefaultCodestarNotificationsAsyncClientBuilder();
    }
}
