/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarnotifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about an event that has triggered a notification rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventTypeSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EventTypeSummary.Builder, EventTypeSummary> {
    private static final SdkField<String> EVENT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventTypeId").getter(getter(EventTypeSummary::eventTypeId)).setter(setter(Builder::eventTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTypeId").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(EventTypeSummary::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventTypeName").getter(getter(EventTypeSummary::eventTypeName)).setter(setter(Builder::eventTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTypeName").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(EventTypeSummary::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_ID_FIELD,
            SERVICE_NAME_FIELD, EVENT_TYPE_NAME_FIELD, RESOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventTypeId;

    private final String serviceName;

    private final String eventTypeName;

    private final String resourceType;

    private EventTypeSummary(BuilderImpl builder) {
        this.eventTypeId = builder.eventTypeId;
        this.serviceName = builder.serviceName;
        this.eventTypeName = builder.eventTypeName;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The system-generated ID of the event. For a complete list of event types and IDs, see <a
     * href="https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api"
     * >Notification concepts</a> in the <i>Developer Tools Console User Guide</i>.
     * </p>
     * 
     * @return The system-generated ID of the event. For a complete list of event types and IDs, see <a
     *         href="https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api"
     *         >Notification concepts</a> in the <i>Developer Tools Console User Guide</i>.
     */
    public final String eventTypeId() {
        return eventTypeId;
    }

    /**
     * <p>
     * The name of the service for which the event applies.
     * </p>
     * 
     * @return The name of the service for which the event applies.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The name of the event.
     * </p>
     * 
     * @return The name of the event.
     */
    public final String eventTypeName() {
        return eventTypeName;
    }

    /**
     * <p>
     * The resource type of the event.
     * </p>
     * 
     * @return The resource type of the event.
     */
    public final String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTypeSummary)) {
            return false;
        }
        EventTypeSummary other = (EventTypeSummary) obj;
        return Objects.equals(eventTypeId(), other.eventTypeId()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(eventTypeName(), other.eventTypeName()) && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventTypeSummary").add("EventTypeId", eventTypeId()).add("ServiceName", serviceName())
                .add("EventTypeName", eventTypeName()).add("ResourceType", resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventTypeId":
            return Optional.ofNullable(clazz.cast(eventTypeId()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "EventTypeName":
            return Optional.ofNullable(clazz.cast(eventTypeName()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventTypeId", EVENT_TYPE_ID_FIELD);
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("EventTypeName", EVENT_TYPE_NAME_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventTypeSummary, T> g) {
        return obj -> g.apply((EventTypeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventTypeSummary> {
        /**
         * <p>
         * The system-generated ID of the event. For a complete list of event types and IDs, see <a
         * href="https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api"
         * >Notification concepts</a> in the <i>Developer Tools Console User Guide</i>.
         * </p>
         * 
         * @param eventTypeId
         *        The system-generated ID of the event. For a complete list of event types and IDs, see <a href=
         *        "https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api"
         *        >Notification concepts</a> in the <i>Developer Tools Console User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeId(String eventTypeId);

        /**
         * <p>
         * The name of the service for which the event applies.
         * </p>
         * 
         * @param serviceName
         *        The name of the service for which the event applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The name of the event.
         * </p>
         * 
         * @param eventTypeName
         *        The name of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeName(String eventTypeName);

        /**
         * <p>
         * The resource type of the event.
         * </p>
         * 
         * @param resourceType
         *        The resource type of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);
    }

    static final class BuilderImpl implements Builder {
        private String eventTypeId;

        private String serviceName;

        private String eventTypeName;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(EventTypeSummary model) {
            eventTypeId(model.eventTypeId);
            serviceName(model.serviceName);
            eventTypeName(model.eventTypeName);
            resourceType(model.resourceType);
        }

        public final String getEventTypeId() {
            return eventTypeId;
        }

        public final void setEventTypeId(String eventTypeId) {
            this.eventTypeId = eventTypeId;
        }

        @Override
        public final Builder eventTypeId(String eventTypeId) {
            this.eventTypeId = eventTypeId;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getEventTypeName() {
            return eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public EventTypeSummary build() {
            return new EventTypeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
