/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the GetId action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetIdRequest extends AmazonWebServiceRequest implements ToCopyableBuilder<GetIdRequest.Builder, GetIdRequest> {
    private final String accountId;

    private final String identityPoolId;

    private final Map<String, String> logins;

    private GetIdRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.identityPoolId = builder.identityPoolId;
        this.logins = builder.logins;
    }

    /**
     * <p>
     * A standard AWS account ID (9+ digits).
     * </p>
     * 
     * @return A standard AWS account ID (9+ digits).
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * A set of optional name-value pairs that map provider names to provider tokens. The available provider names for
     * <code>Logins</code> are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Facebook: <code>graph.facebook.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito Identity Provider: <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Google: <code>accounts.google.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon: <code>www.amazon.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Twitter: <code>api.twitter.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Digits: <code>www.digits.com</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return A set of optional name-value pairs that map provider names to provider tokens. The available provider
     *         names for <code>Logins</code> are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Facebook: <code>graph.facebook.com</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Cognito Identity Provider: <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Google: <code>accounts.google.com</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon: <code>www.amazon.com</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Twitter: <code>api.twitter.com</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Digits: <code>www.digits.com</code>
     *         </p>
     *         </li>
     */
    public Map<String, String> logins() {
        return logins;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((accountId() == null) ? 0 : accountId().hashCode());
        hashCode = 31 * hashCode + ((identityPoolId() == null) ? 0 : identityPoolId().hashCode());
        hashCode = 31 * hashCode + ((logins() == null) ? 0 : logins().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdRequest)) {
            return false;
        }
        GetIdRequest other = (GetIdRequest) obj;
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.logins() == null ^ this.logins() == null) {
            return false;
        }
        if (other.logins() != null && !other.logins().equals(this.logins())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (accountId() != null) {
            sb.append("AccountId: ").append(accountId()).append(",");
        }
        if (identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(identityPoolId()).append(",");
        }
        if (logins() != null) {
            sb.append("Logins: ").append(logins()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetIdRequest> {
        /**
         * <p>
         * A standard AWS account ID (9+ digits).
         * </p>
         * 
         * @param accountId
         *        A standard AWS account ID (9+ digits).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * A set of optional name-value pairs that map provider names to provider tokens. The available provider names
         * for <code>Logins</code> are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Facebook: <code>graph.facebook.com</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Cognito Identity Provider: <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Google: <code>accounts.google.com</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon: <code>www.amazon.com</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Twitter: <code>api.twitter.com</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Digits: <code>www.digits.com</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param logins
         *        A set of optional name-value pairs that map provider names to provider tokens. The available provider
         *        names for <code>Logins</code> are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Facebook: <code>graph.facebook.com</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Cognito Identity Provider: <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Google: <code>accounts.google.com</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon: <code>www.amazon.com</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Twitter: <code>api.twitter.com</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Digits: <code>www.digits.com</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(Map<String, String> logins);
    }

    private static final class BuilderImpl implements Builder {
        private String accountId;

        private String identityPoolId;

        private Map<String, String> logins;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdRequest model) {
            setAccountId(model.accountId);
            setIdentityPoolId(model.identityPoolId);
            setLogins(model.logins);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Map<String, String> getLogins() {
            return logins;
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        @Override
        public GetIdRequest build() {
            return new GetIdRequest(this);
        }
    }
}
