/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the GetOpenIdToken action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetOpenIdTokenRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetOpenIdTokenRequest.Builder, GetOpenIdTokenRequest> {
    private final String identityId;

    private final Map<String, String> logins;

    private GetOpenIdTokenRequest(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.logins = builder.logins;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * A set of optional name-value pairs that map provider names to provider tokens. When using graph.facebook.com and
     * www.amazon.com, supply the access_token returned from the provider's authflow. For accounts.google.com, an Amazon
     * Cognito Identity Provider, or any other OpenId Connect provider, always include the <code>id_token</code>.
     * </p>
     * 
     * @return A set of optional name-value pairs that map provider names to provider tokens. When using
     *         graph.facebook.com and www.amazon.com, supply the access_token returned from the provider's authflow. For
     *         accounts.google.com, an Amazon Cognito Identity Provider, or any other OpenId Connect provider, always
     *         include the <code>id_token</code>.
     */
    public Map<String, String> logins() {
        return logins;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identityId() == null) ? 0 : identityId().hashCode());
        hashCode = 31 * hashCode + ((logins() == null) ? 0 : logins().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpenIdTokenRequest)) {
            return false;
        }
        GetOpenIdTokenRequest other = (GetOpenIdTokenRequest) obj;
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.logins() == null ^ this.logins() == null) {
            return false;
        }
        if (other.logins() != null && !other.logins().equals(this.logins())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identityId() != null) {
            sb.append("IdentityId: ").append(identityId()).append(",");
        }
        if (logins() != null) {
            sb.append("Logins: ").append(logins()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetOpenIdTokenRequest> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * A set of optional name-value pairs that map provider names to provider tokens. When using graph.facebook.com
         * and www.amazon.com, supply the access_token returned from the provider's authflow. For accounts.google.com,
         * an Amazon Cognito Identity Provider, or any other OpenId Connect provider, always include the
         * <code>id_token</code>.
         * </p>
         * 
         * @param logins
         *        A set of optional name-value pairs that map provider names to provider tokens. When using
         *        graph.facebook.com and www.amazon.com, supply the access_token returned from the provider's authflow.
         *        For accounts.google.com, an Amazon Cognito Identity Provider, or any other OpenId Connect provider,
         *        always include the <code>id_token</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(Map<String, String> logins);
    }

    private static final class BuilderImpl implements Builder {
        private String identityId;

        private Map<String, String> logins;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpenIdTokenRequest model) {
            setIdentityId(model.identityId);
            setLogins(model.logins);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Map<String, String> getLogins() {
            return logins;
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        @Override
        public GetOpenIdTokenRequest build() {
            return new GetOpenIdTokenRequest(this);
        }
    }
}
