/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.cognitoidentity.transform.IdentityDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of the identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IdentityDescription implements StructuredPojo, ToCopyableBuilder<IdentityDescription.Builder, IdentityDescription> {
    private final String identityId;

    private final List<String> logins;

    private final Date creationDate;

    private final Date lastModifiedDate;

    private IdentityDescription(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * A set of optional name-value pairs that map provider names to provider tokens.
     * </p>
     * 
     * @return A set of optional name-value pairs that map provider names to provider tokens.
     */
    public List<String> logins() {
        return logins;
    }

    /**
     * <p>
     * Date on which the identity was created.
     * </p>
     * 
     * @return Date on which the identity was created.
     */
    public Date creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * Date on which the identity was last modified.
     * </p>
     * 
     * @return Date on which the identity was last modified.
     */
    public Date lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identityId() == null) ? 0 : identityId().hashCode());
        hashCode = 31 * hashCode + ((logins() == null) ? 0 : logins().hashCode());
        hashCode = 31 * hashCode + ((creationDate() == null) ? 0 : creationDate().hashCode());
        hashCode = 31 * hashCode + ((lastModifiedDate() == null) ? 0 : lastModifiedDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityDescription)) {
            return false;
        }
        IdentityDescription other = (IdentityDescription) obj;
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.logins() == null ^ this.logins() == null) {
            return false;
        }
        if (other.logins() != null && !other.logins().equals(this.logins())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.lastModifiedDate() == null ^ this.lastModifiedDate() == null) {
            return false;
        }
        if (other.lastModifiedDate() != null && !other.lastModifiedDate().equals(this.lastModifiedDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identityId() != null) {
            sb.append("IdentityId: ").append(identityId()).append(",");
        }
        if (logins() != null) {
            sb.append("Logins: ").append(logins()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        if (lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(lastModifiedDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IdentityDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, IdentityDescription> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * A set of optional name-value pairs that map provider names to provider tokens.
         * </p>
         * 
         * @param logins
         *        A set of optional name-value pairs that map provider names to provider tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(Collection<String> logins);

        /**
         * <p>
         * A set of optional name-value pairs that map provider names to provider tokens.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setLogins(java.util.Collection)} or {@link #withLogins(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param logins
         *        A set of optional name-value pairs that map provider names to provider tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(String... logins);

        /**
         * <p>
         * Date on which the identity was created.
         * </p>
         * 
         * @param creationDate
         *        Date on which the identity was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Date creationDate);

        /**
         * <p>
         * Date on which the identity was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        Date on which the identity was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Date lastModifiedDate);
    }

    private static final class BuilderImpl implements Builder {
        private String identityId;

        private List<String> logins;

        private Date creationDate;

        private Date lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityDescription model) {
            setIdentityId(model.identityId);
            setLogins(model.logins);
            setCreationDate(model.creationDate);
            setLastModifiedDate(model.lastModifiedDate);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Collection<String> getLogins() {
            return logins;
        }

        @Override
        public final Builder logins(Collection<String> logins) {
            this.logins = LoginsListCopier.copy(logins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logins(String... logins) {
            if (this.logins == null) {
                this.logins = new ArrayList<>(logins.length);
            }
            for (String e : logins) {
                this.logins.add(e);
            }
            return this;
        }

        public final void setLogins(Collection<String> logins) {
            this.logins = LoginsListCopier.copy(logins);
        }

        @SafeVarargs
        public final void setLogins(String... logins) {
            if (this.logins == null) {
                this.logins = new ArrayList<>(logins.length);
            }
            for (String e : logins) {
                this.logins.add(e);
            }
        }

        public final Date getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy(creationDate);
            return this;
        }

        public final void setCreationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy(creationDate);
        }

        public final Date getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = StandardMemberCopier.copy(lastModifiedDate);
            return this;
        }

        public final void setLastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = StandardMemberCopier.copy(lastModifiedDate);
        }

        @Override
        public IdentityDescription build() {
            return new IdentityDescription(this);
        }
    }
}
