/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the <code>MergeDeveloperIdentities</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MergeDeveloperIdentitiesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<MergeDeveloperIdentitiesRequest.Builder, MergeDeveloperIdentitiesRequest> {
    private final String sourceUserIdentifier;

    private final String destinationUserIdentifier;

    private final String developerProviderName;

    private final String identityPoolId;

    private MergeDeveloperIdentitiesRequest(BuilderImpl builder) {
        this.sourceUserIdentifier = builder.sourceUserIdentifier;
        this.destinationUserIdentifier = builder.destinationUserIdentifier;
        this.developerProviderName = builder.developerProviderName;
        this.identityPoolId = builder.identityPoolId;
    }

    /**
     * <p>
     * User identifier for the source user. The value should be a <code>DeveloperUserIdentifier</code>.
     * </p>
     * 
     * @return User identifier for the source user. The value should be a <code>DeveloperUserIdentifier</code>.
     */
    public String sourceUserIdentifier() {
        return sourceUserIdentifier;
    }

    /**
     * <p>
     * User identifier for the destination user. The value should be a <code>DeveloperUserIdentifier</code>.
     * </p>
     * 
     * @return User identifier for the destination user. The value should be a <code>DeveloperUserIdentifier</code>.
     */
    public String destinationUserIdentifier() {
        return destinationUserIdentifier;
    }

    /**
     * <p>
     * The "domain" by which Cognito will refer to your users. This is a (pseudo) domain name that you provide while
     * creating an identity pool. This name acts as a placeholder that allows your backend and the Cognito service to
     * communicate about the developer provider. For the <code>DeveloperProviderName</code>, you can use letters as well
     * as period (.), underscore (_), and dash (-).
     * </p>
     * 
     * @return The "domain" by which Cognito will refer to your users. This is a (pseudo) domain name that you provide
     *         while creating an identity pool. This name acts as a placeholder that allows your backend and the Cognito
     *         service to communicate about the developer provider. For the <code>DeveloperProviderName</code>, you can
     *         use letters as well as period (.), underscore (_), and dash (-).
     */
    public String developerProviderName() {
        return developerProviderName;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((sourceUserIdentifier() == null) ? 0 : sourceUserIdentifier().hashCode());
        hashCode = 31 * hashCode + ((destinationUserIdentifier() == null) ? 0 : destinationUserIdentifier().hashCode());
        hashCode = 31 * hashCode + ((developerProviderName() == null) ? 0 : developerProviderName().hashCode());
        hashCode = 31 * hashCode + ((identityPoolId() == null) ? 0 : identityPoolId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeDeveloperIdentitiesRequest)) {
            return false;
        }
        MergeDeveloperIdentitiesRequest other = (MergeDeveloperIdentitiesRequest) obj;
        if (other.sourceUserIdentifier() == null ^ this.sourceUserIdentifier() == null) {
            return false;
        }
        if (other.sourceUserIdentifier() != null && !other.sourceUserIdentifier().equals(this.sourceUserIdentifier())) {
            return false;
        }
        if (other.destinationUserIdentifier() == null ^ this.destinationUserIdentifier() == null) {
            return false;
        }
        if (other.destinationUserIdentifier() != null
                && !other.destinationUserIdentifier().equals(this.destinationUserIdentifier())) {
            return false;
        }
        if (other.developerProviderName() == null ^ this.developerProviderName() == null) {
            return false;
        }
        if (other.developerProviderName() != null && !other.developerProviderName().equals(this.developerProviderName())) {
            return false;
        }
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (sourceUserIdentifier() != null) {
            sb.append("SourceUserIdentifier: ").append(sourceUserIdentifier()).append(",");
        }
        if (destinationUserIdentifier() != null) {
            sb.append("DestinationUserIdentifier: ").append(destinationUserIdentifier()).append(",");
        }
        if (developerProviderName() != null) {
            sb.append("DeveloperProviderName: ").append(developerProviderName()).append(",");
        }
        if (identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(identityPoolId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, MergeDeveloperIdentitiesRequest> {
        /**
         * <p>
         * User identifier for the source user. The value should be a <code>DeveloperUserIdentifier</code>.
         * </p>
         * 
         * @param sourceUserIdentifier
         *        User identifier for the source user. The value should be a <code>DeveloperUserIdentifier</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUserIdentifier(String sourceUserIdentifier);

        /**
         * <p>
         * User identifier for the destination user. The value should be a <code>DeveloperUserIdentifier</code>.
         * </p>
         * 
         * @param destinationUserIdentifier
         *        User identifier for the destination user. The value should be a <code>DeveloperUserIdentifier</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationUserIdentifier(String destinationUserIdentifier);

        /**
         * <p>
         * The "domain" by which Cognito will refer to your users. This is a (pseudo) domain name that you provide while
         * creating an identity pool. This name acts as a placeholder that allows your backend and the Cognito service
         * to communicate about the developer provider. For the <code>DeveloperProviderName</code>, you can use letters
         * as well as period (.), underscore (_), and dash (-).
         * </p>
         * 
         * @param developerProviderName
         *        The "domain" by which Cognito will refer to your users. This is a (pseudo) domain name that you
         *        provide while creating an identity pool. This name acts as a placeholder that allows your backend and
         *        the Cognito service to communicate about the developer provider. For the
         *        <code>DeveloperProviderName</code>, you can use letters as well as period (.), underscore (_), and
         *        dash (-).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder developerProviderName(String developerProviderName);

        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);
    }

    private static final class BuilderImpl implements Builder {
        private String sourceUserIdentifier;

        private String destinationUserIdentifier;

        private String developerProviderName;

        private String identityPoolId;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeDeveloperIdentitiesRequest model) {
            setSourceUserIdentifier(model.sourceUserIdentifier);
            setDestinationUserIdentifier(model.destinationUserIdentifier);
            setDeveloperProviderName(model.developerProviderName);
            setIdentityPoolId(model.identityPoolId);
        }

        public final String getSourceUserIdentifier() {
            return sourceUserIdentifier;
        }

        @Override
        public final Builder sourceUserIdentifier(String sourceUserIdentifier) {
            this.sourceUserIdentifier = sourceUserIdentifier;
            return this;
        }

        public final void setSourceUserIdentifier(String sourceUserIdentifier) {
            this.sourceUserIdentifier = sourceUserIdentifier;
        }

        public final String getDestinationUserIdentifier() {
            return destinationUserIdentifier;
        }

        @Override
        public final Builder destinationUserIdentifier(String destinationUserIdentifier) {
            this.destinationUserIdentifier = destinationUserIdentifier;
            return this;
        }

        public final void setDestinationUserIdentifier(String destinationUserIdentifier) {
            this.destinationUserIdentifier = destinationUserIdentifier;
        }

        public final String getDeveloperProviderName() {
            return developerProviderName;
        }

        @Override
        public final Builder developerProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
            return this;
        }

        public final void setDeveloperProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public MergeDeveloperIdentitiesRequest build() {
            return new MergeDeveloperIdentitiesRequest(this);
        }
    }
}
