/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.transform.RulesConfigurationTypeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RulesConfigurationType implements StructuredPojo,
        ToCopyableBuilder<RulesConfigurationType.Builder, RulesConfigurationType> {
    private final List<MappingRule> rules;

    private RulesConfigurationType(BuilderImpl builder) {
        this.rules = builder.rules;
    }

    /**
     * <p>
     * An array of rules. You can specify up to 25 rules per identity provider.
     * </p>
     * <p>
     * Rules are evaluated in order. The first one to match specifies the role.
     * </p>
     * 
     * @return An array of rules. You can specify up to 25 rules per identity provider.</p>
     *         <p>
     *         Rules are evaluated in order. The first one to match specifies the role.
     */
    public List<MappingRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((rules() == null) ? 0 : rules().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RulesConfigurationType)) {
            return false;
        }
        RulesConfigurationType other = (RulesConfigurationType) obj;
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        if (other.rules() != null && !other.rules().equals(this.rules())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (rules() != null) {
            sb.append("Rules: ").append(rules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RulesConfigurationTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RulesConfigurationType> {
        /**
         * <p>
         * An array of rules. You can specify up to 25 rules per identity provider.
         * </p>
         * <p>
         * Rules are evaluated in order. The first one to match specifies the role.
         * </p>
         * 
         * @param rules
         *        An array of rules. You can specify up to 25 rules per identity provider.</p>
         *        <p>
         *        Rules are evaluated in order. The first one to match specifies the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<MappingRule> rules);

        /**
         * <p>
         * An array of rules. You can specify up to 25 rules per identity provider.
         * </p>
         * <p>
         * Rules are evaluated in order. The first one to match specifies the role.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setRules(java.util.Collection)} or {@link #withRules(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param rules
         *        An array of rules. You can specify up to 25 rules per identity provider.</p>
         *        <p>
         *        Rules are evaluated in order. The first one to match specifies the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(MappingRule... rules);
    }

    private static final class BuilderImpl implements Builder {
        private List<MappingRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(RulesConfigurationType model) {
            setRules(model.rules);
        }

        public final Collection<MappingRule> getRules() {
            return rules;
        }

        @Override
        public final Builder rules(Collection<MappingRule> rules) {
            this.rules = MappingRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(MappingRule... rules) {
            if (this.rules == null) {
                this.rules = new ArrayList<>(rules.length);
            }
            for (MappingRule e : rules) {
                this.rules.add(e);
            }
            return this;
        }

        public final void setRules(Collection<MappingRule> rules) {
            this.rules = MappingRulesListCopier.copy(rules);
        }

        @SafeVarargs
        public final void setRules(MappingRule... rules) {
            if (this.rules == null) {
                this.rules = new ArrayList<>(rules.length);
            }
            for (MappingRule e : rules) {
                this.rules.add(e);
            }
        }

        @Override
        public RulesConfigurationType build() {
            return new RulesConfigurationType(this);
        }
    }
}
