/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the UnlinkIdentity action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UnlinkIdentityRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UnlinkIdentityRequest.Builder, UnlinkIdentityRequest> {
    private final String identityId;

    private final Map<String, String> logins;

    private final List<String> loginsToRemove;

    private UnlinkIdentityRequest(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.loginsToRemove = builder.loginsToRemove;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * A set of optional name-value pairs that map provider names to provider tokens.
     * </p>
     * 
     * @return A set of optional name-value pairs that map provider names to provider tokens.
     */
    public Map<String, String> logins() {
        return logins;
    }

    /**
     * <p>
     * Provider names to unlink from this identity.
     * </p>
     * 
     * @return Provider names to unlink from this identity.
     */
    public List<String> loginsToRemove() {
        return loginsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identityId() == null) ? 0 : identityId().hashCode());
        hashCode = 31 * hashCode + ((logins() == null) ? 0 : logins().hashCode());
        hashCode = 31 * hashCode + ((loginsToRemove() == null) ? 0 : loginsToRemove().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnlinkIdentityRequest)) {
            return false;
        }
        UnlinkIdentityRequest other = (UnlinkIdentityRequest) obj;
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.logins() == null ^ this.logins() == null) {
            return false;
        }
        if (other.logins() != null && !other.logins().equals(this.logins())) {
            return false;
        }
        if (other.loginsToRemove() == null ^ this.loginsToRemove() == null) {
            return false;
        }
        if (other.loginsToRemove() != null && !other.loginsToRemove().equals(this.loginsToRemove())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identityId() != null) {
            sb.append("IdentityId: ").append(identityId()).append(",");
        }
        if (logins() != null) {
            sb.append("Logins: ").append(logins()).append(",");
        }
        if (loginsToRemove() != null) {
            sb.append("LoginsToRemove: ").append(loginsToRemove()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UnlinkIdentityRequest> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * A set of optional name-value pairs that map provider names to provider tokens.
         * </p>
         * 
         * @param logins
         *        A set of optional name-value pairs that map provider names to provider tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(Map<String, String> logins);

        /**
         * <p>
         * Provider names to unlink from this identity.
         * </p>
         * 
         * @param loginsToRemove
         *        Provider names to unlink from this identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loginsToRemove(Collection<String> loginsToRemove);

        /**
         * <p>
         * Provider names to unlink from this identity.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setLoginsToRemove(java.util.Collection)} or {@link #withLoginsToRemove(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param loginsToRemove
         *        Provider names to unlink from this identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loginsToRemove(String... loginsToRemove);
    }

    private static final class BuilderImpl implements Builder {
        private String identityId;

        private Map<String, String> logins;

        private List<String> loginsToRemove;

        private BuilderImpl() {
        }

        private BuilderImpl(UnlinkIdentityRequest model) {
            setIdentityId(model.identityId);
            setLogins(model.logins);
            setLoginsToRemove(model.loginsToRemove);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Map<String, String> getLogins() {
            return logins;
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        public final Collection<String> getLoginsToRemove() {
            return loginsToRemove;
        }

        @Override
        public final Builder loginsToRemove(Collection<String> loginsToRemove) {
            this.loginsToRemove = LoginsListCopier.copy(loginsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loginsToRemove(String... loginsToRemove) {
            if (this.loginsToRemove == null) {
                this.loginsToRemove = new ArrayList<>(loginsToRemove.length);
            }
            for (String e : loginsToRemove) {
                this.loginsToRemove.add(e);
            }
            return this;
        }

        public final void setLoginsToRemove(Collection<String> loginsToRemove) {
            this.loginsToRemove = LoginsListCopier.copy(loginsToRemove);
        }

        @SafeVarargs
        public final void setLoginsToRemove(String... loginsToRemove) {
            if (this.loginsToRemove == null) {
                this.loginsToRemove = new ArrayList<>(loginsToRemove.length);
            }
            for (String e : loginsToRemove) {
                this.loginsToRemove.add(e);
            }
        }

        @Override
        public UnlinkIdentityRequest build() {
            return new UnlinkIdentityRequest(this);
        }
    }
}
