/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.cognitoidentity.transform.CredentialsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Credentials
implements StructuredPojo,
ToCopyableBuilder<Builder, Credentials> {
    private final String accessKeyId;
    private final String secretKey;
    private final String sessionToken;
    private final Date expiration;

    private Credentials(BuilderImpl builder) {
        this.accessKeyId = builder.accessKeyId;
        this.secretKey = builder.secretKey;
        this.sessionToken = builder.sessionToken;
        this.expiration = builder.expiration;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String secretKey() {
        return this.secretKey;
    }

    public String sessionToken() {
        return this.sessionToken;
    }

    public Date expiration() {
        return this.expiration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accessKeyId() == null ? 0 : this.accessKeyId().hashCode());
        hashCode = 31 * hashCode + (this.secretKey() == null ? 0 : this.secretKey().hashCode());
        hashCode = 31 * hashCode + (this.sessionToken() == null ? 0 : this.sessionToken().hashCode());
        hashCode = 31 * hashCode + (this.expiration() == null ? 0 : this.expiration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Credentials)) {
            return false;
        }
        Credentials other = (Credentials)obj;
        if (other.accessKeyId() == null ^ this.accessKeyId() == null) {
            return false;
        }
        if (other.accessKeyId() != null && !other.accessKeyId().equals(this.accessKeyId())) {
            return false;
        }
        if (other.secretKey() == null ^ this.secretKey() == null) {
            return false;
        }
        if (other.secretKey() != null && !other.secretKey().equals(this.secretKey())) {
            return false;
        }
        if (other.sessionToken() == null ^ this.sessionToken() == null) {
            return false;
        }
        if (other.sessionToken() != null && !other.sessionToken().equals(this.sessionToken())) {
            return false;
        }
        if (other.expiration() == null ^ this.expiration() == null) {
            return false;
        }
        return other.expiration() == null || other.expiration().equals(this.expiration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accessKeyId() != null) {
            sb.append("AccessKeyId: ").append(this.accessKeyId()).append(",");
        }
        if (this.secretKey() != null) {
            sb.append("SecretKey: ").append(this.secretKey()).append(",");
        }
        if (this.sessionToken() != null) {
            sb.append("SessionToken: ").append(this.sessionToken()).append(",");
        }
        if (this.expiration() != null) {
            sb.append("Expiration: ").append(this.expiration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String accessKeyId;
        private String secretKey;
        private String sessionToken;
        private Date expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(Credentials model) {
            this.setAccessKeyId(model.accessKeyId);
            this.setSecretKey(model.secretKey);
            this.setSessionToken(model.sessionToken);
            this.setExpiration(model.expiration);
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public final String getSecretKey() {
            return this.secretKey;
        }

        @Override
        public final Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public final void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public final String getSessionToken() {
            return this.sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        public final Date getExpiration() {
            return this.expiration;
        }

        @Override
        public final Builder expiration(Date expiration) {
            this.expiration = StandardMemberCopier.copy((Date)expiration);
            return this;
        }

        public final void setExpiration(Date expiration) {
            this.expiration = StandardMemberCopier.copy((Date)expiration);
        }

        public Credentials build() {
            return new Credentials(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Credentials> {
        public Builder accessKeyId(String var1);

        public Builder secretKey(String var1);

        public Builder sessionToken(String var1);

        public Builder expiration(Date var1);
    }
}

