/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.model.MappingRule;
import software.amazon.awssdk.services.cognitoidentity.model.MappingRulesListCopier;
import software.amazon.awssdk.services.cognitoidentity.transform.RulesConfigurationTypeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RulesConfigurationType
implements StructuredPojo,
ToCopyableBuilder<Builder, RulesConfigurationType> {
    private final List<MappingRule> rules;

    private RulesConfigurationType(BuilderImpl builder) {
        this.rules = builder.rules;
    }

    public List<MappingRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.rules() == null ? 0 : this.rules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RulesConfigurationType)) {
            return false;
        }
        RulesConfigurationType other = (RulesConfigurationType)obj;
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        return other.rules() == null || other.rules().equals(this.rules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rules() != null) {
            sb.append("Rules: ").append(this.rules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RulesConfigurationTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<MappingRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(RulesConfigurationType model) {
            this.setRules(model.rules);
        }

        public final Collection<MappingRule> getRules() {
            return this.rules;
        }

        @Override
        public final Builder rules(Collection<MappingRule> rules) {
            this.rules = MappingRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(MappingRule ... rules) {
            if (this.rules == null) {
                this.rules = new ArrayList<MappingRule>(rules.length);
            }
            for (MappingRule e : rules) {
                this.rules.add(e);
            }
            return this;
        }

        public final void setRules(Collection<MappingRule> rules) {
            this.rules = MappingRulesListCopier.copy(rules);
        }

        @SafeVarargs
        public final void setRules(MappingRule ... rules) {
            if (this.rules == null) {
                this.rules = new ArrayList<MappingRule>(rules.length);
            }
            for (MappingRule e : rules) {
                this.rules.add(e);
            }
        }

        public RulesConfigurationType build() {
            return new RulesConfigurationType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RulesConfigurationType> {
        public Builder rules(Collection<MappingRule> var1);

        public Builder rules(MappingRule ... var1);
    }
}

