/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a successful ListIdentityPools action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListIdentityPoolsResponse extends CognitoIdentityResponse implements
        ToCopyableBuilder<ListIdentityPoolsResponse.Builder, ListIdentityPoolsResponse> {
    private final List<IdentityPoolShortDescription> identityPools;

    private final String nextToken;

    private ListIdentityPoolsResponse(BuilderImpl builder) {
        super(builder);
        this.identityPools = builder.identityPools;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identity pools returned by the ListIdentityPools action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The identity pools returned by the ListIdentityPools action.
     */
    public List<IdentityPoolShortDescription> identityPools() {
        return identityPools;
    }

    /**
     * <p>
     * A pagination token.
     * </p>
     * 
     * @return A pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityPools());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityPoolsResponse)) {
            return false;
        }
        ListIdentityPoolsResponse other = (ListIdentityPoolsResponse) obj;
        return Objects.equals(identityPools(), other.identityPools()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListIdentityPoolsResponse").add("IdentityPools", identityPools()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPools":
            return Optional.of(clazz.cast(identityPools()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityResponse.Builder, CopyableBuilder<Builder, ListIdentityPoolsResponse> {
        /**
         * <p>
         * The identity pools returned by the ListIdentityPools action.
         * </p>
         * 
         * @param identityPools
         *        The identity pools returned by the ListIdentityPools action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPools(Collection<IdentityPoolShortDescription> identityPools);

        /**
         * <p>
         * The identity pools returned by the ListIdentityPools action.
         * </p>
         * 
         * @param identityPools
         *        The identity pools returned by the ListIdentityPools action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPools(IdentityPoolShortDescription... identityPools);

        /**
         * <p>
         * The identity pools returned by the ListIdentityPools action.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IdentityPoolShortDescription>.Builder}
         * avoiding the need to create one manually via {@link List<IdentityPoolShortDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IdentityPoolShortDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #identityPools(List<IdentityPoolShortDescription>)}.
         * 
         * @param identityPools
         *        a consumer that will call methods on {@link List<IdentityPoolShortDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityPools(List<IdentityPoolShortDescription>)
         */
        Builder identityPools(Consumer<IdentityPoolShortDescription.Builder>... identityPools);

        /**
         * <p>
         * A pagination token.
         * </p>
         * 
         * @param nextToken
         *        A pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CognitoIdentityResponse.BuilderImpl implements Builder {
        private List<IdentityPoolShortDescription> identityPools;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityPoolsResponse model) {
            super(model);
            identityPools(model.identityPools);
            nextToken(model.nextToken);
        }

        public final Collection<IdentityPoolShortDescription.Builder> getIdentityPools() {
            return identityPools != null ? identityPools.stream().map(IdentityPoolShortDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder identityPools(Collection<IdentityPoolShortDescription> identityPools) {
            this.identityPools = IdentityPoolsListCopier.copy(identityPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPools(IdentityPoolShortDescription... identityPools) {
            identityPools(Arrays.asList(identityPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPools(Consumer<IdentityPoolShortDescription.Builder>... identityPools) {
            identityPools(Stream.of(identityPools).map(c -> IdentityPoolShortDescription.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIdentityPools(Collection<IdentityPoolShortDescription.BuilderImpl> identityPools) {
            this.identityPools = IdentityPoolsListCopier.copyFromBuilder(identityPools);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIdentityPoolsResponse build() {
            return new ListIdentityPoolsResponse(this);
        }
    }
}
