/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.LoginsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIdRequest
extends CognitoIdentityRequest
implements ToCopyableBuilder<Builder, GetIdRequest> {
    private final String accountId;
    private final String identityPoolId;
    private final Map<String, String> logins;

    private GetIdRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.identityPoolId = builder.identityPoolId;
        this.logins = builder.logins;
    }

    public String accountId() {
        return this.accountId;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Map<String, String> logins() {
        return this.logins;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logins());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdRequest)) {
            return false;
        }
        GetIdRequest other = (GetIdRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.logins(), other.logins());
    }

    public String toString() {
        return ToString.builder((String)"GetIdRequest").add("AccountId", (Object)this.accountId()).add("IdentityPoolId", (Object)this.identityPoolId()).add("Logins", this.logins()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "Logins": {
                return Optional.of(clazz.cast(this.logins()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String identityPoolId;
        private Map<String, String> logins;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.identityPoolId(model.identityPoolId);
            this.logins(model.logins);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Map<String, String> getLogins() {
            return this.logins;
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetIdRequest build() {
            return new GetIdRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityRequest.Builder,
    CopyableBuilder<Builder, GetIdRequest> {
        public Builder accountId(String var1);

        public Builder identityPoolId(String var1);

        public Builder logins(Map<String, String> var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

