/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolShortDescription;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListIdentityPoolsResponse
extends CognitoIdentityResponse
implements ToCopyableBuilder<Builder, ListIdentityPoolsResponse> {
    private final List<IdentityPoolShortDescription> identityPools;
    private final String nextToken;

    private ListIdentityPoolsResponse(BuilderImpl builder) {
        super(builder);
        this.identityPools = builder.identityPools;
        this.nextToken = builder.nextToken;
    }

    public List<IdentityPoolShortDescription> identityPools() {
        return this.identityPools;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPools());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityPoolsResponse)) {
            return false;
        }
        ListIdentityPoolsResponse other = (ListIdentityPoolsResponse)((Object)obj);
        return Objects.equals(this.identityPools(), other.identityPools()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListIdentityPoolsResponse").add("IdentityPools", this.identityPools()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPools": {
                return Optional.of(clazz.cast(this.identityPools()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityResponse.BuilderImpl
    implements Builder {
        private List<IdentityPoolShortDescription> identityPools;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityPoolsResponse model) {
            super(model);
            this.identityPools(model.identityPools);
            this.nextToken(model.nextToken);
        }

        public final Collection<IdentityPoolShortDescription.Builder> getIdentityPools() {
            return this.identityPools != null ? (Collection)this.identityPools.stream().map(IdentityPoolShortDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder identityPools(Collection<IdentityPoolShortDescription> identityPools) {
            this.identityPools = IdentityPoolsListCopier.copy(identityPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPools(IdentityPoolShortDescription ... identityPools) {
            this.identityPools(Arrays.asList(identityPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPools(Consumer<IdentityPoolShortDescription.Builder> ... identityPools) {
            this.identityPools(Stream.of(identityPools).map(c -> (IdentityPoolShortDescription)((IdentityPoolShortDescription.Builder)IdentityPoolShortDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIdentityPools(Collection<IdentityPoolShortDescription.BuilderImpl> identityPools) {
            this.identityPools = IdentityPoolsListCopier.copyFromBuilder(identityPools);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIdentityPoolsResponse build() {
            return new ListIdentityPoolsResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityResponse.Builder,
    CopyableBuilder<Builder, ListIdentityPoolsResponse> {
        public Builder identityPools(Collection<IdentityPoolShortDescription> var1);

        public Builder identityPools(IdentityPoolShortDescription ... var1);

        public Builder identityPools(Consumer<IdentityPoolShortDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

