/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.LoginsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCredentialsForIdentityRequest
extends CognitoIdentityRequest
implements ToCopyableBuilder<Builder, GetCredentialsForIdentityRequest> {
    private final String identityId;
    private final Map<String, String> logins;
    private final String customRoleArn;

    private GetCredentialsForIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.customRoleArn = builder.customRoleArn;
    }

    public String identityId() {
        return this.identityId;
    }

    public Map<String, String> logins() {
        return this.logins;
    }

    public String customRoleArn() {
        return this.customRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logins());
        hashCode = 31 * hashCode + Objects.hashCode(this.customRoleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCredentialsForIdentityRequest)) {
            return false;
        }
        GetCredentialsForIdentityRequest other = (GetCredentialsForIdentityRequest)((Object)obj);
        return Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.logins(), other.logins()) && Objects.equals(this.customRoleArn(), other.customRoleArn());
    }

    public String toString() {
        return ToString.builder((String)"GetCredentialsForIdentityRequest").add("IdentityId", (Object)this.identityId()).add("Logins", this.logins()).add("CustomRoleArn", (Object)this.customRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityId": {
                return Optional.ofNullable(clazz.cast(this.identityId()));
            }
            case "Logins": {
                return Optional.ofNullable(clazz.cast(this.logins()));
            }
            case "CustomRoleArn": {
                return Optional.ofNullable(clazz.cast(this.customRoleArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityRequest.BuilderImpl
    implements Builder {
        private String identityId;
        private Map<String, String> logins = DefaultSdkAutoConstructMap.getInstance();
        private String customRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCredentialsForIdentityRequest model) {
            super(model);
            this.identityId(model.identityId);
            this.logins(model.logins);
            this.customRoleArn(model.customRoleArn);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Map<String, String> getLogins() {
            return this.logins;
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        public final String getCustomRoleArn() {
            return this.customRoleArn;
        }

        @Override
        public final Builder customRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
            return this;
        }

        public final void setCustomRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCredentialsForIdentityRequest build() {
            return new GetCredentialsForIdentityRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityRequest.Builder,
    CopyableBuilder<Builder, GetCredentialsForIdentityRequest> {
        public Builder identityId(String var1);

        public Builder logins(Map<String, String> var1);

        public Builder customRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

