/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnlinkDeveloperIdentityRequest
extends CognitoIdentityRequest
implements ToCopyableBuilder<Builder, UnlinkDeveloperIdentityRequest> {
    private final String identityId;
    private final String identityPoolId;
    private final String developerProviderName;
    private final String developerUserIdentifier;

    private UnlinkDeveloperIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.identityPoolId = builder.identityPoolId;
        this.developerProviderName = builder.developerProviderName;
        this.developerUserIdentifier = builder.developerUserIdentifier;
    }

    public String identityId() {
        return this.identityId;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String developerProviderName() {
        return this.developerProviderName;
    }

    public String developerUserIdentifier() {
        return this.developerUserIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.developerProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.developerUserIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnlinkDeveloperIdentityRequest)) {
            return false;
        }
        UnlinkDeveloperIdentityRequest other = (UnlinkDeveloperIdentityRequest)((Object)obj);
        return Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.developerProviderName(), other.developerProviderName()) && Objects.equals(this.developerUserIdentifier(), other.developerUserIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"UnlinkDeveloperIdentityRequest").add("IdentityId", (Object)this.identityId()).add("IdentityPoolId", (Object)this.identityPoolId()).add("DeveloperProviderName", (Object)this.developerProviderName()).add("DeveloperUserIdentifier", (Object)this.developerUserIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityId": {
                return Optional.ofNullable(clazz.cast(this.identityId()));
            }
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "DeveloperProviderName": {
                return Optional.ofNullable(clazz.cast(this.developerProviderName()));
            }
            case "DeveloperUserIdentifier": {
                return Optional.ofNullable(clazz.cast(this.developerUserIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityRequest.BuilderImpl
    implements Builder {
        private String identityId;
        private String identityPoolId;
        private String developerProviderName;
        private String developerUserIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UnlinkDeveloperIdentityRequest model) {
            super(model);
            this.identityId(model.identityId);
            this.identityPoolId(model.identityPoolId);
            this.developerProviderName(model.developerProviderName);
            this.developerUserIdentifier(model.developerUserIdentifier);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getDeveloperProviderName() {
            return this.developerProviderName;
        }

        @Override
        public final Builder developerProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
            return this;
        }

        public final void setDeveloperProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
        }

        public final String getDeveloperUserIdentifier() {
            return this.developerUserIdentifier;
        }

        @Override
        public final Builder developerUserIdentifier(String developerUserIdentifier) {
            this.developerUserIdentifier = developerUserIdentifier;
            return this;
        }

        public final void setDeveloperUserIdentifier(String developerUserIdentifier) {
            this.developerUserIdentifier = developerUserIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UnlinkDeveloperIdentityRequest build() {
            return new UnlinkDeveloperIdentityRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityRequest.Builder,
    CopyableBuilder<Builder, UnlinkDeveloperIdentityRequest> {
        public Builder identityId(String var1);

        public Builder identityPoolId(String var1);

        public Builder developerProviderName(String var1);

        public Builder developerUserIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

