/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MergeDeveloperIdentitiesRequestModelMarshaller {
    private static final MarshallingInfo<String> SOURCEUSERIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceUserIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONUSERIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationUserIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> DEVELOPERPROVIDERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeveloperProviderName").isBinary(false).build();
    private static final MarshallingInfo<String> IDENTITYPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityPoolId").isBinary(false).build();
    private static final MergeDeveloperIdentitiesRequestModelMarshaller INSTANCE = new MergeDeveloperIdentitiesRequestModelMarshaller();

    private MergeDeveloperIdentitiesRequestModelMarshaller() {
    }

    public static MergeDeveloperIdentitiesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MergeDeveloperIdentitiesRequest mergeDeveloperIdentitiesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)mergeDeveloperIdentitiesRequest), (String)"mergeDeveloperIdentitiesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)mergeDeveloperIdentitiesRequest.sourceUserIdentifier(), SOURCEUSERIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)mergeDeveloperIdentitiesRequest.destinationUserIdentifier(), DESTINATIONUSERIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)mergeDeveloperIdentitiesRequest.developerProviderName(), DEVELOPERPROVIDERNAME_BINDING);
            protocolMarshaller.marshall((Object)mergeDeveloperIdentitiesRequest.identityPoolId(), IDENTITYPOOLID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

