/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.transform.IdentityPoolShortDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of the identity pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityPoolShortDescription implements StructuredPojo,
        ToCopyableBuilder<IdentityPoolShortDescription.Builder, IdentityPoolShortDescription> {
    private final String identityPoolId;

    private final String identityPoolName;

    private IdentityPoolShortDescription(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.identityPoolName = builder.identityPoolName;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * A string that you provide.
     * </p>
     * 
     * @return A string that you provide.
     */
    public String identityPoolName() {
        return identityPoolName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityPoolShortDescription)) {
            return false;
        }
        IdentityPoolShortDescription other = (IdentityPoolShortDescription) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId())
                && Objects.equals(identityPoolName(), other.identityPoolName());
    }

    @Override
    public String toString() {
        return ToString.builder("IdentityPoolShortDescription").add("IdentityPoolId", identityPoolId())
                .add("IdentityPoolName", identityPoolName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "IdentityPoolName":
            return Optional.ofNullable(clazz.cast(identityPoolName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IdentityPoolShortDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, IdentityPoolShortDescription> {
        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * A string that you provide.
         * </p>
         * 
         * @param identityPoolName
         *        A string that you provide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolName(String identityPoolName);
    }

    static final class BuilderImpl implements Builder {
        private String identityPoolId;

        private String identityPoolName;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityPoolShortDescription model) {
            identityPoolId(model.identityPoolId);
            identityPoolName(model.identityPoolName);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityPoolName() {
            return identityPoolName;
        }

        @Override
        public final Builder identityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
            return this;
        }

        public final void setIdentityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
        }

        @Override
        public IdentityPoolShortDescription build() {
            return new IdentityPoolShortDescription(this);
        }
    }
}
